/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.data;

import edu.purdue.smas.timetable.util.Config;
import edu.purdue.smas.timetable.util.Database;
import edu.purdue.smas.timetable.util.Debug;
import edu.purdue.smas.timetable.util.TTException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class TimetableConfig {
    private static Properties sProperties = new Properties();
    public static String CFG_YEAR = "YEAR";
    public static String CFG_SEMESTER = "SEMESTER";

    public static void reload() throws SQLException, TTException {
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".CONFIG");
        sProperties.clear();
        while (s.getResultSet().next()) {
            sProperties.setProperty(s.getResultSet().getString("KEY"), s.getResultSet().getString("VALUE"));
        }
        s.close();
    }

    public static boolean containsKey(String key) {
        if (sProperties == null) {
            return false;
        }
        return sProperties.containsKey(key);
    }

    public static String get(String key) {
        if (sProperties == null) {
            return null;
        }
        return sProperties.getProperty(key);
    }

    public static int getInt(String key) {
        if (sProperties == null) {
            return 0;
        }
        return Integer.parseInt(sProperties.getProperty(key, "0"));
    }

    public static long getLong(String key) {
        if (sProperties == null) {
            return 0L;
        }
        return Long.parseLong(sProperties.getProperty(key, "0"));
    }

    public static double getDouble(String key) {
        if (sProperties == null) {
            return 0.0;
        }
        return Double.parseDouble(sProperties.getProperty(key, "0"));
    }

    public static String get(String key, String defaultVal) {
        if (sProperties == null) {
            return defaultVal;
        }
        return sProperties.getProperty(key, defaultVal);
    }

    public static int getInt(String key, int defaultVal) {
        if (sProperties == null) {
            return defaultVal;
        }
        return Integer.parseInt(sProperties.getProperty(key, String.valueOf(defaultVal)));
    }

    public static long getLong(String key, long defaultVal) {
        if (sProperties == null) {
            return defaultVal;
        }
        return Long.parseLong(sProperties.getProperty(key, String.valueOf(defaultVal)));
    }

    public static double getDouble(String key, double defaultVal) {
        if (sProperties == null) {
            return defaultVal;
        }
        return Double.parseDouble(sProperties.getProperty(key, String.valueOf(defaultVal)));
    }

    public static synchronized void set(String key, Object value) throws TTException {
        if (TimetableConfig.containsKey(key)) {
            Database.executeNoOutput("update " + Config.get("SQL_SCHEMA") + ".CONFIG set " + "VALUE=" + Database.prepParam(value) + " where KEY=" + Database.prepParam(key));
        } else {
            Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".CONFIG (key, value) values (" + Database.prepParam(key) + ", " + Database.prepParam(value) + ")");
        }
        sProperties.setProperty(key, value.toString());
    }

    public static int getYear() {
        return TimetableConfig.getInt(CFG_YEAR, 2003);
    }

    public static String getSemester() {
        return TimetableConfig.get(CFG_SEMESTER, "FALL");
    }

    public static String previousSchema() {
        return "tmtbl" + (TimetableConfig.getSemester().equalsIgnoreCase("FALL") ? TimetableConfig.getYear() : TimetableConfig.getYear() - 1) + (TimetableConfig.getSemester().equalsIgnoreCase("FALL") ? "spr" : "fal");
    }

    static {
        try {
            TimetableConfig.reload();
        }
        catch (Exception e) {
            Debug.error(e);
        }
    }
}

