/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.data;

import edu.purdue.smas.timetable.data.Departments;
import edu.purdue.smas.timetable.util.Config;
import edu.purdue.smas.timetable.util.Database;
import edu.purdue.smas.timetable.util.Debug;
import edu.purdue.smas.timetable.util.TTException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Subjects {
    private static Hashtable sSubjectNames = new Hashtable();
    private static Hashtable sSubjectDepartment = new Hashtable();
    private static Vector sAllSubjects = new Vector();

    public static void load() throws TTException, SQLException {
        try {
            Statement s = Database.execute("select SUBJ_ABBV, SUBJ_NAME, DEPT_CODE from " + Config.get("SQL_SCHEMA") + ".SUBJECT order by SUBJ_ABBV");
            sSubjectNames.clear();
            sSubjectDepartment.clear();
            sAllSubjects.clear();
            while (s.getResultSet().next()) {
                sAllSubjects.addElement(s.getResultSet().getString("SUBJ_ABBV"));
                sSubjectNames.put(s.getResultSet().getString("SUBJ_ABBV"), s.getResultSet().getString("SUBJ_NAME").trim());
                sSubjectDepartment.put(s.getResultSet().getString("SUBJ_ABBV"), s.getResultSet().getString("DEPT_CODE"));
            }
            s.close();
        }
        catch (Exception e) {
            Debug.error(e);
        }
    }

    public static Enumeration elements() {
        return sSubjectNames.keys();
    }

    public static Vector allSubjects() {
        return sAllSubjects;
    }

    public static int size() {
        return sSubjectNames.size();
    }

    public static String getName(String subjectAbbv) {
        return (String)sSubjectNames.get(subjectAbbv);
    }

    public static String getDeptCode(String subjectAbbv) {
        return (String)sSubjectDepartment.get(subjectAbbv);
    }

    public static String getDeptABBV(String subjectAbbv) {
        return Departments.getABBV(Subjects.getDeptCode(subjectAbbv));
    }

    public boolean hasSubject(String subjectAbbv) {
        return sSubjectNames.containsKey(subjectAbbv);
    }

    public boolean hasDept(String deptCode) {
        return sSubjectDepartment.containsValue(deptCode);
    }

    static {
        try {
            Subjects.load();
        }
        catch (Exception e) {
            Debug.error(e);
        }
    }
}

