/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.data;

import edu.purdue.smas.timetable.util.Config;
import edu.purdue.smas.timetable.util.Database;
import edu.purdue.smas.timetable.util.Debug;
import edu.purdue.smas.timetable.util.TTException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;

public class RoomFeatures {
    private static Vector sRoomFeatures = new Vector();

    public static void load(long version) throws TTException, SQLException {
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".ROOM_FEATURE_DEF where VERSION=" + Database.prepParam(version));
        sRoomFeatures.clear();
        while (s.getResultSet().next()) {
            sRoomFeatures.addElement(new RoomFeature(s.getResultSet().getString("FEATURE_ID"), s.getResultSet().getString("NAME"), s.getResultSet().getLong("VERSION"), s.getResultSet().getString("ABBV")));
        }
        s.close();
    }

    public static Enumeration elements() {
        return sRoomFeatures.elements();
    }

    public static int size() {
        return sRoomFeatures.size();
    }

    public static RoomFeature elementAt(int i) {
        return (RoomFeature)sRoomFeatures.elementAt(i);
    }

    public int indexOf(RoomFeature feature) {
        return sRoomFeatures.indexOf(feature);
    }

    public static RoomFeature getRoomFeature(String id) {
        Enumeration e = sRoomFeatures.elements();
        while (e.hasMoreElements()) {
            RoomFeature r = (RoomFeature)e.nextElement();
            if (!r.getId().equals(id)) continue;
            return r;
        }
        return null;
    }

    static {
        try {
            RoomFeatures.load(1L);
        }
        catch (Exception e) {
            Debug.error(e);
        }
    }

    public static class RoomFeature {
        private String iId;
        private String iName;
        private String iABBV;
        private long iVersion;

        private RoomFeature(String id, String name, long version, String abbv) {
            this.iId = id;
            this.iName = name;
            this.iVersion = version;
            this.iABBV = abbv;
        }

        public String getId() {
            return this.iId;
        }

        public long getVersion() {
            return this.iVersion;
        }

        public String getName() {
            return this.iName;
        }

        public String getABBV() {
            return this.iABBV;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof RoomFeature)) {
                return false;
            }
            return this.getId().equals(((RoomFeature)o).getId());
        }

        public int hashCode() {
            return (this.iId == null ? "null" : this.iId).hashCode();
        }

        public String toString() {
            return "Feature{id=" + this.getId() + ", name=" + this.getName() + "}";
        }
    }
}

