/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.data;

import edu.purdue.smas.timetable.data.Departments;
import edu.purdue.smas.timetable.data.TimetableVersion;
import edu.purdue.smas.timetable.util.Config;
import edu.purdue.smas.timetable.util.Database;
import edu.purdue.smas.timetable.util.TTException;
import edu.purdue.smas.timetable.util.ToolBox;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Instructor {
    private String iId = null;
    private String iFirstName;
    private String iMiddleName;
    private String iLastName;
    private long iVersion;
    private Vector iDeptCodes = new Vector();
    private Vector iDeptShares = new Vector();

    public String getId() {
        return this.iId;
    }

    private void setId(String id) {
        this.iId = id;
    }

    public String getFirstName() {
        return this.iFirstName;
    }

    public void setFirstName(String firstName) {
        this.iFirstName = firstName;
    }

    public String getMiddleName() {
        return this.iMiddleName;
    }

    public void setMiddleName(String middleName) {
        this.iMiddleName = middleName;
    }

    public String getLastName() {
        return this.iLastName;
    }

    public void setLastName(String lastName) {
        this.iLastName = lastName;
    }

    public void setVersion(long version) {
        this.iVersion = version;
    }

    public boolean isEditable() {
        return this.getId() == null || this.getId().startsWith("SMAS");
    }

    public String getName() {
        String fn = this.getFirstName() == null ? "" : this.getFirstName();
        String mn = this.getMiddleName() == null ? "" : this.getMiddleName();
        String ln = this.getLastName() == null ? "" : this.getLastName();
        return ln + (ln.length() > 0 ? ", " : "") + fn + (fn.length() > 0 ? " " : "") + mn;
    }

    public long getVersion() {
        return this.iVersion;
    }

    public Vector getDeptCodes() {
        return this.iDeptCodes;
    }

    public Vector getDeptShares() {
        return this.iDeptShares;
    }

    public String getDeptsAsString() {
        return this.getDeptsAsString("<br>", "&nbsp;");
    }

    public String getDeptsAsString(String separator, String blankSpace) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.iDeptCodes.size(); ++i) {
            String deptABBV = Departments.getABBV((String)this.iDeptCodes.elementAt(i));
            double deptShare = (Double)this.iDeptShares.elementAt(i);
            sb.append(i == 0 ? "" : separator).append(ToolBox.replace(deptABBV == null ? (String)this.iDeptCodes.elementAt(i) : deptABBV, " ", blankSpace)).append(deptShare > 0.0 ? blankSpace + "(" + (int)(deptShare * 100.0) + "%)" : "");
        }
        return sb.toString();
    }

    public String getNameAsProlog() {
        return this.getName().toLowerCase().replace(' ', '_').replaceAll("[^a-z_]", "");
    }

    private static Instructor load(ResultSet rs, Hashtable deptCodeCache, Hashtable deptShareCache) throws SQLException, TTException {
        Instructor i = new Instructor();
        i.iId = rs.getString("INSTR_UID");
        i.iFirstName = rs.getString("FIRST_NAME");
        i.iMiddleName = rs.getString("MIDDLE_NAME");
        i.iLastName = rs.getString("LAST_NAME");
        i.iVersion = rs.getLong("VERSION");
        i.loadDepartments(deptCodeCache, deptShareCache, i.iVersion);
        return i;
    }

    private void loadDepartments(Hashtable deptCodeCache, Hashtable deptShareCache, long version) throws SQLException, TTException {
        if (deptCodeCache == null || deptShareCache == null) {
            Statement s = Database.execute("select DEPT_CODE, FTE from " + Config.get("SQL_SCHEMA") + ".INSTRUCTOR_DEPT where INSTR_UID=" + Database.prepParam(this.getId()) + " and VERSION=" + Database.prepParam(version));
            while (s.getResultSet().next()) {
                this.iDeptCodes.addElement(s.getResultSet().getString("DEPT_CODE"));
                this.iDeptShares.addElement(new Double(s.getResultSet().getDouble("FTE")));
            }
            s.close();
        } else {
            this.iDeptCodes = deptCodeCache.containsKey(this.getId()) ? (Vector)deptCodeCache.get(this.getId()) : new Vector();
            this.iDeptShares = deptShareCache.containsKey(this.getId()) ? (Vector)deptShareCache.get(this.getId()) : new Vector();
        }
    }

    private static Hashtable[] loadDepartmentsHash(long version) throws SQLException, TTException {
        Statement s = Database.execute("select INSTR_UID, DEPT_CODE, FTE from " + Config.get("SQL_SCHEMA") + ".INSTRUCTOR_DEPT where VERSION=" + Database.prepParam(version) + " order by INSTR_UID");
        Hashtable deptCodeCache = new Hashtable();
        Hashtable deptShareCache = new Hashtable();
        Hashtable[] ret = new Hashtable[]{deptCodeCache, deptShareCache};
        while (s.getResultSet().next()) {
            String id = s.getResultSet().getString("INSTR_UID");
            if (!deptCodeCache.containsKey(id)) {
                deptCodeCache.put(id, new Vector());
            }
            if (!deptShareCache.containsKey(id)) {
                deptShareCache.put(id, new Vector());
            }
            Vector deptCodes = (Vector)deptCodeCache.get(id);
            Vector deptShares = (Vector)deptShareCache.get(id);
            deptCodes.addElement(s.getResultSet().getString("DEPT_CODE"));
            deptShares.addElement(new Double(s.getResultSet().getDouble("FTE")));
        }
        s.close();
        return ret;
    }

    public static Instructor load(String id, long version) throws SQLException, TTException {
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".INSTRUCTOR where INSTR_UID=" + Database.prepParam(id) + " and VERSION=" + Database.prepParam(version));
        Instructor i = null;
        if (s.getResultSet().next()) {
            i = Instructor.load(s.getResultSet(), null, null);
        }
        s.close();
        return i;
    }

    public void save() throws SQLException, TTException {
        TimetableVersion.dirty(this.getVersion());
        if (this.getId() == null) {
            this.setId("SMAS" + ToolBox.expand(String.valueOf(Database.executeLong("select " + Config.get("SQL_SCHEMA") + ".SEQ_INSTRUCTORS.nextval from DUAL")), 6, '0', true));
            Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".INSTRUCTOR (instr_uid,first_name,middle_name,last_name,version) values (" + Database.prepParam(this.getId()) + ", " + Database.prepParam(this.getFirstName()) + ", " + Database.prepParam(this.getMiddleName()) + ", " + Database.prepParam(this.getLastName()) + ", " + Database.prepParam(this.getVersion()) + ")");
        } else {
            Database.executeNoOutput("update " + Config.get("SQL_SCHEMA") + ".INSTRUCTOR set " + "FIRST_NAME=" + Database.prepParam(this.getFirstName()) + ", " + "MIDDLE_NAME=" + Database.prepParam(this.getMiddleName()) + ", " + "LAST_NAME=" + Database.prepParam(this.getLastName()) + ", " + "VERSION=" + Database.prepParam(this.getVersion()) + " where INSTR_UID=" + Database.prepParam(this.getId()) + " AND VERSION=" + Database.prepParam(this.getVersion()));
        }
    }

    public static void delete(String id, long version) throws SQLException, TTException {
        TimetableVersion.dirty(version);
        Database.executeNoOutput("update " + Config.get("SQL_SCHEMA") + "CLASS set INSTR_UID=null where INSTR_UID=" + Database.prepParam(id) + " and VERSION=" + Database.prepParam(version));
        Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".INSTRUCTOR where INSTR_UID=" + Database.prepParam(id) + " and VERSION=" + Database.prepParam(version));
    }

    public void mergeTo(Instructor instructor) throws SQLException, TTException {
        if (instructor == null || instructor.getId() == null) {
            throw new TTException(this, "Unable to merge instructor -- given instructor is null or has no id.");
        }
        if (instructor.getVersion() != this.getVersion()) {
            throw new TTException(this, "Unable to merge instructor -- given instructor has different version.");
        }
        TimetableVersion.dirty(this.getVersion());
        Database.executeNoOutput("update " + Config.get("SQL_SCHEMA") + ".CLASS set INSTR_UID=" + Database.prepParam(instructor.getId()) + " where INSTR_UID=" + Database.prepParam(this.getId()) + " and VERSION=" + Database.prepParam(this.getVersion()));
        Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".INSTRUCTOR where INSTR_UID=" + Database.prepParam(this.getId()) + " and VERSION=" + Database.prepParam(this.getVersion()));
        this.setId(instructor.getId());
        this.setFirstName(instructor.getFirstName());
        this.setMiddleName(instructor.getMiddleName());
        this.setLastName(instructor.getLastName());
    }

    public static Vector loadAll(long version) throws SQLException, TTException {
        Hashtable[] deptCache = Instructor.loadDepartmentsHash(version);
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".INSTRUCTOR where VERSION=" + Database.prepParam(version) + " ORDER BY LAST_NAME, FIRST_NAME");
        Vector<Instructor> ret = new Vector<Instructor>();
        while (s.getResultSet().next()) {
            ret.addElement(Instructor.load(s.getResultSet(), deptCache[0], deptCache[1]));
        }
        s.close();
        return ret;
    }

    public static Hashtable loadAllHash(long version) throws SQLException, TTException {
        Hashtable[] deptCache = Instructor.loadDepartmentsHash(version);
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".INSTRUCTOR where VERSION=" + Database.prepParam(version));
        Hashtable<String, Instructor> ret = new Hashtable<String, Instructor>();
        while (s.getResultSet().next()) {
            Instructor i = Instructor.load(s.getResultSet(), deptCache[0], deptCache[1]);
            ret.put(i.getId(), i);
        }
        s.close();
        return ret;
    }

    public static long count(long version) throws SQLException, TTException {
        return Database.executeLong("select count(*) from " + Config.get("SQL_SCHEMA") + ".INSTRUCTOR where VERSION=" + Database.prepParam(version));
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Instructor)) {
            return false;
        }
        String id = ((Instructor)o).getId();
        if (this.getId() == null) {
            return id == null;
        }
        return id != null && this.getId().equals(id);
    }

    public boolean hasDepartment(String department) {
        return this.iDeptCodes.indexOf(department) >= 0;
    }

    public boolean hasDepartment(Vector departments) {
        Enumeration e = departments.elements();
        while (e.hasMoreElements()) {
            if (!this.hasDepartment((String)e.nextElement())) continue;
            return true;
        }
        return false;
    }
}

