/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.data;

import edu.purdue.smas.timetable.util.Config;
import edu.purdue.smas.timetable.util.Database;
import edu.purdue.smas.timetable.util.Debug;
import edu.purdue.smas.timetable.util.TTException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ITypes {
    private static Hashtable sITypes = null;
    private static Hashtable sITypesDesc = null;
    private static Vector sBasicITypes = null;

    public static void load() throws TTException, SQLException {
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".ITYPE_DESC");
        sITypes = new Hashtable();
        sITypesDesc = new Hashtable();
        sBasicITypes = new Vector();
        sITypes.clear();
        sITypesDesc.clear();
        sBasicITypes.clear();
        while (s.getResultSet().next()) {
            sITypes.put(s.getResultSet().getString("ITYPE"), s.getResultSet().getString("ABBV"));
            sITypesDesc.put(s.getResultSet().getString("ITYPE"), s.getResultSet().getString("DESCRIPTION"));
            if (s.getResultSet().getInt("BASIC") == 0) continue;
            sBasicITypes.addElement(s.getResultSet().getString("ITYPE"));
        }
        s.close();
    }

    public static Enumeration getITypes() {
        return sITypes.keys();
    }

    public static Enumeration getBasicITypes() {
        return sBasicITypes.elements();
    }

    public static String getLongDescription(String itype) {
        return itype == null ? null : (sITypesDesc.containsKey(itype) ? (String)sITypesDesc.get(itype) : null);
    }

    public static String getDescription(String itype) {
        return itype == null ? null : (sITypes.containsKey(itype) ? (String)sITypes.get(itype) : null);
    }

    public static boolean isBasic(String itype) {
        return sBasicITypes.indexOf(itype) >= 0;
    }

    public static int size() {
        return sITypes.size();
    }

    static {
        try {
            ITypes.load();
        }
        catch (Exception e) {
            Debug.error(e);
        }
    }
}

