/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.data;

import edu.purdue.smas.timetable.data.Class;
import edu.purdue.smas.timetable.data.GroupConstraintTypes;
import edu.purdue.smas.timetable.data.ITypes;
import edu.purdue.smas.timetable.data.Preferences;
import edu.purdue.smas.timetable.data.TimetableVersion;
import edu.purdue.smas.timetable.data.User;
import edu.purdue.smas.timetable.util.Config;
import edu.purdue.smas.timetable.util.Constants;
import edu.purdue.smas.timetable.util.Database;
import edu.purdue.smas.timetable.util.Debug;
import edu.purdue.smas.timetable.util.TTException;
import edu.purdue.smas.timetable.util.ToolBox;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;

public class GroupConstraint {
    private long iGroupId = -1L;
    private GroupConstraintTypes.GroupConstraintType iConstraint = null;
    private String iOwnerRole;
    private Preferences.Preference iPreference = null;
    private long iVersion;
    private Vector iClasses = new Vector();

    public long getGroupId() {
        return this.iGroupId;
    }

    public void setGroupId(long groupId) {
        this.iGroupId = groupId;
    }

    public GroupConstraintTypes.GroupConstraintType getConstraintType() {
        return this.iConstraint;
    }

    public void setConstraintType(GroupConstraintTypes.GroupConstraintType type) {
        this.iConstraint = type;
    }

    public void setConstraintType(int id) {
        this.iConstraint = GroupConstraintTypes.getGroupConstraintType(id);
    }

    public void setConstraintType(String type) {
        this.iConstraint = GroupConstraintTypes.getGroupConstraintType(type);
    }

    public String getOwnerRole() {
        return this.iOwnerRole;
    }

    public void setOwnerRole(String ownerRole) {
        this.iOwnerRole = ownerRole;
    }

    public void setOwnerRole(User owner) throws TTException, SQLException {
        this.iOwnerRole = owner.getCurrentRole();
    }

    public void setPreference(Preferences.Preference preference) {
        this.iPreference = preference;
    }

    public Preferences.Preference getPreference() {
        return this.iPreference;
    }

    public long getVersion() {
        return this.iVersion;
    }

    public void setVersion(long version) {
        this.iVersion = version;
    }

    public Vector getClasses() throws SQLException, TTException {
        Vector<Class> ret = new Vector<Class>();
        Enumeration e1 = this.iClasses.elements();
        while (e1.hasMoreElements()) {
            ClassGroup gr = (ClassGroup)e1.nextElement();
            if (gr == null) continue;
            Enumeration e2 = gr.getClasses().elements();
            while (e2.hasMoreElements()) {
                Class c = (Class)e2.nextElement();
                if (ret.indexOf(c) >= 0) continue;
                ret.addElement(c);
            }
        }
        return ret;
    }

    public Vector getClassGroups() {
        return this.iClasses;
    }

    public String getClassGroupsAsString(String delim) {
        StringBuffer ret = new StringBuffer();
        Enumeration e = ToolBox.sortEnumeration(this.iClasses.elements());
        while (e.hasMoreElements()) {
            ret.append((ClassGroup)e.nextElement());
            if (!e.hasMoreElements()) continue;
            ret.append(delim);
        }
        return ret.toString();
    }

    public String getClassGroupsAsString() {
        return this.getClassGroupsAsString("<br>");
    }

    public ClassGroup class2group(Class c) {
        return new ClassGroup(c.getSubject(), c.getCourseNumber(), c.getIType(), c.getSection());
    }

    private static GroupConstraint load(ResultSet rs) throws SQLException, TTException {
        GroupConstraint gc = new GroupConstraint();
        gc.setGroupId(rs.getLong("GROUP_ID"));
        gc.setPreference(Preferences.getPreference(rs.getInt("PREF_ID")));
        gc.setConstraintType(rs.getInt("REQ_ID"));
        gc.setOwnerRole(rs.getString(5));
        gc.setVersion(rs.getLong("VERSION"));
        gc.loadGroupClasses();
        return gc;
    }

    private void loadGroupClasses() throws SQLException, TTException {
        this.iClasses.clear();
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".CLASS_DISTRIBUTION_GROUP where GROUP_ID=" + Database.prepParam(this.getGroupId()) + " and VERSION=" + Database.prepParam(this.getVersion()));
        while (s.getResultSet().next()) {
            ResultSet rs = s.getResultSet();
            String subject = rs.getString("SUBJECT");
            String courseNbr = rs.getString("COURSE_NBR");
            String itype = rs.getString("ITYPE");
            int section = rs.getInt("SECTION");
            this.iClasses.addElement(new ClassGroup(subject, courseNbr, itype, section));
        }
        s.close();
    }

    public static GroupConstraint load(long id, long version) throws SQLException, TTException {
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".CLASS_DISTRIBUTION_REQ where GROUP_ID=" + Database.prepParam(id) + " and VERSION=" + Database.prepParam(version));
        GroupConstraint gc = null;
        if (s.getResultSet().next()) {
            gc = GroupConstraint.load(s.getResultSet());
        }
        s.close();
        return gc;
    }

    public static Vector loadAll(long version) throws SQLException, TTException {
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".CLASS_DISTRIBUTION_REQ where VERSION=" + Database.prepParam(version));
        Vector<GroupConstraint> ret = new Vector<GroupConstraint>();
        while (s.getResultSet().next()) {
            ret.addElement(GroupConstraint.load(s.getResultSet()));
        }
        s.close();
        return ret;
    }

    public void save() throws SQLException, TTException {
        TimetableVersion.dirty(this.getVersion());
        if (this.getGroupId() < 0L) {
            this.setGroupId(Database.executeLong("select " + Config.get("SQL_SCHEMA") + ".SEQ_CLASS_DISTRIBUTION_REQ.nextval from DUAL"));
            Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".CLASS_DISTRIBUTION_REQ (group_id,req_id,owner_role,pref_id,version) values (" + Database.prepParam(this.getGroupId()) + ", " + Database.prepParam(this.getConstraintType().getId()) + ", " + Database.prepParam(this.getOwnerRole()) + ", " + Database.prepParam(this.getPreference().getId()) + ", " + Database.prepParam(this.getVersion()) + ")");
            Enumeration e = this.getClassGroups().elements();
            while (e.hasMoreElements()) {
                ClassGroup gc = (ClassGroup)e.nextElement();
                Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".CLASS_DISTRIBUTION_GROUP (group_id,subject,course_nbr,itype,section,version) values (" + Database.prepParam(this.getGroupId()) + ", " + Database.prepParam(gc.getSubject()) + ", " + Database.prepParam(gc.getCourseNumber()) + ", " + Database.prepParam(gc.getIType()) + ", " + Database.prepParam(gc.getSection()) + ", " + Database.prepParam(this.getVersion()) + ")");
            }
        } else {
            Database.executeNoOutput("update " + Config.get("SQL_SCHEMA") + ".CLASS_DISTRIBUTION_REQ set " + "REQ_ID=" + Database.prepParam(this.getConstraintType().getId()) + ", " + "OWNER_ROLE=" + Database.prepParam(this.getOwnerRole()) + ", " + "PREF_ID=" + Database.prepParam(this.getPreference().getId()) + ", " + "VERSION=" + Database.prepParam(this.getVersion()) + " where GROUP_ID=" + Database.prepParam(this.getGroupId()) + " AND VERSION=" + Database.prepParam(this.getVersion()));
            Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".CLASS_DISTRIBUTION_GROUP where GROUP_ID=" + Database.prepParam(this.getGroupId()) + " and VERSION=" + Database.prepParam(this.getVersion()));
            Enumeration e = this.getClassGroups().elements();
            while (e.hasMoreElements()) {
                ClassGroup gc = (ClassGroup)e.nextElement();
                Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".CLASS_DISTRIBUTION_GROUP (group_id,subject,course_nbr,itype,section,version) values (" + Database.prepParam(this.getGroupId()) + ", " + Database.prepParam(gc.getSubject()) + ", " + Database.prepParam(gc.getCourseNumber()) + ", " + Database.prepParam(gc.getIType()) + ", " + Database.prepParam(gc.getSection()) + ", " + Database.prepParam(this.getVersion()) + ")");
            }
        }
    }

    public static void delete(long id, long version) throws SQLException, TTException {
        TimetableVersion.dirty(version);
        Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".CLASS_DISTRIBUTION_REQ where GROUP_ID=" + Database.prepParam(id) + " and VERSION=" + Database.prepParam(version));
    }

    public static long count(long version) throws SQLException, TTException {
        return Database.executeLong("select count(*) from " + Config.get("SQL_SCHEMA") + ".CLASS_DISTRIBUTION_REQ where VERSION=" + Database.prepParam(version));
    }

    public boolean canDelete() {
        return this.getGroupId() >= 0L;
    }

    public ClassGroup createClassGroup(String subject, String courseNbr, String itype, int section) {
        return new ClassGroup(subject, courseNbr, itype, section);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof GroupConstraint)) {
            return false;
        }
        return this.getGroupId() == ((GroupConstraint)o).getGroupId();
    }

    public boolean mayEdit(User user) throws TTException, SQLException {
        if (user == null) {
            return false;
        }
        if (user.isAdmin()) {
            return true;
        }
        if (this.getOwnerRole() != null && this.getOwnerRole().equals(user.getCurrentRole())) {
            if (this.getOwnerRole().equals(Constants.DEPARTMENT_ROLE)) {
                if (this.getClassGroups().isEmpty()) {
                    return true;
                }
                Enumeration ge = this.getClassGroups().elements();
                while (ge.hasMoreElements()) {
                    ClassGroup cg = (ClassGroup)ge.nextElement();
                    if (!user.hasSubject(cg.getSubject())) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean mayDelete(User user) throws TTException, SQLException {
        return this.mayEdit(user);
    }

    public static class GroupConstraintComparator
    implements Comparator {
        User iUser = null;

        public GroupConstraintComparator(User user) {
            this.iUser = user;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null || !(o1 instanceof ClassGroup) || o2 == null || !(o2 instanceof ClassGroup)) {
                return 0;
            }
            ClassGroup cg1 = (ClassGroup)o1;
            ClassGroup cg2 = (ClassGroup)o2;
            if (this.iUser != null) {
                boolean has2;
                boolean has1 = this.iUser.getSubjects().indexOf(cg1.getSubject()) >= 0;
                boolean bl = has2 = this.iUser.getSubjects().indexOf(cg2.getSubject()) >= 0;
                if (has1 && !has2) {
                    return -1;
                }
                if (has2 && !has1) {
                    return 1;
                }
            }
            return cg1.compareTo(cg2);
        }
    }

    public class ClassGroup
    implements Comparable {
        private String iSubject;
        private String iCourseNbr;
        private String iIType;
        private int iSection;

        public ClassGroup(String subject, String courseNbr) {
            this.iSubject = subject;
            this.iCourseNbr = courseNbr;
            this.iIType = null;
            this.iSection = -1;
        }

        public ClassGroup(String subject, String courseNbr, String itype) {
            this.iSubject = subject;
            this.iCourseNbr = courseNbr;
            this.iIType = itype;
            this.iSection = -1;
        }

        public ClassGroup(String subject, String courseNbr, String itype, int section) {
            this.iSubject = subject;
            this.iCourseNbr = courseNbr;
            this.iIType = itype;
            this.iSection = section;
        }

        public ClassGroup(String subject, String courseNbr, int section) {
            this.iSubject = subject;
            this.iCourseNbr = courseNbr;
            this.iSection = section;
        }

        public String getSubject() {
            return this.iSubject;
        }

        public void setSubject(String subject) {
            this.iSubject = subject;
        }

        public String getIType() {
            return this.iIType;
        }

        public void setIType(String itype) {
            this.iIType = itype;
        }

        public String getCourseNumber() {
            return this.iCourseNbr;
        }

        public void setCourseNumber(String number) {
            this.iCourseNbr = number;
        }

        public int getSection() {
            return this.iSection;
        }

        public void setSection(int section) {
            this.iSection = section;
        }

        public Vector getClasses() throws SQLException, TTException {
            Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".CLASS where VERSION=" + Database.prepParam(GroupConstraint.this.iVersion) + " and SUBJECT=" + Database.prepParam(this.iSubject) + " and COURSE_NBR=" + Database.prepParam(this.iCourseNbr) + (this.iIType == null ? "" : " and ITYPE=" + Database.prepParam(this.iIType)) + (this.iSection < 0 ? "" : " and SECTION=" + Database.prepParam(this.iSection)));
            Vector<Class> ret = new Vector<Class>();
            while (s.getResultSet().next()) {
                ret.addElement(Class.load(s.getResultSet()));
            }
            s.close();
            return ret;
        }

        public String toString() {
            return this.getSubject() + "&nbsp;" + this.getCourseNumber() + (this.getIType() == null ? "" : "&nbsp;" + ITypes.getDescription(this.getIType())) + (this.getSection() < 0 ? "" : "&nbsp;" + this.getSection());
        }

        public int compareTo(Object o) {
            if (o == null || !(o instanceof ClassGroup)) {
                return -1;
            }
            ClassGroup cg = (ClassGroup)o;
            int ret = this.getSubject().compareTo(cg.getSubject());
            Debug.log("1");
            if (ret != 0) {
                return ret;
            }
            ret = this.getCourseNumber().compareTo(cg.getCourseNumber());
            Debug.log("2");
            if (ret != 0) {
                return ret;
            }
            ret = this.getCourseNumber().compareTo(cg.getCourseNumber());
            Debug.log("3");
            if (ret != 0) {
                return ret;
            }
            ret = this.getIType() == null ? (cg.getIType() == null ? 0 : -1) : (cg.getIType() == null ? 1 : 0);
            Debug.log("4");
            if (ret != 0) {
                return ret;
            }
            Debug.log("5");
            return this.getSection() - cg.getSection();
        }

        public boolean equals(Object o) {
            Debug.log(this + " compareTo " + o + " ... " + this.compareTo(o));
            return this.compareTo(o) == 0;
        }
    }
}

