/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.data;

import edu.purdue.smas.timetable.data.Building;
import edu.purdue.smas.timetable.data.Preferences;
import edu.purdue.smas.timetable.data.Subjects;
import edu.purdue.smas.timetable.data.TimetableConfig;
import edu.purdue.smas.timetable.data.TimetableVersion;
import edu.purdue.smas.timetable.util.Config;
import edu.purdue.smas.timetable.util.Constants;
import edu.purdue.smas.timetable.util.Database;
import edu.purdue.smas.timetable.util.TTException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;

public class DeptBldgPref {
    private String iDeptCode;
    private int iPrefId;
    private String iBldgId;
    private long iVersion;

    public DeptBldgPref(String deptCode, int prefId, String bldgId, long version) {
        this.iDeptCode = deptCode;
        this.iPrefId = prefId;
        this.iBldgId = bldgId;
        this.iVersion = version;
    }

    public static void initializeFromSession(String schema) throws SQLException, TTException {
        Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".DEPT_BLDG_PREF where version = " + Database.prepParam(TimetableVersion.getCurrentVersionNumber()));
        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".DEPT_BLDG_PREF dbp_current (select * from " + TimetableConfig.previousSchema() + ".DEPT_BLDG_PREF dbp_previous where version = " + Database.prepParam(TimetableVersion.getCurrentVersionNumber()) + " and exists (select 1 from " + Config.get("SQL_SCHEMA") + ".BUILDING where building.bldg_id = dbp_previous.bldg_id and version = " + Database.prepParam(TimetableVersion.getCurrentVersionNumber()) + "))");
        Vector allPrefs = DeptBldgPref.loadAll(TimetableVersion.getCurrentVersionNumber());
        Enumeration e = allPrefs.elements();
        while (e.hasMoreElements()) {
            ((DeptBldgPref)e.nextElement()).apply();
        }
    }

    public static Vector loadAll(long version) throws SQLException, TTException {
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".DEPT_BLDG_PREF where VERSION=" + Database.prepParam(version) + " order by dept_code, bldg_id");
        Vector<DeptBldgPref> coll = new Vector<DeptBldgPref>();
        while (s.getResultSet().next()) {
            ResultSet rs = s.getResultSet();
            coll.addElement(new DeptBldgPref(rs.getString("DEPT_CODE"), rs.getInt("PREF_ID"), rs.getString("BLDG_ID"), rs.getLong("VERSION")));
        }
        s.close();
        return coll;
    }

    public Building getBuilding() throws SQLException, TTException {
        return Building.load(this.iBldgId, this.iVersion);
    }

    public Preferences.Preference getPreference() throws SQLException, TTException {
        return Preferences.getPreference(this.iPrefId);
    }

    public void delete() throws SQLException, TTException {
        this.applyDelete();
        Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".DEPT_BLDG_PREF where " + " dept_code = " + Database.prepParam(this.getDeptCode()) + " " + " and bldg_id = " + Database.prepParam(this.getBldgId()) + " " + " and version = " + Database.prepParam(this.getVersion()));
    }

    public void save() throws SQLException, TTException {
        this.delete();
        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".DEPT_BLDG_PREF (dept_code,pref_id,bldg_id, version) values (" + Database.prepParam(this.getDeptCode()) + ", " + Database.prepParam(this.getPrefId()) + ", " + Database.prepParam(this.getBldgId()) + ", " + Database.prepParam(this.getVersion()) + ")");
    }

    public void applyDelete() throws SQLException, TTException {
        Enumeration e = Subjects.allSubjects().elements();
        while (e.hasMoreElements()) {
            String subj = (String)e.nextElement();
            if (!Subjects.getDeptCode(subj).equals(this.iDeptCode)) continue;
            Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".CLASS_BUILDING_REQ r where version = " + Database.prepParam(this.getVersion()) + " and exists (select 1 from " + Config.get("SQL_SCHEMA") + ".class where subject = " + Database.prepParam(subj) + " and class.class_id = r.class_id " + " and class.owner_role = " + Database.prepParam(Constants.LLR_MANAGER_ROLE) + " and r.bldg_id = " + Database.prepParam(this.iBldgId) + " and r.pref_id = " + Database.prepParam(this.iPrefId) + ")");
        }
    }

    public void apply() throws SQLException, TTException {
        Enumeration e = Subjects.allSubjects().elements();
        while (e.hasMoreElements()) {
            String subj = (String)e.nextElement();
            if (!Subjects.getDeptCode(subj).equals(this.iDeptCode)) continue;
            Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".CLASS_BUILDING_REQ r where version = " + Database.prepParam(this.getVersion()) + " and exists (select 1 from " + Config.get("SQL_SCHEMA") + ".class where subject = " + Database.prepParam(subj) + " and class.class_id = r.class_id " + " and class.owner_role = " + Database.prepParam(Constants.LLR_MANAGER_ROLE) + " and r.bldg_id = " + Database.prepParam(this.iBldgId) + ")");
            Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".CLASS_BUILDING_REQ (select class_id, " + Database.prepParam(this.iBldgId) + ", " + Database.prepParam(this.iPrefId) + ", " + Database.prepParam(this.getVersion()) + " from " + Config.get("SQL_SCHEMA") + ".class where class.version = " + Database.prepParam(this.getVersion()) + " and class.subject = " + Database.prepParam(subj) + " and class.owner_role = " + Database.prepParam(Constants.LLR_MANAGER_ROLE) + ")");
        }
    }

    public String anchorId() {
        return this.iDeptCode + this.iBldgId;
    }

    public String getBldgId() {
        return this.iBldgId;
    }

    public String getDeptCode() {
        return this.iDeptCode;
    }

    public long getPrefId() {
        return this.iPrefId;
    }

    public long getVersion() {
        return this.iVersion;
    }

    public void setBldgId(String string) {
        this.iBldgId = string;
    }

    public void setDeptCode(String string) {
        this.iDeptCode = string;
    }

    public void setPrefId(int l) {
        this.iPrefId = l;
    }

    public void setVersion(long l) {
        this.iVersion = l;
    }
}

