/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.data;

import edu.purdue.smas.timetable.util.Config;
import edu.purdue.smas.timetable.util.Database;
import edu.purdue.smas.timetable.util.TTException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;

public class Building
implements Comparable {
    private String iId = null;
    private String iABBV;
    private String iName;
    private long iVersion;

    private Building() {
    }

    public String getId() {
        return this.iId;
    }

    public String getABBV() {
        return this.iABBV;
    }

    public String getName() {
        return this.iName;
    }

    public long getVersion() {
        return this.iVersion;
    }

    private static Building load(ResultSet rs) throws SQLException, TTException {
        Building b = new Building();
        b.iId = rs.getString("BLDG_ID");
        b.iABBV = rs.getString("ABBV");
        b.iName = rs.getString("NAME");
        b.iVersion = rs.getLong("VERSION");
        return b;
    }

    public static Building load(String id, long version) throws SQLException, TTException {
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".BUILDING where BLDG_ID=" + Database.prepParam(id) + " and VERSION=" + Database.prepParam(version));
        Building b = null;
        if (s.getResultSet().next()) {
            b = Building.load(s.getResultSet());
        }
        s.close();
        return b;
    }

    public static Vector loadAll(long version) throws SQLException, TTException {
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".BUILDING where VERSION=" + Database.prepParam(version) + " order by BLDG_ID");
        Vector<Building> ret = new Vector<Building>();
        while (s.getResultSet().next()) {
            ret.addElement(Building.load(s.getResultSet()));
        }
        s.close();
        return ret;
    }

    public static Hashtable loadAllHash(long version) throws SQLException, TTException {
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".BUILDING where VERSION=" + Database.prepParam(version) + " order by BLDG_ID");
        Hashtable<String, Building> ret = new Hashtable<String, Building>();
        while (s.getResultSet().next()) {
            Building b = Building.load(s.getResultSet());
            ret.put(b.getId(), b);
        }
        s.close();
        return ret;
    }

    public static long count(long version) throws SQLException, TTException {
        return Database.executeLong("select count(*) from " + Config.get("SQL_SCHEMA") + ".BUILDING where VERSION=" + Database.prepParam(version));
    }

    public int hashCode() {
        return (this.getId() == null ? "null" : this.getId()).hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Building)) {
            return false;
        }
        String id = ((Building)o).getId();
        if (this.getId() == null) {
            return id == null;
        }
        return id != null && this.getId().equals(id);
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof Building)) {
            return 0;
        }
        if (this.getABBV() == null || (Building)o == null) {
            return 0;
        }
        return this.getABBV().compareTo(((Building)o).getABBV());
    }
}

