/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable;

import edu.purdue.smas.timetable.InitServlet;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SSORedirect
extends HttpServlet
implements Servlet {
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PrintWriter out = resp.getWriter();
        String accessLevel = req.getParameter("al");
        String token = req.getParameter("t");
        String reportId = req.getParameter("r");
        int id = -1;
        int al = -2;
        try {
            if (!InitServlet.isValidToken(token)) {
                out.println("Access Denied. Session may have timed out.");
                return;
            }
            if (reportId == null || reportId.trim().length() == 0) {
                out.println("Report not found");
                return;
            }
            if (accessLevel == null || accessLevel.trim().length() == 0) {
                out.println("Access Denied. Access level could not be determined");
                return;
            }
            accessLevel = InitServlet.decrypt(accessLevel);
            id = Integer.parseInt(reportId = InitServlet.decrypt(reportId));
            if (id > (al = Integer.parseInt(accessLevel))) {
                out.println("Access Denied. Report cannot be viewed by your level.");
                return;
            }
        }
        catch (Exception e) {
            out.println("Parameter Check Failed: " + e.getMessage());
            return;
        }
        String url = "";
        String submit = "";
        try {
            switch (id) {
                case 1: {
                    url = "http://allspice.smas.purdue.edu/publicreports/coursehistoryinput.asp";
                    submit = "Course History Reports";
                    break;
                }
                case 2: {
                    url = "http://allspice.smas.purdue.edu/smasreports/eventManagement/eventscheduleaudit.asp";
                    submit = "Event Schedule Audit";
                    break;
                }
                case 3: {
                    url = "http://allspice.smas.purdue.edu/smasreports/eventManagement/eventschedulebybldg.asp";
                    submit = "Event Schedule By Building";
                    break;
                }
                case 4: {
                    url = "http://allspice.smas.purdue.edu/smasreports/eventManagement/eventvenueaudit.asp";
                    submit = "Event Venue Audit";
                    break;
                }
                case 6: {
                    url = "https://www.smas.purdue.edu/cgi-bin/isis.pl";
                    submit = "Space Inventory Reports";
                    break;
                }
                case 8: {
                    url = "https://www.smas.purdue.edu/cgi-bin/sched.pl";
                    submit = "Student Class Schedules";
                    break;
                }
                default: {
                    out.println("Report not found.");
                    return;
                }
            }
            HttpSession session = req.getSession();
            session.setAttribute("loggedIn", (Object)"Y");
            session.setAttribute("url", (Object)url);
            session.setAttribute("submit", (Object)submit);
            resp.sendRedirect("report.jsp");
        }
        catch (Exception e) {
            out.println("Error: " + e.getMessage());
            return;
        }
    }
}

