/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable;

import edu.purdue.smas.crypto.PBE;
import edu.purdue.smas.security.TokenManager;
import edu.purdue.smas.timetable.ApplicationProperties;
import edu.purdue.smas.util.Config;
import edu.purdue.smas.util.Debug;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class InitServlet
extends HttpServlet
implements Servlet {
    private static PBE pbe = null;
    private static Properties props = null;
    private static TokenManager tokMgr = null;

    public void init() throws ServletException {
        InitServlet.logMessage("******* Initializing Timetabling Application : START *******");
        super.init();
        try {
            props = ApplicationProperties.getProperties();
            InitServlet.logMessage(" - Initializing Config ... ");
            Config.init((Properties)props);
            InitServlet.logMessage("******* Timetabling Application : Initializing DONE *******");
        }
        catch (Exception e) {
            InitServlet.logError("Servlet Initialization Failed : " + e.getMessage());
        }
    }

    public static synchronized String decrypt(String str) throws Exception {
        String pbePwd = props.getProperty("tmtbl.pbe.password");
        String result = pbe.decrypt(pbePwd, str);
        return result;
    }

    public static synchronized String encrypt(String str) throws Exception {
        String pbePwd = props.getProperty("tmtbl.pbe.password");
        String result = pbe.encrypt(pbePwd, str);
        return result;
    }

    public static synchronized String getToken() throws Exception {
        String token = tokMgr.getToken();
        String encToken = InitServlet.encrypt(token);
        Debug.debug((String)("Token: " + token));
        Debug.debug((String)("Encrypted Token: " + encToken));
        return encToken;
    }

    public static synchronized boolean isValidToken(String token) throws Exception {
        String decToken = InitServlet.decrypt(token);
        Debug.debug((String)("Encrypted Token: " + token));
        Debug.debug((String)("Decrypted Token: " + decToken));
        return tokMgr.isValidToken(decToken);
    }

    public static synchronized void setCookie(HttpServletResponse resp, String name, String value) throws Exception {
        Cookie cookie = new Cookie(name, InitServlet.encrypt(value));
        cookie.setMaxAge(3600);
        resp.addCookie(cookie);
    }

    public static synchronized String getCookie(HttpServletRequest req, String name) throws Exception {
        Cookie[] cookies = req.getCookies();
        for (int i = 0; i < cookies.length; ++i) {
            System.out.println(cookies[i].getName());
            if (!cookies[i].getName().equalsIgnoreCase(name)) continue;
            return InitServlet.decrypt(cookies[i].getValue());
        }
        return "";
    }

    public void destroy() {
        super.destroy();
    }

    public String getServletInfo() {
        return "Timetabling Initialization Servlet";
    }

    private static void logMessage(String message) {
        Debug.info((String)message);
    }

    private static void logError(String message) {
        Debug.error((String)message);
        System.err.println(message);
    }
}

