/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable;

import edu.purdue.smas.timetable.InitServlet;
import edu.purdue.smas.util.Debug;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Authorize
extends HttpServlet
implements Servlet {
    private String[] servers = new String[]{"128.210.10.46"};
    private String[] subnets = new String[]{"128.210.134."};

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.sendResponseStr("I do not handle get. Please POST.", resp);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String remoteAddr = req.getRemoteAddr();
        boolean secure = req.isSecure();
        Debug.info((String)("Received request to from: " + remoteAddr + " Secure: " + true));
        if (!secure) {
            this.sendError("Non Secure Protocol.", resp);
            Debug.error((String)("Request Denied to non-secure request from: " + remoteAddr));
            return;
        }
        if (!this.checkServer(remoteAddr)) {
            this.sendError("Request Denied to Host.", resp);
            Debug.error((String)("Request Denied to server: " + remoteAddr));
            return;
        }
        try {
            String login = req.getParameter("login");
            String dept = req.getParameter("dept");
            String uri = req.getRequestURL().substring(0, req.getRequestURL().lastIndexOf("/"));
            String accessLevel = "7";
            StringTokenizer strTok = new StringTokenizer(dept);
            while (strTok.hasMoreElements()) {
                String deptNum = strTok.nextElement().toString();
                if (!deptNum.equals("1095") && !deptNum.equals("1128")) continue;
                accessLevel = "8";
                break;
            }
            String qs = "&al=" + URLEncoder.encode(InitServlet.encrypt(accessLevel), "UTF-8") + "&t=" + URLEncoder.encode(InitServlet.getToken(), "UTF-8");
            Debug.debug((String)("Query String: " + qs));
            Debug.debug((String)("Received request to authorize: User - " + login));
            Vector<String> menu = new Vector<String>();
            menu.addElement("OK");
            menu.addElement("0|-1|1|Course History|" + uri + "/ReportView?r=" + URLEncoder.encode(InitServlet.encrypt("1"), "UTF-8") + qs);
            menu.addElement("0|-1|2|Event Schedule Audit|" + uri + "/ReportView?r=" + URLEncoder.encode(InitServlet.encrypt("2"), "UTF-8") + qs);
            menu.addElement("0|-1|3|Event Schedule By Building|" + uri + "/ReportView?r=" + URLEncoder.encode(InitServlet.encrypt("3"), "UTF-8") + qs);
            menu.addElement("0|-1|4|Event Venue Audit|" + uri + "/ReportView?r=" + URLEncoder.encode(InitServlet.encrypt("4"), "UTF-8") + qs);
            menu.addElement("0|-1|6|Space Inventory|" + uri + "/ReportView?r=" + URLEncoder.encode(InitServlet.encrypt("6"), "UTF-8") + qs);
            if (accessLevel.equals("8")) {
                menu.addElement("0|-1|8|Student Class Schedules|" + uri + "/ReportView?r=" + URLEncoder.encode(InitServlet.encrypt("8"), "UTF-8") + qs);
            }
            this.sendResponseObj(menu, resp);
        }
        catch (Exception e) {
            this.sendError(e.getMessage(), resp);
            Debug.error((String)e.getMessage());
            return;
        }
    }

    private boolean checkServer(String remoteAddr) {
        int i;
        if (remoteAddr == null || remoteAddr.length() == 0) {
            return false;
        }
        for (i = 0; i < this.servers.length; ++i) {
            if (!this.servers[i].equals(remoteAddr)) continue;
            return true;
        }
        for (i = 0; i < this.subnets.length; ++i) {
            if (!remoteAddr.startsWith(this.subnets[i])) continue;
            return true;
        }
        return false;
    }

    private void sendError(String errMsg, HttpServletResponse resp) throws IOException {
        Vector<String> v = new Vector<String>();
        v.addElement("FAIL: " + errMsg);
        this.sendResponseObj(v, resp);
    }

    private void sendResponseObj(Object data, HttpServletResponse resp) throws IOException {
        ObjectOutputStream outputToApplet = new ObjectOutputStream((OutputStream)resp.getOutputStream());
        outputToApplet.writeObject(data);
        outputToApplet.flush();
        outputToApplet.close();
    }

    private void sendResponseStr(String data, HttpServletResponse resp) throws IOException {
        PrintWriter out = new PrintWriter((OutputStream)resp.getOutputStream());
        resp.setContentType("text/plain");
        out.println(data);
        out.flush();
        out.close();
    }
}

