/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.Timer;
import java.util.TimerTask;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.monitor.Monitor;
import javax.management.monitor.StringMonitorMBean;

public class StringMonitor
extends Monitor
implements StringMonitorMBean {
    private static final String[] types = new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.string.matches", "jmx.monitor.string.differs"};
    private static final MBeanNotificationInfo[] notifsInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, "javax.management.monitor.MonitorNotification", "Notifications sent by the StringMonitor MBean")};
    private String stringToCompare = "";
    private boolean notifyMatch = false;
    private boolean notifyDiffer = false;
    private String[] derivedGauge = new String[16];
    private long[] derivedGaugeTimestamp = new long[16];
    private int[] status = new int[16];
    private static final int MATCHING = 0;
    private static final int DIFFERING = 1;
    private static final int MATCHING_OR_DIFFERING = 2;
    private transient Timer timer = null;

    String makeDebugTag() {
        return "StringMonitor";
    }

    public StringMonitor() {
        this.dbgTag = this.makeDebugTag();
    }

    public synchronized void start() {
        if (StringMonitor.isTraceOn()) {
            this.trace("start", "start the string monitor");
        }
        if (this.isActive) {
            if (StringMonitor.isTraceOn()) {
                this.trace("start", "the string monitor is already activated");
            }
            return;
        }
        this.isActive = true;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.status[i2] = 2;
        }
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new StringAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (StringMonitor.isTraceOn()) {
            this.trace("stop", "stop the string monitor");
        }
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            if (!this.isActive) {
                if (StringMonitor.isTraceOn()) {
                    this.trace("stop", "the string monitor is already deactivated");
                }
                return;
            }
            this.isActive = false;
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
    }

    public synchronized void setGranularityPeriod(long l2) throws IllegalArgumentException {
        super.setGranularityPeriod(l2);
        if (this.isActive) {
            this.timer.cancel();
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new StringAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
        }
    }

    public synchronized String getDerivedGauge(ObjectName objectName) {
        int n2 = this.indexOf(objectName);
        if (n2 != -1) {
            return this.derivedGauge[n2];
        }
        return null;
    }

    public synchronized long getDerivedGaugeTimeStamp(ObjectName objectName) {
        int n2 = this.indexOf(objectName);
        if (n2 != -1) {
            return this.derivedGaugeTimestamp[n2];
        }
        return 0L;
    }

    public synchronized String getDerivedGauge() {
        return this.derivedGauge[0];
    }

    @Deprecated
    public synchronized long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimestamp[0];
    }

    public synchronized String getStringToCompare() {
        return this.stringToCompare;
    }

    public synchronized void setStringToCompare(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Null string to compare");
        }
        this.stringToCompare = string;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.status[i2] = 2;
        }
    }

    public synchronized boolean getNotifyMatch() {
        return this.notifyMatch;
    }

    public synchronized void setNotifyMatch(boolean bl2) {
        this.notifyMatch = bl2;
    }

    public synchronized boolean getNotifyDiffer() {
        return this.notifyDiffer;
    }

    public synchronized void setNotifyDiffer(boolean bl2) {
        this.notifyDiffer = bl2;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return notifsInfo;
    }

    private synchronized void updateDerivedGauge(Object object, int n2) {
        this.derivedGaugeTimestamp[n2] = System.currentTimeMillis();
        this.derivedGauge[n2] = (String)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotifications(int n2) {
        boolean bl2 = false;
        String string = null;
        long l2 = 0L;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            if (this.status[n2] == 2) {
                if (this.derivedGauge[n2].equals(this.stringToCompare)) {
                    if (this.notifyMatch) {
                        bl2 = true;
                        string = "jmx.monitor.string.matches";
                        l2 = this.derivedGaugeTimestamp[n2];
                        string2 = "";
                        string3 = this.derivedGauge[n2];
                        string4 = this.stringToCompare;
                    }
                    this.status[n2] = 1;
                } else {
                    if (this.notifyDiffer) {
                        bl2 = true;
                        string = "jmx.monitor.string.differs";
                        l2 = this.derivedGaugeTimestamp[n2];
                        string2 = "";
                        string3 = this.derivedGauge[n2];
                        string4 = this.stringToCompare;
                    }
                    this.status[n2] = 0;
                }
            } else if (this.status[n2] == 0) {
                if (this.derivedGauge[n2].equals(this.stringToCompare)) {
                    if (this.notifyMatch) {
                        bl2 = true;
                        string = "jmx.monitor.string.matches";
                        l2 = this.derivedGaugeTimestamp[n2];
                        string2 = "";
                        string3 = this.derivedGauge[n2];
                        string4 = this.stringToCompare;
                    }
                    this.status[n2] = 1;
                }
            } else if (this.status[n2] == 1 && !this.derivedGauge[n2].equals(this.stringToCompare)) {
                if (this.notifyDiffer) {
                    bl2 = true;
                    string = "jmx.monitor.string.differs";
                    l2 = this.derivedGaugeTimestamp[n2];
                    string2 = "";
                    string3 = this.derivedGauge[n2];
                    string4 = this.stringToCompare;
                }
                this.status[n2] = 0;
            }
        }
        if (bl2) {
            this.sendNotification(string, l2, string2, string3, string4, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAlarmClock(int n2) {
        boolean bl2 = false;
        String string = null;
        long l2 = 0L;
        String string2 = null;
        String string3 = null;
        Object var8_7 = null;
        Object object = null;
        String string4 = null;
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            if (!this.isActive) {
                return;
            }
            if (this.getObservedObject(n2) == null || this.getObservedAttribute() == null) {
                return;
            }
            try {
                object = this.server.getAttribute(this.getObservedObject(n2), this.getObservedAttribute());
                if (object == null) {
                    return;
                }
            }
            catch (NullPointerException nullPointerException) {
                if (this.alreadyNotified(n2, 8)) {
                    return;
                }
                string4 = "jmx.monitor.error.runtime";
                this.setAlreadyNotified(n2, 8);
                string2 = "The string monitor must be registered in the MBean server.";
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                if (this.alreadyNotified(n2, 1)) {
                    return;
                }
                string4 = "jmx.monitor.error.mbean";
                this.setAlreadyNotified(n2, 1);
                string2 = "The observed object must be registered in the MBean server.";
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                if (this.alreadyNotified(n2, 2)) {
                    return;
                }
                string4 = "jmx.monitor.error.attribute";
                this.setAlreadyNotified(n2, 2);
                string2 = "The observed attribute must be accessible in the observed object.";
            }
            catch (MBeanException mBeanException) {
                if (this.alreadyNotified(n2, 8)) {
                    return;
                }
                string4 = "jmx.monitor.error.runtime";
                this.setAlreadyNotified(n2, 8);
                string2 = mBeanException.getMessage();
            }
            catch (ReflectionException reflectionException) {
                if (this.alreadyNotified(n2, 2)) {
                    return;
                }
                string4 = "jmx.monitor.error.attribute";
                this.setAlreadyNotified(n2, 2);
                string2 = reflectionException.getMessage();
            }
            if (string2 == null && !(object instanceof String)) {
                if (this.alreadyNotified(n2, 4)) {
                    return;
                }
                string4 = "jmx.monitor.error.type";
                this.setAlreadyNotified(n2, 4);
                string2 = "The observed attribute type must be a string type.";
            }
            if (string2 == null) {
                this.resetAllAlreadyNotified(n2);
                this.updateDerivedGauge(object, n2);
                this.updateNotifications(n2);
            } else {
                l2 = this.derivedGaugeTimestamp[n2];
                string3 = this.derivedGauge[n2];
                this.status[n2] = 2;
            }
        }
        if (string2 != null) {
            this.sendNotification(string, l2, string2, string3, null, n2);
        }
    }

    synchronized void insertSpecificElementAt(int n2) {
        if (n2 != this.elementCount) {
            throw new Error("Internal error: index != elementCount");
        }
        if (this.elementCount >= this.derivedGauge.length) {
            this.derivedGauge = this.expandArray(this.derivedGauge);
            this.derivedGaugeTimestamp = this.expandArray(this.derivedGaugeTimestamp);
            this.status = this.expandArray(this.status);
        }
        this.derivedGauge[n2] = "";
        this.derivedGaugeTimestamp[n2] = System.currentTimeMillis();
        this.status[n2] = 2;
    }

    synchronized void removeSpecificElementAt(int n2) {
        if (n2 < 0 || n2 >= this.elementCount) {
            return;
        }
        this.removeElementAt(this.derivedGauge, n2);
        this.removeElementAt(this.derivedGaugeTimestamp, n2);
        this.removeElementAt(this.status, n2);
    }

    private static class StringAlarmClock
    extends TimerTask {
        StringMonitor listener = null;

        public StringAlarmClock(StringMonitor stringMonitor) {
            this.listener = stringMonitor;
        }

        public void run() {
            if (this.listener.isActive) {
                for (int i2 = 0; i2 < this.listener.elementCount; ++i2) {
                    this.listener.notifyAlarmClock(i2);
                }
            }
        }
    }
}

