/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpValue;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SnmpString
extends SnmpValue {
    static final String name = "String";
    protected byte[] value = null;

    public SnmpString() {
        this.value = new byte[0];
    }

    public SnmpString(byte[] byArray) {
        this.value = (byte[])byArray.clone();
    }

    public SnmpString(Byte[] byteArray) {
        this.value = new byte[byteArray.length];
        for (int i2 = 0; i2 < byteArray.length; ++i2) {
            this.value[i2] = byteArray[i2];
        }
    }

    public SnmpString(String string) {
        this.value = string.getBytes();
    }

    public SnmpString(InetAddress inetAddress) {
        this.value = inetAddress.getAddress();
    }

    public InetAddress inetAddressValue() throws UnknownHostException {
        return InetAddress.getByAddress(this.value);
    }

    public static String BinToChar(String string) {
        char[] cArray = new char[string.length() / 8];
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = (char)Integer.parseInt(string.substring(8 * i2, 8 * i2 + 8), 2);
        }
        return new String(cArray);
    }

    public static String HexToChar(String string) {
        char[] cArray = new char[string.length() / 2];
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = (char)Integer.parseInt(string.substring(2 * i2, 2 * i2 + 2), 16);
        }
        return new String(cArray);
    }

    public byte[] byteValue() {
        return this.value;
    }

    public Byte[] toByte() {
        Byte[] byteArray = new Byte[this.value.length];
        for (int i2 = 0; i2 < this.value.length; ++i2) {
            byteArray[i2] = new Byte(this.value[i2]);
        }
        return byteArray;
    }

    public String toString() {
        return new String(this.value);
    }

    public SnmpOid toOid() {
        long[] lArray = new long[this.value.length];
        for (int i2 = 0; i2 < this.value.length; ++i2) {
            lArray[i2] = this.value[i2] & 0xFF;
        }
        return new SnmpOid(lArray);
    }

    public static SnmpOid toOid(long[] lArray, int n2) throws SnmpStatusException {
        try {
            if (lArray[n2] > Integer.MAX_VALUE) {
                throw new SnmpStatusException(2);
            }
            int n3 = (int)lArray[n2++];
            long[] lArray2 = new long[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                lArray2[i2] = lArray[n2 + i2];
            }
            return new SnmpOid(lArray2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SnmpStatusException(2);
        }
    }

    public static int nextOid(long[] lArray, int n2) throws SnmpStatusException {
        try {
            int n3;
            if (lArray[n2] > Integer.MAX_VALUE) {
                throw new SnmpStatusException(2);
            }
            if ((n2 += (n3 = (int)lArray[n2++])) <= lArray.length) {
                return n2;
            }
            throw new SnmpStatusException(2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SnmpStatusException(2);
        }
    }

    public static void appendToOid(SnmpOid snmpOid, SnmpOid snmpOid2) {
        snmpOid2.append(snmpOid.getLength());
        snmpOid2.append(snmpOid);
    }

    public final synchronized SnmpValue duplicate() {
        return (SnmpValue)this.clone();
    }

    public synchronized Object clone() {
        SnmpString snmpString = null;
        try {
            snmpString = (SnmpString)super.clone();
            snmpString.value = new byte[this.value.length];
            System.arraycopy(this.value, 0, snmpString.value, 0, this.value.length);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return snmpString;
    }

    public String getTypeName() {
        return name;
    }
}

