/*
 * Decompiled with CFR 0.152.
 */
package ttsolver.model;

import edu.purdue.smas.timetable.data.Preferences;
import edu.purdue.smas.timetable.data.pattern.EveningTimePattern;
import edu.purdue.smas.timetable.data.pattern.GenericTimePattern;
import edu.purdue.smas.timetable.data.pattern.SaturdayTimePattern;
import ifs.model.Value;
import ifs.model.Variable;
import ttsolver.model.Lecture;
import ttsolver.model.RoomLocation;
import ttsolver.model.TimeLocation;

public class Placement
extends Value {
    private TimeLocation iTimeLocation;
    private RoomLocation iRoomLocation;
    private boolean iIsInitial = false;

    public Placement(Lecture lecture, TimeLocation timeLocation, RoomLocation roomLocation) {
        super((Variable)lecture);
        this.iTimeLocation = timeLocation;
        this.iRoomLocation = roomLocation;
    }

    public TimeLocation getTimeLocation() {
        return this.iTimeLocation;
    }

    public String getRoomId() {
        return this.iRoomLocation.getId();
    }

    public String getBuildingId() {
        return this.iRoomLocation.getBuildingId();
    }

    public RoomLocation getRoomLocation() {
        return this.iRoomLocation;
    }

    public String getInstructorId() {
        return ((Lecture)this.variable()).getInstructorId();
    }

    public String getName() {
        return this.getTimeLocation().getText() + " " + this.getRoomLocation().getName() + (((Lecture)this.variable()).getInstructorName() != null ? " " + ((Lecture)this.variable()).getInstructorName() : (this.getInstructorId() == null ? "" : " " + this.getInstructorId()));
    }

    public boolean isInitial() {
        return this.iIsInitial;
    }

    public void setInitial(boolean bl) {
        this.iIsInitial = bl;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Placement)) {
            return false;
        }
        Placement placement = (Placement)((Object)object);
        if (placement.getId() == this.getId()) {
            return true;
        }
        Lecture lecture = (Lecture)placement.variable();
        Lecture lecture2 = (Lecture)this.variable();
        if (lecture != null && lecture2 != null && lecture.getClassId() != lecture2.getClassId()) {
            return false;
        }
        return placement.getTimeLocation() == this.getTimeLocation() && placement.getRoomId().equals(this.getRoomId()) && (placement.getInstructorId() == this.getInstructorId() || placement.getInstructorId() != null && placement.getInstructorId().equals(this.getInstructorId()));
    }

    public String toString() {
        return this.variable().getName() + " " + this.getName();
    }

    public String getDescription() {
        return this.iTimeLocation.getNrMeetings() + "x" + 25 * this.iTimeLocation.getNrHalfHoursPerMeeting() + (this.iTimeLocation.getModel() == null ? "" : (this.iTimeLocation.getModel() instanceof GenericTimePattern ? " gen." : "") + (this.iTimeLocation.getModel() instanceof SaturdayTimePattern ? " Sat." : "") + (this.iTimeLocation.getModel() instanceof EveningTimePattern ? " evn." : "")) + (this.iTimeLocation.getPreference() != 0 || this.iTimeLocation.getNormalizedPreference() != 0.0 ? ", " + Preferences.getPreference((String)String.valueOf(this.iTimeLocation.getPreference())).getName().toLowerCase() + " time (" + this.iTimeLocation.getNormalizedPreference() + ")" : "") + (this.iRoomLocation.getPreference() != 0 ? (this.iRoomLocation.getPreference() >= -2 && this.iRoomLocation.getPreference() <= 2 ? ", " + Preferences.getPreference((String)String.valueOf(this.iRoomLocation.getPreference())).getName().toLowerCase() + " room" : ", " + this.iRoomLocation.getPreference() + " room") : "");
    }

    public static double getDistance(Placement placement, Placement placement2) {
        if (placement.getRoomId().equals(placement2.getRoomId())) {
            return 0.0;
        }
        RoomLocation roomLocation = placement.getRoomLocation();
        RoomLocation roomLocation2 = placement2.getRoomLocation();
        long l = roomLocation.getPosX() - roomLocation2.getPosX();
        long l2 = roomLocation.getPosY() - roomLocation2.getPosY();
        return Math.sqrt(l * l + l2 * l2);
    }

    public static boolean shareDays(Placement placement, Placement placement2) {
        return (placement.getTimeLocation().getDayCode() & placement2.getTimeLocation().getDayCode()) != 0;
    }
}

