/*
 * Decompiled with CFR 0.152.
 */
package ttsolver.model;

import ifs.model.Constraint;
import ifs.model.Value;
import ifs.model.Variable;
import ifs.util.FastVector;
import ifs.util.ToolBox;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import ttsolver.TimetableModel;
import ttsolver.constraint.DepartmentSpreadConstraint;
import ttsolver.constraint.InstructorConstraint;
import ttsolver.constraint.JenrlConstraint;
import ttsolver.model.CrossListedLecture;
import ttsolver.model.Placement;
import ttsolver.model.RoomLocation;
import ttsolver.model.TimeLocation;

public class Lecture
extends Variable {
    private static Logger sLogger = Logger.getLogger((Class)(class$ttsolver$model$Lecture == null ? (class$ttsolver$model$Lecture = Lecture.class$("ttsolver.model.Lecture")) : class$ttsolver$model$Lecture));
    private long iClassId;
    private String iName;
    private String iDept;
    private Vector iTimeLocations;
    private Vector iRoomLocations;
    private String iInstructorId;
    private String iInstructorName;
    private int iBestRoomPref;
    private double iBestTimePref;
    private long iNrStudents = -1L;
    private int iExpectedCapacity;
    private Hashtable iSameRoomValues = null;
    private String iPattern = null;
    private Vector iStudents = new FastVector(1);
    private Vector iAllStudents = null;
    private Vector iSameLectures = null;
    private Vector iCrossListedLectures = null;
    private DepartmentSpreadConstraint iDeptSpreadConstrain = null;
    private InstructorConstraint iInstructorConstraint = null;
    private Hashtable iSameStudents = new Hashtable(10);
    private Vector iActiveJenrls = new FastVector(10);
    private Vector iJenrlConstraints = new FastVector(10);
    private static boolean sSaveMemory = false;
    static /* synthetic */ Class class$ttsolver$model$Lecture;

    public Lecture(long l, String string, Vector vector, double d, String string2, Vector vector2, int n, Placement placement, int n2, String string3, String string4) {
        super((Value)placement);
        this.iClassId = l;
        this.iTimeLocations = vector;
        this.iInstructorId = string2;
        this.iInstructorName = string3;
        this.iRoomLocations = vector2;
        this.iName = string;
        this.iBestRoomPref = n;
        this.iBestTimePref = d;
        this.iExpectedCapacity = n2;
        this.iPattern = string4;
        if (!sSaveMemory) {
            this.setValues(this.computeValues());
        }
    }

    public void addActiveJenrl(JenrlConstraint jenrlConstraint) {
        this.iActiveJenrls.addElement(jenrlConstraint);
    }

    public Vector activeJenrls() {
        return this.iActiveJenrls;
    }

    public void removeActiveJenrl(JenrlConstraint jenrlConstraint) {
        this.iActiveJenrls.removeElement((Object)jenrlConstraint);
    }

    public long getClassId() {
        return this.iClassId;
    }

    public String getName() {
        return this.iName;
    }

    public long getId() {
        return this.iClassId;
    }

    public String getInstructorName() {
        return this.iInstructorName;
    }

    public String getInstructorId() {
        return this.iInstructorId;
    }

    public Vector students() {
        return this.iStudents;
    }

    public Vector allStudents() {
        return this.iAllStudents == null ? this.iStudents : this.iAllStudents;
    }

    public void addStudent(String string) {
        this.iStudents.addElement(string);
        if (this.iAllStudents != null) {
            this.iAllStudents.addElement(string);
        }
    }

    public void addSameLectureStudent(String string) {
        this.iAllStudents.addElement(string);
    }

    public boolean hasStudent(String string) {
        return (this.iAllStudents == null ? this.iStudents : this.iAllStudents).contains(string);
    }

    public void setSameLectures(Vector vector) {
        this.iSameLectures = vector;
    }

    public Vector sameLectures() {
        return this.iSameLectures;
    }

    public Vector crossListedLectures() {
        return this.iCrossListedLectures;
    }

    public void setCrossListedLectures(Vector vector) {
        this.iCrossListedLectures = vector;
        if (this.iCrossListedLectures != null) {
            this.iAllStudents = new FastVector(1);
            Enumeration enumeration = this.iCrossListedLectures.elements();
            while (enumeration.hasMoreElements()) {
                ((CrossListedLecture)enumeration.nextElement()).setLecture(this);
            }
        }
    }

    public Vector sameStudents(Lecture lecture) {
        if (this.iSameStudents.containsKey((Object)lecture)) {
            return (Vector)this.iSameStudents.get((Object)lecture);
        }
        FastVector fastVector = new FastVector();
        Enumeration enumeration = this.allStudents().elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!lecture.allStudents().contains(string)) continue;
            fastVector.addElement(string);
        }
        this.iSameStudents.put(lecture, fastVector);
        return fastVector;
    }

    public Vector conflictStudents(Value value, Variable variable) {
        FastVector fastVector = new FastVector();
        if (value == null) {
            return fastVector;
        }
        Lecture lecture = (Lecture)variable;
        if (lecture.getAssignment() == null || lecture.equals((Object)this)) {
            return fastVector;
        }
        if (!JenrlConstraint.isInConflict((Placement)value, (Placement)lecture.getAssignment())) {
            return fastVector;
        }
        return this.sameStudents(lecture);
    }

    public Vector conflictStudents(Value value) {
        FastVector fastVector = new FastVector();
        if (value == null) {
            return fastVector;
        }
        if (this.getAssignment() != null && value.equals((Object)this.getAssignment())) {
            Enumeration enumeration = this.activeJenrls().elements();
            while (enumeration.hasMoreElements()) {
                JenrlConstraint jenrlConstraint = (JenrlConstraint)((Object)enumeration.nextElement());
                ToolBox.merge((Vector)fastVector, (Collection)this.sameStudents((Lecture)jenrlConstraint.another(this)));
            }
        } else {
            Enumeration enumeration = this.iJenrlConstraints.elements();
            while (enumeration.hasMoreElements()) {
                JenrlConstraint jenrlConstraint = (JenrlConstraint)((Object)enumeration.nextElement());
                if (jenrlConstraint.jenrl(this, value) <= 0L) continue;
                ToolBox.merge((Vector)fastVector, (Collection)this.sameStudents((Lecture)jenrlConstraint.another(this)));
            }
        }
        return fastVector;
    }

    public Vector conflictStudents() {
        FastVector fastVector = new FastVector();
        if (this.getAssignment() == null) {
            return fastVector;
        }
        Enumeration enumeration = this.activeJenrls().elements();
        while (enumeration.hasMoreElements()) {
            JenrlConstraint jenrlConstraint = (JenrlConstraint)((Object)enumeration.nextElement());
            ToolBox.merge((Vector)fastVector, (Collection)this.sameStudents((Lecture)jenrlConstraint.another(this)));
        }
        return fastVector;
    }

    public Vector sameStudentLectures(String string) {
        FastVector fastVector = new FastVector();
        Enumeration enumeration = this.iJenrlConstraints.elements();
        while (enumeration.hasMoreElements()) {
            JenrlConstraint jenrlConstraint = (JenrlConstraint)((Object)enumeration.nextElement());
            Lecture lecture = (Lecture)jenrlConstraint.another(this);
            if (lecture.equals((Object)this) || !lecture.allStudents().contains(string)) continue;
            fastVector.addElement(lecture);
        }
        return fastVector;
    }

    public Vector conflictLecturesNames(String string) {
        FastVector fastVector = new FastVector();
        if (this.getAssignment() == null) {
            return fastVector;
        }
        Enumeration enumeration = this.activeJenrls().elements();
        while (enumeration.hasMoreElements()) {
            JenrlConstraint jenrlConstraint = (JenrlConstraint)((Object)enumeration.nextElement());
            Lecture lecture = (Lecture)jenrlConstraint.another(this);
            if (lecture.equals((Object)this) || !lecture.allStudents().contains(string)) continue;
            fastVector.addElement(lecture.getName());
        }
        return fastVector;
    }

    public Vector conflictLectures(String string) {
        FastVector fastVector = new FastVector();
        if (this.getAssignment() == null) {
            return fastVector;
        }
        Enumeration enumeration = this.activeJenrls().elements();
        while (enumeration.hasMoreElements()) {
            JenrlConstraint jenrlConstraint = (JenrlConstraint)((Object)enumeration.nextElement());
            Lecture lecture = (Lecture)jenrlConstraint.another(this);
            if (!lecture.allStudents().contains(string)) continue;
            fastVector.addElement(lecture);
        }
        return fastVector;
    }

    public Vector conflictLectures(Value value) {
        FastVector fastVector = new FastVector();
        Enumeration enumeration = this.iJenrlConstraints.elements();
        while (enumeration.hasMoreElements()) {
            JenrlConstraint jenrlConstraint = (JenrlConstraint)((Object)enumeration.nextElement());
            Lecture lecture = (Lecture)jenrlConstraint.another(this);
            if (jenrlConstraint.jenrl(this, value) <= 0L) continue;
            fastVector.addElement(lecture);
        }
        return fastVector;
    }

    public Vector conflictLectures() {
        FastVector fastVector = new FastVector();
        Enumeration enumeration = this.activeJenrls().elements();
        while (enumeration.hasMoreElements()) {
            JenrlConstraint jenrlConstraint = (JenrlConstraint)((Object)enumeration.nextElement());
            Lecture lecture = (Lecture)jenrlConstraint.another(this);
            fastVector.addElement(lecture.getName());
        }
        return fastVector;
    }

    public int isInConflict(String string) {
        if (this.getAssignment() == null) {
            return 0;
        }
        int n = 0;
        Enumeration enumeration = this.activeJenrls().elements();
        while (enumeration.hasMoreElements()) {
            JenrlConstraint jenrlConstraint = (JenrlConstraint)((Object)enumeration.nextElement());
            Lecture lecture = (Lecture)jenrlConstraint.another(this);
            if (!lecture.allStudents().contains(string)) continue;
            ++n;
        }
        return n;
    }

    public Set swapStudents() {
        if (this.iSameLectures == null || this.iStudents == null) {
            return null;
        }
        if (this.getAssignment() == null) {
            return null;
        }
        int n = this.countStudentConflicts(this.getAssignment());
        Vector vector = this.conflictStudents();
        if (n == 0) {
            return null;
        }
        HashSet hashSet = new HashSet();
        if (this.iSameLectures.size() > 1) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                int n2 = this.isInConflict(string);
                if (n2 == 0) continue;
                int n3 = -1;
                Vector vector2 = null;
                Vector vector3 = null;
                Enumeration enumeration2 = this.iSameLectures.elements();
                while (enumeration2.hasMoreElements()) {
                    String string2;
                    Lecture lecture = (Lecture)((Object)enumeration2.nextElement());
                    if (lecture.equals((Object)this)) continue;
                    Enumeration enumeration3 = lecture.allStudents().elements();
                    while (enumeration3.hasMoreElements() && !this.isSwapTabu(string, string2 = (String)enumeration3.nextElement()) && (n3 >= 0 || vector2 == null || vector2.size() <= 10)) {
                        int n4 = this.isInConflict(string2) + lecture.isInConflict(string) - lecture.isInConflict(string2) - n2;
                        if (n4 < n3) {
                            if (vector2 == null) {
                                vector2 = new FastVector();
                                vector3 = new FastVector();
                            } else {
                                vector2.clear();
                                vector3.clear();
                            }
                            vector2.addElement(lecture);
                            vector3.addElement(string2);
                            n3 = n4;
                            continue;
                        }
                        if (n4 != n3) continue;
                        if (vector2 == null) {
                            vector2 = new FastVector();
                            vector3 = new FastVector();
                        }
                        vector2.addElement(lecture);
                        vector3.addElement(string2);
                    }
                    if (n3 != 0 || vector2 == null || vector2.size() <= 10) continue;
                }
                if (vector2 == null) continue;
                int n5 = ToolBox.random((int)vector2.size());
                this.swap(string, (Lecture)((Object)vector2.elementAt(n5)), (String)vector3.elementAt(n5), n3);
                hashSet.add(vector2.elementAt(n5));
            }
        } else {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                int n6 = this.isInConflict(string);
                if (n6 == 0) continue;
                int n7 = n6;
                Enumeration enumeration4 = this.conflictLectures(string).elements();
                while (enumeration4.hasMoreElements()) {
                    Set set;
                    Lecture lecture = (Lecture)((Object)enumeration4.nextElement());
                    if (lecture.equals((Object)this) || lecture.getAssignment() == null || lecture.sameLectures().size() <= 1 || (set = lecture.swapStudents()) == null) continue;
                    hashSet.addAll(set);
                }
            }
        }
        return hashSet;
    }

    public boolean isSwapTabu(String string, String string2) {
        return false;
    }

    private void justSwap(String string, Lecture lecture, String string2) {
        CrossListedLecture crossListedLecture;
        Enumeration enumeration;
        Vector vector = null;
        Vector vector2 = null;
        if (this.iAllStudents == null || this.iStudents.contains(string)) {
            vector = this.iStudents;
        } else {
            enumeration = this.iCrossListedLectures.elements();
            while (vector == null && enumeration.hasMoreElements()) {
                crossListedLecture = (CrossListedLecture)enumeration.nextElement();
                if (!crossListedLecture.students().contains(string)) continue;
                vector = crossListedLecture.students();
            }
        }
        if (lecture.iAllStudents == null || lecture.iStudents.contains(string2)) {
            vector2 = lecture.iStudents;
        } else {
            enumeration = lecture.iCrossListedLectures.elements();
            while (vector2 == null && enumeration.hasMoreElements()) {
                crossListedLecture = (CrossListedLecture)enumeration.nextElement();
                if (!crossListedLecture.students().contains(string2)) continue;
                vector2 = crossListedLecture.students();
            }
        }
        vector2.setElementAt(string, vector2.indexOf(string2));
        vector.setElementAt(string2, vector.indexOf(string));
        if (this.iAllStudents != null) {
            this.iAllStudents.setElementAt(string2, this.iAllStudents.indexOf(string));
        }
        if (lecture.iAllStudents != null) {
            lecture.iAllStudents.setElementAt(string, lecture.iAllStudents.indexOf(string2));
        }
    }

    private void swap(String string, Lecture lecture, String string2, int n) {
        Object object;
        Object object2;
        JenrlConstraint jenrlConstraint;
        FastVector fastVector = new FastVector();
        FastVector fastVector2 = this.iJenrlConstraints.elements();
        while (fastVector2.hasMoreElements()) {
            jenrlConstraint = (JenrlConstraint)((Object)fastVector2.nextElement());
            object2 = jenrlConstraint.variables().elements();
            while (object2.hasMoreElements()) {
                object = (Object[])object2.nextElement();
                if (object.equals((Object)this) || !object.allStudents().contains(string)) continue;
                jenrlConstraint.decJenrl();
                if (jenrlConstraint.getJenrl() != 0L) continue;
                fastVector.addElement(jenrlConstraint);
            }
        }
        fastVector2 = lecture.iJenrlConstraints.elements();
        while (fastVector2.hasMoreElements()) {
            jenrlConstraint = (JenrlConstraint)((Object)fastVector2.nextElement());
            object2 = jenrlConstraint.variables().elements();
            while (object2.hasMoreElements()) {
                object = (Lecture)((Object)object2.nextElement());
                if (object.equals((Object)lecture) || !object.allStudents().contains(string2)) continue;
                jenrlConstraint.decJenrl();
                if (jenrlConstraint.getJenrl() != 0L) continue;
                fastVector.addElement(jenrlConstraint);
            }
        }
        if (!fastVector.isEmpty()) {
            fastVector2 = fastVector.toArray();
            for (int i = 0; i < ((Object[])fastVector2).length; ++i) {
                object2 = (Constraint)fastVector2[i];
                object = object2.variables().toArray();
                for (int j = 0; j < ((Object[])object).length; ++j) {
                    object2.removeVariable((Variable)object[j]);
                }
                this.getModel().removeConstraint(object2);
            }
        }
        this.justSwap(string, lecture, string2);
        lecture.iSameStudents.clear();
        this.iSameStudents.clear();
        fastVector2 = new FastVector();
        Object[] objectArray = this.getModel().variables().elements();
        while (objectArray.hasMoreElements()) {
            Lecture lecture2;
            Enumeration enumeration;
            JenrlConstraint jenrlConstraint2;
            Object object3;
            boolean bl;
            object2 = (Lecture)((Object)objectArray.nextElement());
            if (object2.equals((Object)this) || object2.equals((Object)lecture)) continue;
            if (object2.allStudents().contains(string2)) {
                bl = false;
                object3 = this.iJenrlConstraints.elements();
                while (!bl && object3.hasMoreElements()) {
                    jenrlConstraint2 = (JenrlConstraint)((Object)object3.nextElement());
                    enumeration = jenrlConstraint2.variables().elements();
                    while (enumeration.hasMoreElements()) {
                        lecture2 = (Lecture)((Object)enumeration.nextElement());
                        if (!lecture2.equals(object2)) continue;
                        bl = true;
                        jenrlConstraint2.incJenrl();
                    }
                }
                if (!bl) {
                    object3 = new JenrlConstraint(1L, ((TimetableModel)this.getModel()).getViolatedStudentConflictsCounter());
                    object3.addVariable(this);
                    object3.addVariable((Variable)object2);
                    fastVector2.addElement(object3);
                }
            }
            if (!object2.allStudents().contains(string)) continue;
            bl = false;
            object3 = lecture.iJenrlConstraints.elements();
            while (!bl && object3.hasMoreElements()) {
                jenrlConstraint2 = (JenrlConstraint)((Object)object3.nextElement());
                enumeration = jenrlConstraint2.variables().elements();
                while (enumeration.hasMoreElements()) {
                    lecture2 = (Lecture)((Object)enumeration.nextElement());
                    if (!lecture2.equals(object2)) continue;
                    bl = true;
                    jenrlConstraint2.incJenrl();
                }
            }
            if (bl) continue;
            object3 = new JenrlConstraint(1L, ((TimetableModel)this.getModel()).getViolatedStudentConflictsCounter());
            object3.addVariable(lecture);
            object3.addVariable((Variable)object2);
            fastVector2.addElement(object3);
        }
        if (!fastVector2.isEmpty()) {
            objectArray = fastVector2.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                this.getModel().addConstraint((Constraint)objectArray[i]);
            }
        }
    }

    public Vector computeValues() {
        FastVector fastVector = new FastVector();
        this.iSameRoomValues = new Hashtable();
        Enumeration enumeration = this.iRoomLocations.elements();
        while (enumeration.hasMoreElements()) {
            RoomLocation roomLocation = (RoomLocation)enumeration.nextElement();
            FastVector fastVector2 = new FastVector();
            Enumeration enumeration2 = this.iTimeLocations.elements();
            while (enumeration2.hasMoreElements()) {
                TimeLocation timeLocation = (TimeLocation)enumeration2.nextElement();
                Placement placement = new Placement(this, timeLocation, roomLocation);
                placement.setVariable(this);
                if (this.getInitialAssignment() != null && placement.equals(this.getInitialAssignment())) {
                    this.setInitialAssignment(placement);
                    placement.setInitial(true);
                }
                if (this.getAssignment() != null && this.getAssignment().equals((Object)placement)) {
                    this.iValue = this.getAssignment();
                }
                if (this.getBestAssignment() != null && this.getBestAssignment().equals((Object)placement)) {
                    this.setBestAssignment(placement);
                }
                fastVector.addElement(placement);
                fastVector2.addElement(placement);
            }
            this.iSameRoomValues.put(roomLocation.getId(), fastVector2);
        }
        return fastVector;
    }

    public Vector getSameRoomValues(String string) {
        if (sSaveMemory) {
            Enumeration enumeration = this.iRoomLocations.elements();
            while (enumeration.hasMoreElements()) {
                RoomLocation roomLocation = (RoomLocation)enumeration.nextElement();
                if (!roomLocation.getId().equals(string)) continue;
                FastVector fastVector = new FastVector();
                Enumeration enumeration2 = this.iTimeLocations.elements();
                while (enumeration2.hasMoreElements()) {
                    TimeLocation timeLocation = (TimeLocation)enumeration2.nextElement();
                    Placement placement = new Placement(this, timeLocation, roomLocation);
                    placement.setVariable(this);
                    if (this.getInitialAssignment() != null && placement.equals(this.getInitialAssignment())) {
                        this.setInitialAssignment(placement);
                        placement.setInitial(true);
                    }
                    if (this.getAssignment() != null && this.getAssignment().equals((Object)placement)) {
                        this.iValue = this.getAssignment();
                    }
                    if (this.getBestAssignment() != null && this.getBestAssignment().equals((Object)placement)) {
                        this.setBestAssignment(placement);
                    }
                    fastVector.addElement(placement);
                }
                return fastVector;
            }
        }
        return (Vector)this.iSameRoomValues.get(string);
    }

    public Vector values() {
        if (sSaveMemory) {
            FastVector fastVector = new FastVector(this.iRoomLocations.size() * this.iTimeLocations.size());
            Enumeration enumeration = this.iRoomLocations.elements();
            while (enumeration.hasMoreElements()) {
                RoomLocation roomLocation = (RoomLocation)enumeration.nextElement();
                FastVector fastVector2 = new FastVector();
                Enumeration enumeration2 = this.iTimeLocations.elements();
                while (enumeration2.hasMoreElements()) {
                    TimeLocation timeLocation = (TimeLocation)enumeration2.nextElement();
                    Placement placement = new Placement(this, timeLocation, roomLocation);
                    placement.setVariable(this);
                    if (this.getInitialAssignment() != null && placement.equals(this.getInitialAssignment())) {
                        this.setInitialAssignment(placement);
                        placement.setInitial(true);
                    }
                    if (this.getAssignment() != null && this.getAssignment().equals((Object)placement)) {
                        this.iValue = this.getAssignment();
                    }
                    if (this.getBestAssignment() != null && this.getBestAssignment().equals((Object)placement)) {
                        this.setBestAssignment(placement);
                    }
                    fastVector.addElement(placement);
                }
            }
            return fastVector;
        }
        return super.values();
    }

    public boolean equals(Object object) {
        try {
            return this.getId() == ((Lecture)((Object)object)).getId();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public double getBestTimePreference() {
        return this.iBestTimePref;
    }

    public int getBestRoomPreference() {
        return this.iBestRoomPref;
    }

    public int countStudentConflicts(Value value) {
        int n = 0;
        Enumeration enumeration = this.jenrlConstraints().elements();
        while (enumeration.hasMoreElements()) {
            JenrlConstraint jenrlConstraint = (JenrlConstraint)((Object)enumeration.nextElement());
            n = (int)((long)n + jenrlConstraint.jenrl(this, value));
        }
        return n;
    }

    public int countInitialStudentConflicts() {
        Value value = this.getInitialAssignment();
        if (value == null) {
            return 0;
        }
        int n = 0;
        Enumeration enumeration = this.jenrlConstraints().elements();
        while (enumeration.hasMoreElements()) {
            JenrlConstraint jenrlConstraint = (JenrlConstraint)((Object)enumeration.nextElement());
            Lecture lecture = (Lecture)jenrlConstraint.another(this);
            if (lecture.getInitialAssignment() == null || !JenrlConstraint.isInConflict((Placement)value, (Placement)lecture.getInitialAssignment())) continue;
            n = (int)((long)n + jenrlConstraint.getJenrl());
        }
        return n;
    }

    public Hashtable getInitialStudentConflicts() {
        Value value = this.getInitialAssignment();
        if (value == null) {
            return null;
        }
        Hashtable<Lecture, Long> hashtable = new Hashtable<Lecture, Long>();
        Enumeration enumeration = this.jenrlConstraints().elements();
        while (enumeration.hasMoreElements()) {
            JenrlConstraint jenrlConstraint = (JenrlConstraint)((Object)enumeration.nextElement());
            Lecture lecture = (Lecture)jenrlConstraint.another(this);
            if (lecture.getInitialAssignment() == null || !JenrlConstraint.isInConflict((Placement)value, (Placement)lecture.getInitialAssignment())) continue;
            hashtable.put(lecture, new Long(jenrlConstraint.getJenrl()));
        }
        return hashtable;
    }

    public Set initialStudentConflicts() {
        Value value = this.getInitialAssignment();
        if (value == null) {
            return null;
        }
        HashSet hashSet = new HashSet();
        Enumeration enumeration = this.jenrlConstraints().elements();
        while (enumeration.hasMoreElements()) {
            JenrlConstraint jenrlConstraint = (JenrlConstraint)((Object)enumeration.nextElement());
            Lecture lecture = (Lecture)jenrlConstraint.another(this);
            if (lecture.getInitialAssignment() == null || !JenrlConstraint.isInConflict((Placement)value, (Placement)lecture.getInitialAssignment())) continue;
            hashSet.addAll(this.sameStudents(lecture));
        }
        return hashSet;
    }

    public void addContstraint(Constraint constraint) {
        super.addContstraint(constraint);
        if (constraint instanceof JenrlConstraint) {
            this.iJenrlConstraints.addElement(constraint);
        } else if (constraint instanceof DepartmentSpreadConstraint) {
            this.iDeptSpreadConstrain = (DepartmentSpreadConstraint)constraint;
        } else if (constraint instanceof InstructorConstraint) {
            this.iInstructorConstraint = (InstructorConstraint)constraint;
        }
    }

    public void removeContstraint(Constraint constraint) {
        super.removeContstraint(constraint);
        if (this.iJenrlConstraints.contains(constraint)) {
            this.iJenrlConstraints.removeElement(constraint);
        }
    }

    public Vector jenrlConstraints() {
        return this.iJenrlConstraints;
    }

    public long countStudents() {
        return this.iExpectedCapacity;
    }

    public String toString() {
        return this.getName() + " [" + this.getDescription() + "]";
    }

    public String getDescription() {
        return (this.iPattern == null ? "" : this.iPattern + ", ") + this.iExpectedCapacity + " exp. students" + (this.iBestTimePref != 0.0 ? ", " + this.iBestTimePref + " best time pref." : "") + (this.iBestRoomPref != 0 ? ", " + this.iBestRoomPref + " best room pref." : "") + (this.getInitialAssignment() == null ? "" : ", initial " + this.getInitialAssignment().getName()) + ", " + (this.values().size() == 1 ? "value " + ((Placement)((Object)this.values().firstElement())).getName() + " required" : (this.values().size() <= 5 ? "values=[" + this.getValuesString() + "]" : this.values().size() + " values"));
    }

    public String getValuesString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.values().elements();
        while (enumeration.hasMoreElements()) {
            Placement placement = (Placement)((Object)enumeration.nextElement());
            stringBuffer.append(placement.getName()).append(enumeration.hasMoreElements() ? ", " : "");
        }
        return stringBuffer.toString();
    }

    public String getDepartment() {
        return this.iDept;
    }

    public void setDepartment(String string) {
        this.iDept = string;
    }

    public DepartmentSpreadConstraint getDeptSpreadConstraint() {
        return this.iDeptSpreadConstrain;
    }

    public InstructorConstraint getInstructorConstraint() {
        return this.iInstructorConstraint;
    }

    public Vector roomLocations() {
        return this.iRoomLocations;
    }

    public Vector timeLocations() {
        return this.iTimeLocations;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

