/*
 * Decompiled with CFR 0.152.
 */
package ttsolver.heuristics;

import edu.purdue.smas.timetable.serverfwk.ParameterDefinition;
import ifs.solution.Solution;
import ifs.solution.SolutionComparator;
import ifs.util.DataProperties;
import ifs.util.FastVector;
import java.util.Collection;
import org.apache.log4j.Logger;
import ttsolver.TimetableModel;

public class TimetableComparator
implements SolutionComparator {
    protected static Logger sLogger = Logger.getLogger((Class)(class$ttsolver$heuristics$TimetableComparator == null ? (class$ttsolver$heuristics$TimetableComparator = TimetableComparator.class$("ttsolver.heuristics.TimetableComparator")) : class$ttsolver$heuristics$TimetableComparator));
    private double iEmptySingleSlotWeight;
    public static final String USELESS_SLOT_WEIGHT = "Comparator.UselessSlotWeight";
    private double iTimePreferencesWeight;
    public static final String TIME_PREFERENCE_WEIGHT = "Comparator.TimePreferenceWeight";
    private double iStudentConflictWeight;
    public static final String STUDENT_CONFLICT_WEIGHT = "Comparator.StudentConflictWeight";
    private double iRoomPreferencesWeight;
    public static final String ROOM_PREFERENCE_WEIGHT = "Comparator.RoomPreferenceWeight";
    private double iConstrPreferencesWeight;
    public static final String CONSTR_PREFERENCE_WEIGHT = "Comparator.ContrPreferenceWeight";
    private double iHardStudentConflictWeight;
    public static final String HARD_STUDENT_CONFLICT_WEIGHT = "Comparator.HardStudentConflictWeight";
    private double iTooBigRoomWeight;
    public static final String TOO_BIG_ROOM_WEIGHT = "Comparator.TooBigRoomWeight";
    private boolean iCompareMpp;
    public static final String DISTANCE_INSTRUCTOR_PREFERENCE_WEIGHT = "Comparator.DistanceInstructorPreferenceWeight";
    private double iDistanceInstructorPreferenceWeight;
    public static final String PERTURBATION_PENALTY_WEIGHT = "Comparator.PerturbationPenaltyWeight";
    private double iPerturbationPenaltyWeight;
    public static final String DEPT_SPREAD_PENALTY_WEIGHT = "Comparator.DeptSpreadPenaltyWeight";
    private double iDeptSpreadPenaltyWeight;
    static /* synthetic */ Class class$ttsolver$heuristics$TimetableComparator;

    public static Collection parameters() {
        FastVector fastVector = new FastVector();
        ParameterDefinition.Dependency dependency = new ParameterDefinition.Dependency("General.SwitchStudents", "true");
        ParameterDefinition.Dependency dependency2 = new ParameterDefinition.Dependency("General.UseDepartmentSpreadConstraints", "false");
        fastVector.addElement(new ParameterDefinition("Solution Comparator - Weights", USELESS_SLOT_WEIGHT, "Useless slots", 1, "0.0"));
        fastVector.addElement(new ParameterDefinition("Solution Comparator - Weights", TIME_PREFERENCE_WEIGHT, "Time preferences", 1, "1.0"));
        fastVector.addElement(new ParameterDefinition("Solution Comparator - Weights", ROOM_PREFERENCE_WEIGHT, "Room preferences", 1, "0.1"));
        fastVector.addElement(new ParameterDefinition("Solution Comparator - Weights", STUDENT_CONFLICT_WEIGHT, "Student conflicts", 1, "0.2"));
        fastVector.addElement(new ParameterDefinition("Solution Comparator - Weights", HARD_STUDENT_CONFLICT_WEIGHT, "Hard student conflicts", 1, "1.0").addDependency(dependency));
        fastVector.addElement(new ParameterDefinition("Solution Comparator - Weights", CONSTR_PREFERENCE_WEIGHT, "Group constraint preferences", 1, "1.0"));
        fastVector.addElement(new ParameterDefinition("Solution Comparator - Weights", TOO_BIG_ROOM_WEIGHT, "Too big rooms", 1, "0.0"));
        fastVector.addElement(new ParameterDefinition("Solution Comparator - Weights", DISTANCE_INSTRUCTOR_PREFERENCE_WEIGHT, "Distance instructor preferences", 1, "1.0"));
        fastVector.addElement(new ParameterDefinition("Solution Comparator - Weights", PERTURBATION_PENALTY_WEIGHT, "Perturbation penalty", 1, "1.0"));
        fastVector.addElement(new ParameterDefinition("Solution Comparator - Weights", DEPT_SPREAD_PENALTY_WEIGHT, "Deparment balancing penalty", 1, "1.0").addDependency(dependency2));
        return fastVector;
    }

    public TimetableComparator(DataProperties dataProperties) {
        this.iEmptySingleSlotWeight = dataProperties.getPropertyDouble(USELESS_SLOT_WEIGHT, 0.0);
        this.iTimePreferencesWeight = dataProperties.getPropertyDouble(TIME_PREFERENCE_WEIGHT, 1.0);
        this.iRoomPreferencesWeight = dataProperties.getPropertyDouble(ROOM_PREFERENCE_WEIGHT, 0.1);
        this.iConstrPreferencesWeight = dataProperties.getPropertyDouble(CONSTR_PREFERENCE_WEIGHT, 1.0);
        if (dataProperties.getPropertyBoolean("General.SwitchStudents", true)) {
            this.iHardStudentConflictWeight = dataProperties.getPropertyDouble(HARD_STUDENT_CONFLICT_WEIGHT, 1.0);
            this.iStudentConflictWeight = dataProperties.getPropertyDouble(STUDENT_CONFLICT_WEIGHT, 0.2);
        } else {
            this.iHardStudentConflictWeight = 0.0;
            this.iStudentConflictWeight = dataProperties.getPropertyDouble(STUDENT_CONFLICT_WEIGHT, 1.0);
        }
        this.iDistanceInstructorPreferenceWeight = dataProperties.getPropertyDouble(DISTANCE_INSTRUCTOR_PREFERENCE_WEIGHT, 1.0);
        this.iTooBigRoomWeight = dataProperties.getPropertyDouble(TOO_BIG_ROOM_WEIGHT, 0.0);
        this.iCompareMpp = dataProperties.getPropertyBoolean("General.MPP", false);
        this.iPerturbationPenaltyWeight = dataProperties.getPropertyDouble(PERTURBATION_PENALTY_WEIGHT, 1.0);
        this.iDeptSpreadPenaltyWeight = dataProperties.getPropertyDouble(DEPT_SPREAD_PENALTY_WEIGHT, 1.0);
    }

    public boolean isBetterThanBestSolution(Solution solution) {
        if (solution.getBestInfo() == null) {
            return true;
        }
        TimetableModel timetableModel = (TimetableModel)solution.getModel();
        int n = timetableModel.unassignedVariables().size();
        if (timetableModel.getBestUnassignedVariables() != n) {
            return timetableModel.getBestUnassignedVariables() > n;
        }
        int n2 = 0;
        int n3 = 0;
        if (this.iTooBigRoomWeight != 0.0) {
            n2 = timetableModel.bestTooBigRooms();
            n3 = timetableModel.countTooBigRooms();
        }
        long l = 0L;
        long l2 = 0L;
        if (this.iEmptySingleSlotWeight != 0.0) {
            l = timetableModel.bestUselessSlots();
            l2 = timetableModel.getUselessSlots();
        }
        long l3 = 0L;
        long l4 = 0L;
        if (this.iHardStudentConflictWeight != 0.0) {
            l3 = timetableModel.bestHardStudentConflicts();
            l4 = timetableModel.getHardStudentConflicts();
        }
        double d = 0.0;
        double d2 = 0.0;
        if (this.iCompareMpp && this.iPerturbationPenaltyWeight != 0.0) {
            d2 = solution.getPerturbationsCounter().getPerturbationPenalty(solution);
            d = solution.getBestPerturbationsPenalty();
        }
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.iDeptSpreadPenaltyWeight != 0.0) {
            d4 = timetableModel.getDepartmentSpreadPenalty();
            d3 = timetableModel.bestDepartmentSpreadPenalty();
        }
        double d5 = this.iEmptySingleSlotWeight * (double)l + this.iTimePreferencesWeight * timetableModel.bestGlobalTimePreference() + this.iRoomPreferencesWeight * (double)timetableModel.bestGlobalRoomPreference() + this.iConstrPreferencesWeight * (double)timetableModel.bestGlobalGroupConstraintPreference() + this.iStudentConflictWeight * (double)timetableModel.bestViolatedStudentConflicts() + this.iHardStudentConflictWeight * (double)l3 + this.iTooBigRoomWeight * (double)n2 + this.iDistanceInstructorPreferenceWeight * (double)timetableModel.bestInstructorDistancePreference() + this.iPerturbationPenaltyWeight * d + this.iDeptSpreadPenaltyWeight * d3;
        double d6 = this.iEmptySingleSlotWeight * (double)l2 + this.iTimePreferencesWeight * timetableModel.getGlobalTimePreference() + this.iRoomPreferencesWeight * (double)timetableModel.getGlobalRoomPreference() + this.iConstrPreferencesWeight * (double)timetableModel.getGlobalGroupConstraintPreference() + this.iStudentConflictWeight * (double)timetableModel.getViolatedStudentConflicts() + this.iHardStudentConflictWeight * (double)l4 + this.iTooBigRoomWeight * (double)n3 + this.iDistanceInstructorPreferenceWeight * (double)timetableModel.getInstructorDistancePreference() + this.iPerturbationPenaltyWeight * d2 + this.iDeptSpreadPenaltyWeight * d4;
        return d6 < d5;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

