/*
 * Decompiled with CFR 0.152.
 */
package ttsolver.heuristics;

import edu.purdue.smas.timetable.util.Constants;
import ifs.extension.ConflictStatistics;
import ifs.extension.Extension;
import ifs.extension.MacPropagation;
import ifs.extension.ViolatedInitials;
import ifs.heuristics.VariableSelection;
import ifs.model.Constraint;
import ifs.model.Value;
import ifs.model.Variable;
import ifs.solution.Solution;
import ifs.solver.Solver;
import ifs.util.DataProperties;
import ifs.util.FastVector;
import ifs.util.ToolBox;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import ttsolver.TimetableModel;
import ttsolver.constraint.GroupConstraint;
import ttsolver.constraint.InstructorConstraint;
import ttsolver.constraint.JenrlConstraint;
import ttsolver.constraint.RoomConstraint;
import ttsolver.model.Lecture;
import ttsolver.model.Placement;

public class LectureSelection
implements VariableSelection {
    private static Logger sLogger = Logger.getLogger((Class)(class$ttsolver$heuristics$LectureSelection == null ? (class$ttsolver$heuristics$LectureSelection = LectureSelection.class$("ttsolver.heuristics.LectureSelection")) : class$ttsolver$heuristics$LectureSelection));
    private double iRandomWalkProb;
    private double iDomainSizeWeight;
    private double iGoodValuesWeight;
    private double iNrAssignmentsWeight;
    private double iConstraintsWeight;
    private double iInitialAssignmentWeight;
    private boolean iRouletteWheelSelection;
    private boolean iUnassignWhenNotGood;
    private double iEmptySingleSlotWeight;
    private double iTooBigRoomWeight;
    private double iTimePreferencesWeight;
    private double iStudentConflictWeight;
    private double iRoomPreferencesWeight;
    private double iConstrPreferencesWeight;
    private double iHardStudentConflictWeight;
    private double iDistanceInstructorPreferenceWeight;
    private double iDeptSpreadPenaltyWeight;
    private boolean iSubSetSelection;
    private double iSelectionSubSetPart;
    private int iSelectionSubSetMinSize;
    private boolean iRW = false;
    private boolean iMPP = false;
    private boolean iSwitchStudents = false;
    private ConflictStatistics iStat = null;
    private MacPropagation iProp = null;
    private ViolatedInitials iViolatedInitials = null;
    static /* synthetic */ Class class$ttsolver$heuristics$LectureSelection;

    public LectureSelection(DataProperties dataProperties) {
        this.iRouletteWheelSelection = dataProperties.getPropertyBoolean("Lecture.RouletteWheelSelection", true);
        this.iUnassignWhenNotGood = dataProperties.getPropertyBoolean("Lecture.UnassignWhenNotGood", false);
        this.iRW = dataProperties.getPropertyBoolean("General.RandomWalk", true);
        this.iRandomWalkProb = !this.iRW ? 0.0 : dataProperties.getPropertyDouble("Lecture.RandomWalkProb", 1.0);
        this.iGoodValuesWeight = dataProperties.getPropertyDouble("Lecture.GoodValueProb", 1.0);
        this.iDomainSizeWeight = dataProperties.getPropertyDouble("Lecture.DomainSizeWeight", 30.0);
        this.iNrAssignmentsWeight = dataProperties.getPropertyDouble("Lecture.NrAssignmentsWeight", 10.0);
        this.iConstraintsWeight = dataProperties.getPropertyDouble("Lecture.NrConstraintsWeight", 0.0);
        this.iMPP = dataProperties.getPropertyBoolean("General.MPP", false);
        this.iInitialAssignmentWeight = !this.iMPP ? 0.0 : dataProperties.getPropertyDouble("Lecture.InitialAssignmentWeight", 20.0);
        this.iEmptySingleSlotWeight = dataProperties.getPropertyDouble("Lecture.UselessSlotWeight", dataProperties.getPropertyDouble("Comparator.UselessSlotWeight", 0.0));
        this.iTooBigRoomWeight = dataProperties.getPropertyDouble("Lecture.TooBigRoomWeight", dataProperties.getPropertyDouble("Comparator.TooBigRoomWeight", 0.0));
        this.iTimePreferencesWeight = dataProperties.getPropertyDouble("Lecture.TimePreferenceWeight", dataProperties.getPropertyDouble("Comparator.TimePreferenceWeight", 1.0));
        this.iStudentConflictWeight = dataProperties.getPropertyDouble("Lecture.StudentConflictWeight", dataProperties.getPropertyDouble("Comparator.StudentConflictWeight", 0.2));
        this.iRoomPreferencesWeight = dataProperties.getPropertyDouble("Lecture.RoomPreferenceWeight", dataProperties.getPropertyDouble("Comparator.RoomPreferenceWeight", 0.1));
        this.iConstrPreferencesWeight = dataProperties.getPropertyDouble("Lecture.ContrPreferenceWeight", dataProperties.getPropertyDouble("Comparator.ContrPreferenceWeight", 1.0));
        this.iSwitchStudents = dataProperties.getPropertyBoolean("General.SwitchStudents", true);
        this.iHardStudentConflictWeight = !this.iSwitchStudents ? 0.0 : dataProperties.getPropertyDouble("Lecture.HardStudentConflictWeight", dataProperties.getPropertyDouble("Comparator.HardStudentConflictWeight", 1.0));
        this.iDistanceInstructorPreferenceWeight = dataProperties.getPropertyDouble("Lecture.DistanceInstructorPreferenceWeight", dataProperties.getPropertyDouble("Comparator.DistanceInstructorPreferenceWeight", 1.0));
        this.iDeptSpreadPenaltyWeight = dataProperties.getPropertyDouble("Lecture.DeptSpreadPenaltyWeight", dataProperties.getPropertyDouble("Comparator.DeptSpreadPenaltyWeight", 1.0));
        this.iSubSetSelection = dataProperties.getPropertyBoolean("Lecture.SelectionSubSet", true);
        this.iSelectionSubSetMinSize = dataProperties.getPropertyInt("Lecture.SelectionSubSetMinSize", 10);
        this.iSelectionSubSetPart = dataProperties.getPropertyDouble("Lecture.SelectionSubSetPart", 0.2);
    }

    public static Collection parameters() {
        FastVector fastVector = new FastVector();
        return fastVector;
    }

    public void init(Solver solver) {
        Enumeration enumeration = solver.getExtensions().elements();
        while (enumeration.hasMoreElements()) {
            Extension extension = (Extension)enumeration.nextElement();
            if (extension instanceof ConflictStatistics) {
                this.iStat = (ConflictStatistics)extension;
            }
            if (extension instanceof MacPropagation) {
                this.iProp = (MacPropagation)extension;
            }
            if (!(extension instanceof ViolatedInitials)) continue;
            this.iViolatedInitials = (ViolatedInitials)extension;
        }
    }

    public Variable selectVariable(Solution solution) {
        Variable variable;
        Variable variable2;
        int n;
        if (solution.getModel().unassignedVariables().isEmpty()) {
            Vector vector = solution.getModel().perturbVariables();
            if (vector.isEmpty()) {
                vector = solution.getModel().variables();
            }
            Vector vector2 = null;
            int n2 = 0;
            int n3 = 0;
            Iterator iterator = (this.iSubSetSelection ? ToolBox.subSet((Collection)vector, (double)this.iSelectionSubSetPart, (int)this.iSelectionSubSetMinSize) : vector).iterator();
            while (iterator.hasNext()) {
                int n4;
                Variable variable3 = (Variable)iterator.next();
                Value value = variable3.getAssignment();
                int n5 = n4 = this.iStudentConflictWeight != 0.0 ? ((Lecture)variable3).countStudentConflicts(value) : 0;
                boolean bl = ((Lecture)variable3).sameLectures() == null ? false : ((Lecture)variable3).sameLectures().size() > 1;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                boolean bl2 = ((Placement)value).getRoomLocation().getRoomSize() > TimetableModel.getMaxCapacity(((Lecture)variable3).countStudents());
                Enumeration enumeration = variable3.constraints().elements();
                while (enumeration.hasMoreElements()) {
                    Object object;
                    Constraint constraint = (Constraint)enumeration.nextElement();
                    if (this.iDistanceInstructorPreferenceWeight != 0.0 && constraint instanceof InstructorConstraint) {
                        n9 += ((InstructorConstraint)constraint).getPreference(value);
                    }
                    if (this.iHardStudentConflictWeight != 0.0 && !bl && constraint instanceof JenrlConstraint) {
                        object = (JenrlConstraint)constraint;
                        Vector vector3 = ((Lecture)object.another(variable3)).sameLectures();
                        if (vector3 != null && vector3.size() != 1) continue;
                        n8 = (int)((long)n8 + ((JenrlConstraint)constraint).jenrl(variable3, value));
                        continue;
                    }
                    if (this.iConstrPreferencesWeight != 0.0 && constraint instanceof GroupConstraint) {
                        object = (GroupConstraint)constraint;
                        n6 += ((GroupConstraint)((Object)object)).getCurrentPreference();
                        continue;
                    }
                    if (this.iEmptySingleSlotWeight == 0.0 || !(constraint instanceof RoomConstraint)) continue;
                    object = (RoomConstraint)constraint;
                    for (int i = 0; i < ((Placement)value).getTimeLocation().getStartSlots().length; ++i) {
                        int n10 = ((Placement)value).getTimeLocation().getStartSlots()[i];
                        int n11 = n10 + ((Placement)value).getTimeLocation().getLength() - 1;
                        if (n10 % Constants.SLOTS_PER_DAY >= 2 && ((RoomConstraint)((Object)object)).getResource()[n10 - 1] == null && ((RoomConstraint)((Object)object)).getResource()[n10 - 2] != null) {
                            ++n7;
                        }
                        if (n11 % Constants.SLOTS_PER_DAY >= Constants.SLOTS_PER_DAY - 2 || ((RoomConstraint)((Object)object)).getResource()[n10 + 1] != null || ((RoomConstraint)((Object)object)).getResource()[n10 + 2] == null) continue;
                        ++n7;
                    }
                }
                int n12 = ((Placement)value).getRoomLocation().getPreference();
                double d = this.iDeptSpreadPenaltyWeight == 0.0 || ((Lecture)variable3).getDeptSpreadConstraint() == null ? 0 : ((Lecture)variable3).getDeptSpreadConstraint().getPenalty();
                int n13 = (int)(100.0 * (this.iStudentConflictWeight * (double)n4 + this.iHardStudentConflictWeight * (double)n8 + this.iTimePreferencesWeight * ((Placement)value).getTimeLocation().getNormalizedPreference() + this.iEmptySingleSlotWeight * (double)n7 + this.iRoomPreferencesWeight * (double)n12 + (bl2 ? this.iTooBigRoomWeight : 0.0) + this.iConstrPreferencesWeight * (double)n6 + this.iDistanceInstructorPreferenceWeight * (double)n9 + this.iDeptSpreadPenaltyWeight * d));
                if (vector2 == null || n13 > n2 || n13 == n2 && n12 + n6 > n3) {
                    if (vector2 == null) {
                        vector2 = new FastVector();
                    } else {
                        vector2.clear();
                    }
                    vector2.addElement(variable3);
                    n2 = n13;
                    n3 = n12 + n6;
                    continue;
                }
                if (n13 != n2 || n12 + n6 != n3) continue;
                vector2.addElement(variable3);
            }
            return (Variable)ToolBox.random(vector2);
        }
        if (ToolBox.random() <= this.iRandomWalkProb) {
            return (Variable)ToolBox.random((Collection)solution.getModel().unassignedVariables());
        }
        if (this.iProp != null && this.iUnassignWhenNotGood) {
            n = 0;
            FastVector fastVector = new FastVector();
            Iterator iterator = ToolBox.subSet((Collection)solution.getModel().unassignedVariables(), (double)this.iSelectionSubSetPart, (int)this.iSelectionSubSetMinSize).iterator();
            while (iterator.hasNext()) {
                variable2 = (Variable)iterator.next();
                if (!this.iProp.goodValues(variable2).isEmpty()) continue;
                fastVector.addElement(variable2);
            }
            if (!fastVector.isEmpty()) {
                if (ToolBox.random() < 0.02) {
                    return (Variable)ToolBox.random((Collection)solution.getModel().assignedVariables());
                }
                for (int i = 0; i < 10; ++i) {
                    variable2 = (Variable)ToolBox.random((Collection)fastVector);
                    variable = (Value)ToolBox.random((Collection)variable2.values());
                    if (this.iProp.noGood((Value)variable).isEmpty()) continue;
                    return ((Value)ToolBox.random((Collection)this.iProp.noGood((Value)variable))).variable();
                }
            }
        }
        if (this.iRouletteWheelSelection) {
            Object object;
            n = 0;
            int n14 = 0;
            int n15 = 0;
            long l = 0L;
            Vector vector = this.iSubSetSelection ? ToolBox.subSet((Collection)solution.getModel().unassignedVariables(), (double)this.iSelectionSubSetPart, (int)this.iSelectionSubSetMinSize) : solution.getModel().unassignedVariables();
            FastVector fastVector = vector.iterator();
            while (fastVector.hasNext()) {
                Variable variable4 = (Variable)fastVector.next();
                n = Math.max(n, variable4.values().size());
                n14 = this.iProp == null ? 0 : Math.max(n14, this.iProp.goodValues(variable4).size());
                n15 = Math.max(n15, variable4.constraints().size());
                l = Math.max(l, variable4.countAssignments());
            }
            fastVector = new FastVector();
            int n16 = 0;
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                object = (Variable)iterator.next();
                long l2 = Math.round(this.iDomainSizeWeight * ((double)(n - object.values().size()) / (double)n) + (this.iProp == null ? 0.0 : this.iGoodValuesWeight * ((double)(n14 - this.iProp.goodValues((Variable)object).size()) / (double)n14)) + this.iNrAssignmentsWeight * ((double)object.countAssignments() / (double)l) + this.iConstraintsWeight * ((double)(n15 - object.constraints().size()) / (double)n15) + this.iInitialAssignmentWeight * (object.getInitialAssignment() != null ? (double)solution.getModel().conflictValues(object.getInitialAssignment()).size() : 0.0));
                if (l2 <= 0L) continue;
                n16 = (int)((long)n16 + l2);
                fastVector.addElement(new Integer(n16));
            }
            if (n16 > 0) {
                int n17 = ToolBox.random((int)n16);
                object = vector.iterator();
                for (int i = 0; object.hasNext() && i < fastVector.size(); ++i) {
                    Variable variable5 = (Variable)object.next();
                    int n18 = (Integer)fastVector.elementAt(i);
                    if (n18 <= n17) continue;
                    return variable5;
                }
            }
        } else {
            Vector vector = null;
            long l = 0L;
            variable2 = ToolBox.subSet((Collection)solution.getModel().unassignedVariables(), (double)this.iSelectionSubSetPart, (int)this.iSelectionSubSetMinSize).iterator();
            while (variable2.hasNext()) {
                variable = (Variable)variable2.next();
                long l3 = (long)(this.iDomainSizeWeight * (double)variable.values().size() + this.iGoodValuesWeight * (double)(this.iProp == null ? 0 : this.iProp.goodValues(variable).size()) + this.iNrAssignmentsWeight * (double)variable.countAssignments() + this.iConstraintsWeight * (double)variable.constraints().size() + this.iInitialAssignmentWeight * (variable.getInitialAssignment() != null ? (double)solution.getModel().conflictValues(variable.getInitialAssignment()).size() : 0.0));
                if (vector == null || l > l3) {
                    if (vector == null) {
                        vector = new FastVector();
                    } else {
                        vector.clear();
                    }
                    l = l3;
                    vector.addElement(variable);
                    continue;
                }
                if (l3 != l) continue;
                vector.addElement(variable);
            }
            if (!vector.isEmpty()) {
                return (Variable)ToolBox.random((Collection)vector);
            }
        }
        return (Variable)ToolBox.random((Collection)solution.getModel().unassignedVariables());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

