/*
 * Decompiled with CFR 0.152.
 */
package ttsolver;

import edu.purdue.smas.timetable.util.Constants;
import ifs.solution.Solution;
import ifs.util.ToolBox;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import ttsolver.TimetableModel;
import ttsolver.TimetableSaver;
import ttsolver.constraint.GroupConstraint;
import ttsolver.constraint.RoomConstraint;
import ttsolver.model.Lecture;
import ttsolver.model.Placement;
import ttsolver.model.RoomLocation;
import ttsolver.model.TimeLocation;

public class TimetableXMLSaver
extends TimetableSaver {
    private static Logger sLogger = Logger.getLogger((Class)(class$ttsolver$TimetableXMLSaver == null ? (class$ttsolver$TimetableXMLSaver = TimetableXMLSaver.class$("ttsolver.TimetableXMLSaver")) : class$ttsolver$TimetableXMLSaver));
    private static DecimalFormat[] sDF = new DecimalFormat[]{new DecimalFormat(""), new DecimalFormat("0"), new DecimalFormat("00"), new DecimalFormat("000"), new DecimalFormat("0000"), new DecimalFormat("00000"), new DecimalFormat("000000"), new DecimalFormat("0000000")};
    public static boolean DEBUG = false;
    private TimetableModel iModel = null;
    private Solution iSolution = null;
    private boolean iConvertIds = this.getModel().getProperties().getPropertyBoolean("General.ConvertIds", false);
    private File iOutputFolder = new File(this.getModel().getProperties().getProperty("General.Output"));
    static /* synthetic */ Class class$ttsolver$TimetableXMLSaver;

    public TimetableXMLSaver(Solution solution) {
        super(solution);
        this.iSolution = solution;
        this.iModel = (TimetableModel)this.iSolution.getModel();
    }

    public void setSolution(Solution solution) {
        this.iSolution = solution;
        this.iModel = (TimetableModel)this.iSolution.getModel();
    }

    private static String getId(Hashtable hashtable, boolean bl, Object object) {
        String string = (String)hashtable.get(object);
        if (string == null) {
            string = String.valueOf(hashtable.size() + 1);
            hashtable.put(object, string);
        }
        return bl ? string : object.toString();
    }

    public void save(PrintWriter printWriter) throws Exception {
        Element element;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        Enumeration enumeration;
        Hashtable hashtable;
        Object object11;
        this.iOutputFolder.mkdirs();
        File file = new File(this.iOutputFolder, "solution.xml");
        sLogger.debug((Object)("Writting XML data to:" + file));
        Document document = DocumentHelper.createDocument();
        document.addComment("Large Lecture Room Timetabling");
        if (!this.iModel.assignedVariables().isEmpty()) {
            object11 = new StringBuffer("Solution Info:\n");
            hashtable = this.iSolution == null ? this.iModel.getInfo() : this.iSolution.getInfo();
            enumeration = edu.purdue.smas.timetable.util.ToolBox.sortEnumeration(((Dictionary)hashtable).keys());
            while (enumeration.hasMoreElements()) {
                object10 = (String)enumeration.nextElement();
                object9 = ((Dictionary)hashtable).get(object10);
                ((StringBuffer)object11).append("    " + (String)object10 + ": " + object9 + "\n");
            }
            document.addComment(((StringBuffer)object11).toString());
        }
        object11 = document.addElement("llrt");
        object11.addAttribute("semester", this.iModel.getProperties().getProperty("Data.Semester"));
        object11.addAttribute("year", this.iModel.getProperties().getProperty("Data.Year"));
        object11.addAttribute("version", this.iModel.getProperties().getProperty("Data.Version"));
        object11.addAttribute("created", String.valueOf(new Date()));
        object11.addAttribute("nrDays", String.valueOf(Constants.DAY_CODES.length));
        object11.addAttribute("halfHoursPerDay", String.valueOf(Constants.SLOTS_PER_DAY));
        hashtable = object11.addElement("instructors").addAttribute("count", String.valueOf(this.iModel.getInstructorConstraints().size()));
        enumeration = object11.addElement("departments");
        object10 = new HashSet();
        object9 = object11.addElement("rooms").addAttribute("count", String.valueOf(this.iModel.getRoomConstraints().size()));
        Hashtable hashtable2 = new Hashtable();
        Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
        Element element2 = this.iModel.getRoomConstraints().elements();
        while (element2.hasMoreElements()) {
            object8 = (RoomConstraint)((Object)element2.nextElement());
            object7 = object9.addElement("room").addAttribute("id", TimetableXMLSaver.getId(hashtable2, this.iConvertIds, ((RoomConstraint)((Object)object8)).getResourceId()));
            hashtable3.put(TimetableXMLSaver.getId(hashtable2, this.iConvertIds, ((RoomConstraint)((Object)object8)).getResourceId()), object7);
        }
        element2 = object11.addElement("classes").addAttribute("count", String.valueOf(this.iModel.variables().size()));
        object8 = new Hashtable();
        object7 = new Hashtable();
        Hashtable hashtable4 = new Hashtable();
        Hashtable hashtable5 = new Hashtable();
        HashSet<Object> hashSet = new HashSet<Object>();
        this.iModel.variables().addAll(this.iModel.ignoredClasses());
        Element element3 = this.iModel.variables().elements();
        while (element3.hasMoreElements()) {
            object6 = (Lecture)((Object)element3.nextElement());
            object5 = (Placement)object6.getAssignment();
            object4 = element2.addElement("class").addAttribute("id", TimetableXMLSaver.getId((Hashtable)object8, this.iConvertIds, String.valueOf(((Lecture)((Object)object6)).getClassId())));
            object4.addAttribute("course", TimetableXMLSaver.getId((Hashtable)object7, true, ((Lecture)((Object)object6)).sameLectures()));
            object4.addAttribute("expectedCapacity", String.valueOf(((Lecture)((Object)object6)).countStudents()));
            if (((Lecture)((Object)object6)).getDepartment() != null) {
                object4.addAttribute("department", TimetableXMLSaver.getId(hashtable4, this.iConvertIds, ((Lecture)((Object)object6)).getDepartment()));
                ((HashSet)object10).add(((Lecture)((Object)object6)).getDepartment());
            }
            if (((Lecture)((Object)object6)).getInstructorConstraint() != null) {
                object3 = object4.addElement("instructor").addAttribute("id", TimetableXMLSaver.getId(hashtable5, this.iConvertIds, ((Lecture)((Object)object6)).getInstructorConstraint().getResourceId()));
                if (object5 != null) {
                    object3.addAttribute("solution", "true");
                }
            }
            object3 = ((Lecture)((Object)object6)).roomLocations().elements();
            while (object3.hasMoreElements()) {
                object2 = (RoomLocation)object3.nextElement();
                object = object4.addElement("room");
                object.addAttribute("id", TimetableXMLSaver.getId(hashtable2, this.iConvertIds, ((RoomLocation)object2).getId()));
                object.addAttribute("pref", String.valueOf(((RoomLocation)object2).getPreference()));
                if (object5 != null && ((Placement)((Object)object5)).getRoomLocation().equals(object2)) {
                    object.addAttribute("solution", "true");
                }
                if (!hashSet.add(object2)) continue;
                element = (Element)hashtable3.get(((RoomLocation)object2).getId());
                element.addAttribute("capacity", String.valueOf(((RoomLocation)object2).getRoomSize()));
                if (((RoomLocation)object2).getPosX() <= 0L && ((RoomLocation)object2).getPosY() <= 0L) continue;
                element.addAttribute("location", ((RoomLocation)object2).getPosX() + "," + ((RoomLocation)object2).getPosY());
            }
            object3 = ((Lecture)((Object)object6)).timeLocations().elements();
            while (object3.hasMoreElements()) {
                object2 = (TimeLocation)object3.nextElement();
                object = object4.addElement("time");
                object.addAttribute("days", sDF[7].format(Long.parseLong(Integer.toBinaryString(((TimeLocation)object2).getDayCode()))));
                object.addAttribute("start", String.valueOf(((TimeLocation)object2).getStartSlot()));
                object.addAttribute("length", String.valueOf(((TimeLocation)object2).getLength()));
                object.addAttribute("pref", String.valueOf((int)((TimeLocation)object2).getNormalizedPreference()));
                if (object5 == null || !((Placement)((Object)object5)).getTimeLocation().equals(object2)) continue;
                object.addAttribute("solution", "true");
            }
        }
        element2.addAttribute("courses", String.valueOf(((Hashtable)object7).size()));
        element3 = object11.addElement("groupConstraints").addAttribute("count", String.valueOf(this.iModel.getGroupConstraints().size()));
        object6 = new Hashtable();
        object5 = this.iModel.getGroupConstraints().elements();
        while (object5.hasMoreElements()) {
            object4 = (GroupConstraint)((Object)object5.nextElement());
            object3 = element3.addElement("constraint").addAttribute("id", TimetableXMLSaver.getId((Hashtable)object6, this.iConvertIds, String.valueOf(((GroupConstraint)((Object)object4)).getId())));
            object3.addAttribute("type", ((GroupConstraint)((Object)object4)).getTypeStr());
            object3.addAttribute("pref", ((GroupConstraint)((Object)object4)).getPrologPreference());
            object2 = object4.variables().elements();
            while (object2.hasMoreElements()) {
                object = (Lecture)((Object)object2.nextElement());
                object3.addElement("class").addAttribute("id", TimetableXMLSaver.getId((Hashtable)object8, this.iConvertIds, String.valueOf(((Lecture)((Object)object)).getId())));
            }
        }
        object5 = new Hashtable();
        object4 = this.iModel.variables().elements();
        while (object4.hasMoreElements()) {
            object3 = (Lecture)((Object)object4.nextElement());
            object2 = ((Lecture)((Object)object3)).students().elements();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                element = (Element)((Hashtable)object5).get(object);
                if (element == null) {
                    element = new Vector();
                    ((Hashtable)object5).put(object, element);
                }
                element.add(TimetableXMLSaver.getId((Hashtable)object8, this.iConvertIds, String.valueOf(((Lecture)((Object)object3)).getId())));
            }
        }
        object4 = object11.addElement("students").addAttribute("count", String.valueOf(((Hashtable)object5).size()));
        object3 = new Hashtable();
        object2 = ToolBox.sortEnumeration(((Hashtable)object5).keys(), (Comparator)new IdComparator());
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            element = object4.addElement("student").addAttribute("id", TimetableXMLSaver.getId((Hashtable)object3, this.iConvertIds, object));
            Vector vector = (Vector)((Hashtable)object5).get(object);
            Collections.sort(vector);
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                element.addElement("class").addAttribute("id", (String)enumeration2.nextElement());
            }
        }
        enumeration.addAttribute("count", String.valueOf(((HashSet)object10).size()));
        object2 = new FileOutputStream(file);
        new XMLWriter((OutputStream)object2, OutputFormat.createPrettyPrint()).write(document);
        ((OutputStream)object2).flush();
        ((FileOutputStream)object2).close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class IdComparator
    implements Comparator {
        private IdComparator() {
        }

        public int compare(Object object, Object object2) {
            return Long.valueOf((String)object).compareTo(Long.valueOf((String)object2));
        }
    }
}

