/*
 * Decompiled with CFR 0.152.
 */
package ttsolver;

import edu.purdue.smas.timetable.util.Debug;
import ifs.model.Constraint;
import ifs.model.Model;
import ifs.model.Value;
import ifs.util.Counter;
import ifs.util.DataProperties;
import ifs.util.FastVector;
import ifs.util.Progress;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import ttsolver.constraint.DepartmentSpreadConstraint;
import ttsolver.constraint.GroupConstraint;
import ttsolver.constraint.InstructorConstraint;
import ttsolver.constraint.JenrlConstraint;
import ttsolver.constraint.RoomConstraint;
import ttsolver.model.Lecture;
import ttsolver.model.Placement;

public class TimetableModel
extends Model {
    private static Logger sLogger = Logger.getLogger((Class)(class$ttsolver$TimetableModel == null ? (class$ttsolver$TimetableModel = TimetableModel.class$("ttsolver.TimetableModel")) : class$ttsolver$TimetableModel));
    private static DecimalFormat sDoubleFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
    private static SimpleDateFormat sDateFormat = new SimpleDateFormat("dd-MMM-yy_HHmmss", Locale.US);
    private long iGlobalRoomPreference = 0L;
    private double iGlobalTimePreference = 0.0;
    private long iBestRoomPreference = 0L;
    private long iBestInstructorDistancePreference = 0L;
    private double iBestTimePreference = 0.0;
    private int iBestDepartmentSpreadPenalty = 0;
    private Counter iGlobalGroupConstraintPreference = new Counter();
    private Counter iViolatedStudentConflicts = new Counter();
    private FastVector iInstructorConstraints = new FastVector();
    private FastVector iJenrlConstraints = new FastVector();
    private FastVector iRoomConstraints = new FastVector();
    private FastVector iDepartmentSpreadConstraints = new FastVector();
    private FastVector iGroupConstraints = new FastVector();
    private FastVector iIgnoredClasses = new FastVector();
    private boolean iSwitchStudents = false;
    private DataProperties iProperties = null;
    private int iBestTooBigRooms;
    private long iBestUselessSlots;
    private double iBestGlobalTimePreference;
    private long iBestGlobalRoomPreference;
    private long iBestGlobalGroupConstraintPreference;
    private long iBestViolatedStudentConflicts;
    private long iBestHardStudentConflicts;
    static /* synthetic */ Class class$ttsolver$TimetableModel;

    public Vector ignoredClasses() {
        return this.iIgnoredClasses;
    }

    public TimetableModel(DataProperties dataProperties) {
        this.iSwitchStudents = dataProperties.getPropertyBoolean("General.SwitchStudents", true);
        this.iProperties = dataProperties;
        InstructorConstraint.sNoPreferenceLimit = this.iProperties.getPropertyDouble("General.Distance.NoPreferenceLimit", 0.0);
        InstructorConstraint.sDiscouragedLimit = this.iProperties.getPropertyDouble("General.Distance.DiscouragedLimit", 5.0);
        InstructorConstraint.sProhibitedLimit = this.iProperties.getPropertyDouble("General.Distance.ProhibitedLimit", 20.0);
    }

    public DataProperties getProperties() {
        return this.iProperties;
    }

    public void checkJenrl() {
        try {
            System.err.println("Checking jenrl ...");
            Enumeration enumeration = this.variables().elements();
            while (enumeration.hasMoreElements()) {
                Lecture lecture = (Lecture)((Object)enumeration.nextElement());
                System.err.println("Checking " + lecture.getName() + " ...");
                Enumeration enumeration2 = this.variables().elements();
                while (enumeration2.hasMoreElements()) {
                    Object object;
                    Lecture lecture2 = (Lecture)((Object)enumeration2.nextElement());
                    if (lecture.getId() >= lecture2.getId()) continue;
                    int n = 0;
                    FastVector fastVector = new FastVector();
                    Enumeration enumeration3 = lecture.students().elements();
                    while (enumeration3.hasMoreElements()) {
                        object = (String)enumeration3.nextElement();
                        if (!lecture2.students().contains(object)) continue;
                        ++n;
                        fastVector.addElement(object);
                    }
                    boolean bl = false;
                    object = this.iJenrlConstraints.elements();
                    while (object.hasMoreElements()) {
                        JenrlConstraint jenrlConstraint = (JenrlConstraint)((Object)object.nextElement());
                        Lecture lecture3 = (Lecture)jenrlConstraint.first();
                        Lecture lecture4 = (Lecture)jenrlConstraint.second();
                        if ((!lecture3.equals((Object)lecture) || !lecture4.equals((Object)lecture2)) && (!lecture3.equals((Object)lecture2) || !lecture4.equals((Object)lecture))) continue;
                        bl = true;
                        if (jenrlConstraint.getJenrl() == (long)n) continue;
                        sLogger.error((Object)("ERROR: Wrong jenrl between " + lecture.getName() + " and " + lecture2.getName() + " (constraint=" + jenrlConstraint.getJenrl() + " != computed=" + n + ")."));
                        sLogger.error((Object)("       " + lecture.getName() + " has students: " + lecture.students()));
                        sLogger.error((Object)("       " + lecture2.getName() + " has students: " + lecture2.students()));
                        sLogger.error((Object)("       intersection: " + fastVector));
                    }
                    if (bl || n <= 0) continue;
                    System.err.println("ERROR: Missing jenrl between " + lecture.getName() + " and " + lecture2.getName() + " (computed=" + n + ").");
                    sLogger.error((Object)("ERROR: Missing jenrl between " + lecture.getName() + " and " + lecture2.getName() + " (computed=" + n + ")."));
                    sLogger.error((Object)("       " + lecture.getName() + " has students: " + lecture.students()));
                    sLogger.error((Object)("       " + lecture2.getName() + " has students: " + lecture2.students()));
                    sLogger.error((Object)("       intersection: " + fastVector));
                }
            }
            System.err.println("Check done.");
        }
        catch (Exception exception) {
            Debug.error((Throwable)exception);
            exception.printStackTrace();
        }
    }

    public long getGlobalRoomPreference() {
        return this.iGlobalRoomPreference;
    }

    public double getGlobalTimePreference() {
        return this.iGlobalTimePreference;
    }

    public long getViolatedStudentConflicts() {
        return this.iViolatedStudentConflicts.get();
    }

    public long countViolatedStudentConflicts() {
        long l = 0L;
        Enumeration enumeration = this.iJenrlConstraints.elements();
        while (enumeration.hasMoreElements()) {
            JenrlConstraint jenrlConstraint = (JenrlConstraint)((Object)enumeration.nextElement());
            Lecture lecture = (Lecture)jenrlConstraint.first();
            Lecture lecture2 = (Lecture)jenrlConstraint.second();
            if (lecture.getAssignment() == null || lecture2.getAssignment() == null || !JenrlConstraint.isInConflict((Placement)lecture.getAssignment(), (Placement)lecture2.getAssignment())) continue;
            l += jenrlConstraint.getJenrl();
        }
        return l;
    }

    public Counter getViolatedStudentConflictsCounter() {
        return this.iViolatedStudentConflicts;
    }

    public long getGlobalGroupConstraintPreference() {
        return this.iGlobalGroupConstraintPreference.get();
    }

    public Counter getGlobalGroupConstraintPreferenceCounter() {
        return this.iGlobalGroupConstraintPreference;
    }

    public long getBestRoomPreference() {
        return this.iBestRoomPreference;
    }

    public double getBestTimePreference() {
        return this.iBestTimePreference;
    }

    public void setBestRoomPreference(long l) {
        this.iBestRoomPreference = l;
    }

    public void setBestTimePreference(double d) {
        this.iBestTimePreference = d;
    }

    public long getInstructorDistancePreference() {
        long l = 0L;
        Enumeration enumeration = this.iInstructorConstraints.elements();
        while (enumeration.hasMoreElements()) {
            InstructorConstraint instructorConstraint = (InstructorConstraint)((Object)enumeration.nextElement());
            l += (long)instructorConstraint.getPreference();
        }
        return l;
    }

    public long getInstructorWorstDistancePreference() {
        long l = 0L;
        Enumeration enumeration = this.iInstructorConstraints.elements();
        while (enumeration.hasMoreElements()) {
            InstructorConstraint instructorConstraint = (InstructorConstraint)((Object)enumeration.nextElement());
            l += (long)instructorConstraint.getWorstPreference();
        }
        return l;
    }

    public long getUselessSlots() {
        long l = 0L;
        Enumeration enumeration = this.iRoomConstraints.elements();
        while (enumeration.hasMoreElements()) {
            RoomConstraint roomConstraint = (RoomConstraint)((Object)enumeration.nextElement());
            l += (long)roomConstraint.countUselessSlots();
        }
        return l;
    }

    public long getStudentDistanceConflicts() {
        long l = 0L;
        Enumeration enumeration = this.iJenrlConstraints.elements();
        while (enumeration.hasMoreElements()) {
            JenrlConstraint jenrlConstraint = (JenrlConstraint)((Object)enumeration.nextElement());
            if (!jenrlConstraint.isInConflict() || ((Placement)jenrlConstraint.first().getAssignment()).getTimeLocation().hasIntersection(((Placement)jenrlConstraint.second().getAssignment()).getTimeLocation())) continue;
            l += jenrlConstraint.getJenrl();
        }
        return l;
    }

    public long getHardStudentConflicts() {
        if (!this.iSwitchStudents) {
            return 0L;
        }
        long l = 0L;
        Enumeration enumeration = this.iJenrlConstraints.elements();
        while (enumeration.hasMoreElements()) {
            JenrlConstraint jenrlConstraint = (JenrlConstraint)((Object)enumeration.nextElement());
            if (!jenrlConstraint.isInConflict()) continue;
            Lecture lecture = (Lecture)jenrlConstraint.first();
            Lecture lecture2 = (Lecture)jenrlConstraint.second();
            if (lecture.sameLectures() == null || lecture.sameLectures().size() != 1 || lecture2.sameLectures() == null || lecture2.sameLectures().size() != 1) continue;
            l += jenrlConstraint.getJenrl();
        }
        return l;
    }

    public void afterAssigned(long l, Value value) {
        super.afterAssigned(l, value);
        if (value == null) {
            return;
        }
        Placement placement = (Placement)value;
        this.iGlobalRoomPreference += (long)placement.getRoomLocation().getPreference();
        this.iGlobalTimePreference += placement.getTimeLocation().getNormalizedPreference();
    }

    public void afterUnassigned(long l, Value value) {
        super.afterUnassigned(l, value);
        if (value == null) {
            return;
        }
        Placement placement = (Placement)value;
        this.iGlobalRoomPreference -= (long)placement.getRoomLocation().getPreference();
        this.iGlobalTimePreference -= placement.getTimeLocation().getNormalizedPreference();
    }

    public void switchStudents() {
        if (this.iSwitchStudents) {
            long l;
            HashSet hashSet;
            Progress.getInstance().save();
            AbstractCollection abstractCollection = this.variables();
            do {
                Progress.getInstance().setPhase("Shifting students ...", (long)this.variables().size());
                l = this.getViolatedStudentConflictsCounter().get();
                hashSet = new HashSet(abstractCollection.size());
                Iterator iterator = abstractCollection.iterator();
                while (iterator.hasNext()) {
                    Lecture lecture = (Lecture)((Object)iterator.next());
                    Set set = lecture.swapStudents();
                    if (set != null) {
                        hashSet.addAll(set);
                    }
                    Progress.getInstance().incProgress();
                }
            } while (!(abstractCollection = hashSet).isEmpty() && l > this.getViolatedStudentConflictsCounter().get());
            Progress.getInstance().restore();
        }
    }

    public String toString() {
        return "TimetableModel{\n  super=" + super.toString() + "\n  studentConflicts=" + this.iViolatedStudentConflicts.get() + "\n  roomPreferences=" + this.iGlobalRoomPreference + "/" + this.iBestRoomPreference + "\n  timePreferences=" + this.iGlobalTimePreference + "/" + this.iBestTimePreference + "\n  groupConstraintPreferences=" + this.iGlobalGroupConstraintPreference.get() + "\n}";
    }

    public int countTooBigRooms() {
        int n = 0;
        Enumeration enumeration = this.assignedVariables().elements();
        while (enumeration.hasMoreElements()) {
            long l;
            Placement placement;
            long l2;
            Lecture lecture = (Lecture)((Object)enumeration.nextElement());
            if (lecture.getAssignment() == null || (l2 = (placement = (Placement)lecture.getAssignment()).getRoomLocation().getRoomSize()) <= TimetableModel.getMaxCapacity(l = lecture.countStudents())) continue;
            ++n;
        }
        return n;
    }

    public int getDepartmentSpreadPenalty() {
        if (this.iDepartmentSpreadConstraints.isEmpty()) {
            return 0;
        }
        int n = 0;
        Enumeration enumeration = this.iDepartmentSpreadConstraints.elements();
        while (enumeration.hasMoreElements()) {
            DepartmentSpreadConstraint departmentSpreadConstraint = (DepartmentSpreadConstraint)((Object)enumeration.nextElement());
            n += departmentSpreadConstraint.getPenalty();
        }
        return n;
    }

    public Hashtable getInfo() {
        Hashtable hashtable = super.getInfo();
        hashtable.put("Memory usage", Debug.getMem());
        hashtable.put("Room preferences", this.iGlobalRoomPreference + " / " + this.iBestRoomPreference);
        hashtable.put("Time preferences", sDoubleFormat.format(this.iGlobalTimePreference) + " / " + sDoubleFormat.format(this.iBestTimePreference));
        hashtable.put("Group constraint preferences", new Long(this.iGlobalGroupConstraintPreference.get()));
        if (this.getProperties().getPropertyBoolean("General.UseDistanceConstraints", false)) {
            hashtable.put("Distance student conflicts", new Long(this.getStudentDistanceConflicts()));
            hashtable.put("Distance instructor preferences", this.getInstructorDistancePreference() + " / " + this.getInstructorWorstDistancePreference());
        }
        if (this.getProperties().getPropertyBoolean("General.UseDepartmentSpreadConstraints", false)) {
            hashtable.put("Department balancing penalty", new Integer(this.getDepartmentSpreadPenalty()));
        }
        hashtable.put("Student conflicts", new Long(this.getViolatedStudentConflicts()));
        hashtable.put("Too big rooms", new Integer(this.countTooBigRooms()));
        hashtable.put("Hard student conflicts", new Long(this.getHardStudentConflicts()));
        hashtable.put("Useless half-hours", new Long(this.getUselessSlots()));
        return hashtable;
    }

    public int bestTooBigRooms() {
        return this.iBestTooBigRooms;
    }

    public long bestUselessSlots() {
        return this.iBestUselessSlots;
    }

    public double bestGlobalTimePreference() {
        return this.iBestGlobalTimePreference;
    }

    public long bestGlobalRoomPreference() {
        return this.iBestGlobalRoomPreference;
    }

    public long bestGlobalGroupConstraintPreference() {
        return this.iBestGlobalGroupConstraintPreference;
    }

    public long bestViolatedStudentConflicts() {
        return this.iBestViolatedStudentConflicts;
    }

    public long bestHardStudentConflicts() {
        return this.iBestHardStudentConflicts;
    }

    public long bestInstructorDistancePreference() {
        return this.iBestInstructorDistancePreference;
    }

    public int bestDepartmentSpreadPenalty() {
        return this.iBestDepartmentSpreadPenalty;
    }

    public void saveBest() {
        super.saveBest();
        this.iBestTooBigRooms = this.countTooBigRooms();
        this.iBestUselessSlots = this.getUselessSlots();
        this.iBestGlobalTimePreference = this.getGlobalTimePreference();
        this.iBestGlobalRoomPreference = this.getGlobalRoomPreference();
        this.iBestGlobalGroupConstraintPreference = this.getGlobalGroupConstraintPreference();
        this.iBestViolatedStudentConflicts = this.getViolatedStudentConflicts();
        this.iBestHardStudentConflicts = this.getHardStudentConflicts();
        this.iBestInstructorDistancePreference = this.getInstructorDistancePreference();
        this.iBestDepartmentSpreadPenalty = this.getDepartmentSpreadPenalty();
    }

    public void addConstraint(Constraint constraint) {
        super.addConstraint(constraint);
        if (constraint instanceof InstructorConstraint) {
            this.iInstructorConstraints.addElement((Object)constraint);
        } else if (constraint instanceof JenrlConstraint) {
            this.iJenrlConstraints.addElement((Object)constraint);
        } else if (constraint instanceof RoomConstraint) {
            this.iRoomConstraints.addElement((Object)constraint);
        } else if (constraint instanceof DepartmentSpreadConstraint) {
            this.iDepartmentSpreadConstraints.addElement((Object)constraint);
        } else if (constraint instanceof GroupConstraint) {
            this.iGroupConstraints.addElement((Object)constraint);
        }
    }

    public void removeConstraint(Constraint constraint) {
        super.removeConstraint(constraint);
        if (constraint instanceof InstructorConstraint) {
            this.iInstructorConstraints.removeElement((Object)constraint);
        } else if (constraint instanceof JenrlConstraint) {
            this.iJenrlConstraints.removeElement((Object)constraint);
        } else if (constraint instanceof RoomConstraint) {
            this.iRoomConstraints.removeElement((Object)constraint);
        } else if (constraint instanceof DepartmentSpreadConstraint) {
            this.iDepartmentSpreadConstraints.removeElement((Object)constraint);
        } else if (constraint instanceof GroupConstraint) {
            this.iGroupConstraints.removeElement((Object)constraint);
        }
    }

    public Vector getInstructorConstraints() {
        return this.iInstructorConstraints;
    }

    public Vector getGroupConstraints() {
        return this.iGroupConstraints;
    }

    public Vector getJenrlConstraints() {
        return this.iJenrlConstraints;
    }

    public Vector getRoomConstraints() {
        return this.iRoomConstraints;
    }

    public Vector getDepartmentSpreadConstraints() {
        return this.iDepartmentSpreadConstraints;
    }

    public static long getMaxCapacity(long l) {
        return 3L * l / 2L;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

