/*
 * Decompiled with CFR 0.152.
 */
package ttsolver;

import edu.purdue.smas.timetable.data.GroupConstraintTypes;
import edu.purdue.smas.timetable.data.Preferences;
import ifs.extension.ConflictStatistics;
import ifs.extension.Extension;
import ifs.extension.MacPropagation;
import ifs.extension.ViolatedInitials;
import ifs.model.Model;
import ifs.model.Variable;
import ifs.solution.Solution;
import ifs.solution.SolutionListener;
import ifs.solver.Solver;
import ifs.util.DataProperties;
import ifs.util.Progress;
import ifs.util.ProgressListener;
import ifs.util.ProgressWriter;
import ifs.util.ToolBox;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;
import ttsolver.TimetableLoader;
import ttsolver.TimetableModel;
import ttsolver.TimetableSaver;
import ttsolver.constraint.JenrlConstraint;
import ttsolver.constraint.RoomConstraint;
import ttsolver.heuristics.UniversalPerturbationsCounter;
import ttsolver.model.Lecture;
import ttsolver.model.Placement;

public class Test
implements SolutionListener {
    private static SimpleDateFormat sDateFormat = new SimpleDateFormat("dd-MMM-yy_HHmmss", Locale.US);
    private static DecimalFormat sDoubleFormat = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
    private static Logger sLogger = Logger.getLogger((Class)(class$ttsolver$Test == null ? (class$ttsolver$Test = Test.class$("ttsolver.Test")) : class$ttsolver$Test));
    private PrintWriter iCSVFile = null;
    private ConflictStatistics iStat = null;
    private MacPropagation iProp = null;
    private ViolatedInitials iViolatedInitials = null;
    private int iLastNotified = -1;
    static /* synthetic */ Class class$ttsolver$Test;
    static /* synthetic */ Class class$ttsolver$TimetableModel;
    static /* synthetic */ Class class$ifs$solution$Solution;

    public void init(Solver solver) {
        Enumeration enumeration = solver.getExtensions().elements();
        while (enumeration.hasMoreElements()) {
            Extension extension = (Extension)enumeration.nextElement();
            if (extension instanceof ConflictStatistics) {
                this.iStat = (ConflictStatistics)extension;
            }
            if (extension instanceof MacPropagation) {
                this.iProp = (MacPropagation)extension;
            }
            if (!(extension instanceof ViolatedInitials)) continue;
            this.iViolatedInitials = (ViolatedInitials)extension;
        }
        solver.currentSolution().addSolutionListener((SolutionListener)this);
    }

    private String getTimetableLoaderClass(DataProperties dataProperties) {
        String string = dataProperties.getProperty("TimetableLoader");
        if (string != null) {
            return string;
        }
        if (dataProperties.getPropertyInt("General.InputVersion", -1) >= 0) {
            return "ttsolver.TimetableDatabaseLoader";
        }
        return "ttsolver.TimetablePrologLoader";
    }

    private String getTimetableSaverClass(DataProperties dataProperties) {
        String string = dataProperties.getProperty("TimetableSaver");
        if (string != null) {
            return string;
        }
        if (dataProperties.getPropertyInt("General.InputVersion", -1) >= 0) {
            return "ttsolver.TimetableDatabaseSaver";
        }
        return "ttsolver.TimetablePrologSaver";
    }

    public Test(String[] stringArray) {
        try {
            Progress.getInstance().addProgressListener((ProgressListener)new ProgressWriter(System.out));
            DataProperties dataProperties = ToolBox.loadProperties((File)new File(stringArray[0]));
            dataProperties.setProperty("General.Output", dataProperties.getProperty("General.Output", ".") + File.separator + sDateFormat.format(new Date()));
            if (stringArray.length > 1) {
                dataProperties.setProperty("General.Output", stringArray[1] + File.separator + sDateFormat.format(new Date()));
            }
            System.out.println("Output folder: " + dataProperties.getProperty("General.Output"));
            ToolBox.configureLogging((String)dataProperties.getProperty("General.Output"), null);
            Preferences.loadStatic();
            GroupConstraintTypes.loadStatic();
            File file = new File(dataProperties.getProperty("General.Output", "."));
            file.mkdirs();
            Solver solver = new Solver(dataProperties);
            TimetableModel timetableModel = new TimetableModel(dataProperties);
            TimetableLoader timetableLoader = (TimetableLoader)Class.forName(this.getTimetableLoaderClass(dataProperties)).getConstructor(class$ttsolver$TimetableModel == null ? (class$ttsolver$TimetableModel = Test.class$("ttsolver.TimetableModel")) : class$ttsolver$TimetableModel).newInstance(new Object[]{timetableModel});
            PrintWriter printWriter = new PrintWriter(new FileWriter(new File(file, "load.txt")));
            timetableLoader.load(printWriter);
            printWriter.flush();
            printWriter.close();
            this.printSomeStuff(timetableModel);
            solver.setInitalSolution((Model)timetableModel);
            this.init(solver);
            this.iCSVFile = new PrintWriter(new FileWriter(file.toString() + File.separator + "stat.csv"));
            String string = ";";
            this.iCSVFile.println("Assigned" + string + "Assigned[%]" + string + "Time[min]" + string + "Iter" + string + "IterYield[%]" + string + "Speed[it/s]" + string + "AddedPert" + string + "AddedPert[%]" + string + "HardStudentConf" + string + "StudentConf" + string + "DistStudentConf" + string + "TimePref" + string + "RoomPref" + string + "DistInstrPref" + string + "GrConstPref" + string + "UselessSlots" + string + "TooBigRooms" + (this.iProp != null ? string + "GoodVars" + string + "GoodVars[%]" + string + "GoodVals" + string + "GoodVals[%]" : ""));
            this.iCSVFile.flush();
            solver.start();
            solver.getSolverThread().join();
            long l = solver.lastSolution().getIteration();
            double d = solver.lastSolution().getTime();
            if (solver.lastSolution().getBestInfo() != null) {
                Solution solution = solver.lastSolution();
                sLogger.info((Object)("Last solution: " + ToolBox.dict2string((Dictionary)solution.getInfo(), (int)1)));
                solution.restoreBest();
                sLogger.info((Object)("Best solution: " + ToolBox.dict2string((Dictionary)solution.getInfo(), (int)1)));
                ((TimetableModel)solution.getModel()).switchStudents();
                sLogger.info((Object)("Best solution: " + ToolBox.dict2string((Dictionary)solution.getInfo(), (int)1)));
                this.saveOutputCSV(solution, new File(file, "output.csv"));
                TimetableSaver timetableSaver = (TimetableSaver)Class.forName(this.getTimetableSaverClass(dataProperties)).getConstructor(class$ifs$solution$Solution == null ? (class$ifs$solution$Solution = Test.class$("ifs.solution.Solution")) : class$ifs$solution$Solution).newInstance(solution);
                printWriter = new PrintWriter(new FileWriter(new File(file, "save.txt")));
                timetableSaver.save(printWriter);
                printWriter.flush();
                printWriter.close();
            } else {
                sLogger.info((Object)("Last solution:" + ToolBox.dict2string((Dictionary)solver.lastSolution().getInfo(), (int)1)));
            }
            this.iCSVFile.close();
            sLogger.info((Object)("Total number of done iteration steps:" + l));
            sLogger.info((Object)("Achieved speed: " + sDoubleFormat.format((double)l / d) + " iterations/second"));
        }
        catch (Throwable throwable) {
            sLogger.error((Object)"Test failed.", throwable);
        }
    }

    public static void main(String[] stringArray) {
        new Test(stringArray);
    }

    public void bestCleared(Solution solution) {
    }

    public void bestRestored(Solution solution) {
    }

    public void bestSaved(Solution solution) {
        this.notify(solution);
    }

    public void getInfo(Solution solution, Dictionary dictionary) {
    }

    public void solutionUpdated(Solution solution) {
    }

    public void notify(Solution solution) {
        String string = ";";
        if (!solution.getModel().unassignedVariables().isEmpty() && this.iLastNotified == solution.getModel().assignedVariables().size()) {
            return;
        }
        this.iLastNotified = solution.getModel().assignedVariables().size();
        if (this.iCSVFile != null) {
            Object object;
            TimetableModel timetableModel = (TimetableModel)solution.getModel();
            this.iCSVFile.print(timetableModel.variables().size() - timetableModel.unassignedVariables().size());
            this.iCSVFile.print(string);
            this.iCSVFile.print(sDoubleFormat.format(100.0 * (double)(timetableModel.variables().size() - timetableModel.unassignedVariables().size()) / (double)timetableModel.variables().size()));
            this.iCSVFile.print(string);
            this.iCSVFile.print(sDoubleFormat.format(solution.getTime() / 60.0));
            this.iCSVFile.print(string);
            this.iCSVFile.print(solution.getIteration());
            this.iCSVFile.print(string);
            this.iCSVFile.print(sDoubleFormat.format(100.0 * (double)(timetableModel.variables().size() - timetableModel.unassignedVariables().size()) / (double)solution.getIteration()));
            this.iCSVFile.print(string);
            this.iCSVFile.print(sDoubleFormat.format((double)solution.getIteration() / solution.getTime()));
            this.iCSVFile.print(string);
            this.iCSVFile.print(timetableModel.perturbVariables().size());
            this.iCSVFile.print(string);
            this.iCSVFile.print(sDoubleFormat.format(100.0 * (double)timetableModel.perturbVariables().size() / (double)timetableModel.variables().size()));
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            Enumeration enumeration = ((TimetableModel)solution.getModel()).getRoomConstraints().elements();
            while (enumeration.hasMoreElements()) {
                object = (RoomConstraint)((Object)enumeration.nextElement());
                l3 += (long)object.countUselessSlots();
            }
            enumeration = ((TimetableModel)solution.getModel()).getJenrlConstraints().elements();
            while (enumeration.hasMoreElements()) {
                object = (JenrlConstraint)((Object)enumeration.nextElement());
                if (!((JenrlConstraint)((Object)object)).isInConflict()) continue;
                l += ((JenrlConstraint)((Object)object)).getJenrl();
                Lecture lecture = (Lecture)object.first();
                Lecture lecture2 = (Lecture)object.second();
                if (lecture.sameLectures() == null || lecture.sameLectures().size() != 1 || lecture2.sameLectures() == null || lecture2.sameLectures().size() != 1) continue;
                l2 += ((JenrlConstraint)((Object)object)).getJenrl();
            }
            this.iCSVFile.print(string);
            this.iCSVFile.print(l2);
            this.iCSVFile.print(string);
            this.iCSVFile.print(l);
            this.iCSVFile.print(string);
            this.iCSVFile.print(((TimetableModel)solution.getModel()).getStudentDistanceConflicts());
            this.iCSVFile.print(string);
            this.iCSVFile.print(sDoubleFormat.format(((TimetableModel)solution.getModel()).getGlobalTimePreference()));
            this.iCSVFile.print(string);
            this.iCSVFile.print(((TimetableModel)solution.getModel()).getGlobalRoomPreference());
            this.iCSVFile.print(string);
            this.iCSVFile.print(((TimetableModel)solution.getModel()).getInstructorDistancePreference());
            this.iCSVFile.print(string);
            this.iCSVFile.print(((TimetableModel)solution.getModel()).getGlobalGroupConstraintPreference());
            this.iCSVFile.print(string);
            this.iCSVFile.print(l3);
            this.iCSVFile.print(string);
            this.iCSVFile.print(((TimetableModel)solution.getModel()).countTooBigRooms());
            if (this.iProp != null) {
                if (solution.getModel().unassignedVariables().size() > 0) {
                    int n = 0;
                    long l4 = 0L;
                    long l5 = 0L;
                    Enumeration enumeration2 = solution.getModel().unassignedVariables().elements();
                    while (enumeration2.hasMoreElements()) {
                        Lecture lecture = (Lecture)((Object)enumeration2.nextElement());
                        l4 += (long)this.iProp.goodValues((Variable)lecture).size();
                        l5 += (long)lecture.values().size();
                        if (this.iProp.goodValues((Variable)lecture).isEmpty()) continue;
                        ++n;
                    }
                    this.iCSVFile.print(string);
                    this.iCSVFile.print(n);
                    this.iCSVFile.print(string);
                    this.iCSVFile.print(sDoubleFormat.format(100.0 * (double)n / (double)solution.getModel().unassignedVariables().size()));
                    this.iCSVFile.print(string);
                    this.iCSVFile.print(l4);
                    this.iCSVFile.print(string);
                    this.iCSVFile.print(sDoubleFormat.format(100.0 * (double)l4 / (double)l5));
                } else {
                    this.iCSVFile.print(string);
                    this.iCSVFile.print(string);
                    this.iCSVFile.print(string);
                    this.iCSVFile.print(string);
                }
            }
            this.iCSVFile.println();
            this.iCSVFile.flush();
        }
    }

    private void printSomeStuff(TimetableModel timetableModel) {
        Object object;
        long l = 0L;
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n7 = 0;
        Enumeration enumeration = timetableModel.variables().elements();
        while (enumeration.hasMoreElements()) {
            Object object2;
            object = (Lecture)((Object)enumeration.nextElement());
            double d3 = Double.MIN_VALUE;
            double d4 = Double.MAX_VALUE;
            int n8 = Integer.MIN_VALUE;
            int n9 = Integer.MAX_VALUE;
            int n10 = Integer.MIN_VALUE;
            int n11 = Integer.MAX_VALUE;
            l2 += (long)(((Lecture)((Object)object)).allStudents() == null ? 0 : ((Lecture)((Object)object)).allStudents().size());
            l += (long)((Lecture)((Object)object)).values().size();
            Object object3 = ((Lecture)((Object)object)).values().elements();
            while (object3.hasMoreElements()) {
                object2 = (Placement)((Object)object3.nextElement());
                d3 = Math.max(d3, ((Placement)((Object)object2)).getTimeLocation().getNormalizedPreference());
                d4 = Math.min(d4, ((Placement)((Object)object2)).getTimeLocation().getNormalizedPreference());
                n8 = Math.max(n8, ((Placement)((Object)object2)).getTimeLocation().getPreference());
                n9 = Math.min(n8, ((Placement)((Object)object2)).getTimeLocation().getPreference());
                n10 = Math.max(n10, ((Placement)((Object)object2)).getRoomLocation().getPreference());
                n11 = Math.min(n11, ((Placement)((Object)object2)).getRoomLocation().getPreference());
            }
            if (!((Lecture)((Object)object)).values().isEmpty()) {
                object3 = (Placement)((Object)((Lecture)((Object)object)).values().firstElement());
                n6 += ((Placement)((Object)object3)).getTimeLocation().getNrMeetings();
                n5 += ((Placement)((Object)object3)).getTimeLocation().getNrMeetings() * ((Placement)((Object)object3)).getTimeLocation().getNrHalfHoursPerMeeting();
                d += d3;
                d2 += d4;
                n += n8;
                n2 += n9;
                n3 += n10;
                n4 += n11;
            }
            if (((Lecture)((Object)object)).values().size() != 1) continue;
            ++n7;
            object3 = (Placement)((Object)((Lecture)((Object)object)).values().firstElement());
            object2 = ((Lecture)((Object)object)).jenrlConstraints().elements();
            while (object2.hasMoreElements()) {
                Placement placement;
                JenrlConstraint jenrlConstraint = (JenrlConstraint)((Object)object2.nextElement());
                Lecture lecture = (Lecture)jenrlConstraint.another((Variable)object);
                if (lecture.values().size() != 1 || !JenrlConstraint.isInConflict((Placement)((Object)object3), placement = (Placement)((Object)lecture.values().firstElement()))) continue;
                l3 += jenrlConstraint.getJenrl();
            }
        }
        enumeration = timetableModel.getJenrlConstraints().elements();
        while (enumeration.hasMoreElements()) {
            object = (JenrlConstraint)((Object)enumeration.nextElement());
            l4 += ((JenrlConstraint)((Object)object)).getJenrl();
        }
        sLogger.debug((Object)("Total number of variables: " + timetableModel.variables().size()));
        sLogger.debug((Object)("Total number of variables with only one value: " + n7));
        sLogger.debug((Object)("Total number of values: " + l));
        sLogger.debug((Object)("Total maximum normalized time preference: " + sDoubleFormat.format(d)));
        sLogger.debug((Object)("Total minimum normalized time preference: " + sDoubleFormat.format(d2)));
        sLogger.debug((Object)("Total maximum time preferences: " + n));
        sLogger.debug((Object)("Total minimum time preferences: " + n2));
        sLogger.debug((Object)("Total maximum room preferences: " + n3));
        sLogger.debug((Object)("Total minimum room preferences: " + n4));
        sLogger.debug((Object)("Total amount of student enrollments: " + l2));
        sLogger.debug((Object)("Total amount of joined enrollments: " + l4));
        sLogger.debug((Object)("Total amount of inevitable student conflicts: " + l3));
        sLogger.debug((Object)("Total number of meetings: " + n6));
        sLogger.debug((Object)("Total number of half-hours: " + n5));
        sLogger.debug((Object)("Total number of rooms: " + timetableModel.getRoomConstraints().size()));
    }

    private void saveOutputCSV(Solution solution, File file) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            TimetableModel timetableModel = (TimetableModel)solution.getModel();
            printWriter.println("Assigned variables;" + timetableModel.assignedVariables().size());
            if (timetableModel.getProperties().getPropertyBoolean("General.MPP", false)) {
                printWriter.println("Add. perturbancies;" + solution.getPerturbationsCounter().getPerturbationPenalty(solution));
            }
            printWriter.println("Time [sec];" + sDoubleFormat.format(solution.getBestTime()));
            printWriter.println("Hard student conflicts;" + timetableModel.getHardStudentConflicts());
            if (timetableModel.getProperties().getPropertyBoolean("General.UseDistanceConstraints", true)) {
                printWriter.println("Distance student conf.;" + timetableModel.getStudentDistanceConflicts());
            }
            printWriter.println("Student conflicts;" + timetableModel.getViolatedStudentConflicts());
            printWriter.println("Time preferences;" + sDoubleFormat.format(timetableModel.getGlobalTimePreference()));
            printWriter.println("Room preferences;" + timetableModel.getGlobalRoomPreference());
            printWriter.println("Useless half-hours;" + timetableModel.getUselessSlots());
            printWriter.println("Too big room;" + timetableModel.countTooBigRooms());
            if (timetableModel.getProperties().getPropertyBoolean("General.UseDistanceConstraints", true)) {
                printWriter.println("Distance instructor pref.;" + timetableModel.getInstructorDistancePreference());
            }
            if (timetableModel.getProperties().getPropertyBoolean("General.UseDepartmentSpreadConstraints", true)) {
                printWriter.println("Dept. spread penalty;" + sDoubleFormat.format(timetableModel.getDepartmentSpreadPenalty()));
            }
            if (timetableModel.getProperties().getPropertyBoolean("General.MPP", false)) {
                Hashtable hashtable = ((UniversalPerturbationsCounter)solution.getPerturbationsCounter()).getCompactInfo(solution, false, false);
                Enumeration enumeration = ToolBox.sortEnumeration(hashtable.keys());
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    printWriter.println(string + ";" + hashtable.get(string));
                }
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            sLogger.error((Object)iOException.getMessage(), (Throwable)iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

