/*
 * MessageDlg.java
 *
 * Created on 25. prosinec 2000, 16:03
 */

package timetable.util;

/**
 *
 * @author  Administrator
 * @version 
 */
public class MessageDlg extends javax.swing.JDialog {
    public static int OK = 1;
    public static int CANCEL = 2;
    public static int YES = 4;
    public static int NO = 8;
    public static int OKCANCEL = OK+CANCEL;
    public static int YESNO = YES+NO;
    
    protected int returnStatus = 0;

    /** Creates new form MessageDlg */
    public MessageDlg(java.awt.Frame parent,String title, String message, int buttons) {
        super (parent, true);
        initComponents ();
        pack ();
        if ((buttons&OK)==0) buttonPanel.remove(okButton);
        if ((buttons&CANCEL)==0) buttonPanel.remove(cancelButton);
        if ((buttons&YES)==0) buttonPanel.remove(yesButton);
        if ((buttons&NO)==0) buttonPanel.remove(noButton);
        msgArea.setText(message);
        setTitle(title);
        this.setSize(350,150);
        this.setLocation((this.getToolkit().getScreenSize().width-this.getSize().width)/2,(this.getToolkit().getScreenSize().height-this.getSize().height)/2);
    }
    
    public MessageDlg(String title, String message, int buttons) {
        this(new javax.swing.JFrame (),title,message,buttons);
    }
    
    public int getReturnStatus() { return returnStatus; }
    
    

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        dummyLabel1 = new javax.swing.JLabel();
        dummyLabel3 = new javax.swing.JLabel();
        dummyLabel2 = new javax.swing.JLabel();
        buttonPanel = new javax.swing.JPanel();
        yesButton = new javax.swing.JButton();
        noButton = new javax.swing.JButton();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        msgArea = new javax.swing.JTextArea();
        setName("messageDlg");
        setModal(true);
        setTitle(Loc.get("timetable.util.messagedlg.title"));
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        }
        );
        
        dummyLabel1.setText("     ");
        
        getContentPane().add(dummyLabel1, java.awt.BorderLayout.NORTH);
        
        
        dummyLabel3.setText("          ");
        
        getContentPane().add(dummyLabel3, java.awt.BorderLayout.EAST);
        
        
        dummyLabel2.setText("          ");
        
        getContentPane().add(dummyLabel2, java.awt.BorderLayout.WEST);
        
        
        
        yesButton.setText(Loc.get("timetable.button.yes"));
          yesButton.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  yesButtonActionPerformed(evt);
              }
          }
          );
          buttonPanel.add(yesButton);
          
          
        noButton.setText(Loc.get("timetable.button.no"));
          noButton.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  noButtonActionPerformed(evt);
              }
          }
          );
          buttonPanel.add(noButton);
          
          
        okButton.setText(Loc.get("timetable.button.ok"));
          okButton.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  okButtonActionPerformed(evt);
              }
          }
          );
          buttonPanel.add(okButton);
          
          
        cancelButton.setText(Loc.get("timetable.button.cancel"));
          cancelButton.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  cancelButtonActionPerformed(evt);
              }
          }
          );
          buttonPanel.add(cancelButton);
          
          
        getContentPane().add(buttonPanel, java.awt.BorderLayout.SOUTH);
        
        
        msgArea.setWrapStyleWord(true);
        msgArea.setLineWrap(true);
        msgArea.setEditable(false);
        msgArea.setRows(3);
        msgArea.setBackground(new java.awt.Color (205, 205, 205));
        
        getContentPane().add(msgArea, java.awt.BorderLayout.CENTER);
        
    }//GEN-END:initComponents

  private void noButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_noButtonActionPerformed
      doClose(NO);
  }//GEN-LAST:event_noButtonActionPerformed

  private void yesButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_yesButtonActionPerformed
      doClose(YES);
  }//GEN-LAST:event_yesButtonActionPerformed

  private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
      doClose(CANCEL);
  }//GEN-LAST:event_cancelButtonActionPerformed

  private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
      doClose(OK);
  }//GEN-LAST:event_okButtonActionPerformed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible (false);
        dispose ();
    }//GEN-LAST:event_closeDialog

    private void doClose(int code) {
        returnStatus=code;
        setVisible(false);
        dispose();
    }
    
    /**
    * @param args the command line arguments
    */
    public static void main (String args[]) {
        new MessageDlg (new javax.swing.JFrame (), "Poznmka", "Ahoj,\njak se m?\nJ se mm dobe. J se mm dobe. J se mm dobe. J se mm dobe. J se mm dobe. J se mm dobe. J se mm dobe. J se mm dobe.", YES+NO).show ();
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel dummyLabel1;
    private javax.swing.JLabel dummyLabel3;
    private javax.swing.JLabel dummyLabel2;
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JButton yesButton;
    private javax.swing.JButton noButton;
    private javax.swing.JButton okButton;
    private javax.swing.JButton cancelButton;
    private javax.swing.JTextArea msgArea;
    // End of variables declaration//GEN-END:variables

}
