package timetable.util;
/*
 * Config.java
 *
 * Created on 12. jen 2000, 11:00
 * Documented 18. 7. 2001
 */

import java.util.Hashtable;
import java.io.*;

/** Tda spravujc konfiguraci rozvrhovae. Pi vytven novho rozvrhu je tato konfigurace petena z konfiguranho souboru. Jde o tabulku kl = hodnota.
 *
 * @author Tom Mller
 * @version 1.0
 */
public class Config extends java.lang.Object implements java.io.Serializable {
    /** poet slot - kl v konfiguranm souboru */
    public static String NR_SLOTS = "POCET_SLOTU";
    /** poet dn - kl v konfiguranm souboru*/
    public static String NR_DAYS = "POCET_DNU";
    /** maximln poet iterac - kl v konfiguranm souboru*/
    public static String NR_TRIES = "POCET_ITERACI";
    /** Zkratky jmen dn v tdnu */
    public static String DAY_OF_WEEK [] = new String[] {"Po","Ut","St","Ct","Pa","So","Ne"};

    /** zde je uloena konfigurace v pamti */
    public Hashtable configuration = new Hashtable();
    /** debug soubor (logovn informac v prbhu een) - default */
    public static String LOG_FILE = "debug.log";
    /** zpis debug souboru */
    protected java.io.OutputStreamWriter osw = null;
    /** zpis debug souboru */
    protected java.io.FileOutputStream fos = null;
    /** konfiguran soubor */
    protected String file = null;
    /** globln preference */
    private int [] globalPref = null;
    
    /** Konstruktor. Konfiguran soubor bude "konfig.cfg" */
    public Config() throws TimetableException {
        this("konfig.cfg");
    }
    
    /** Konstruktor. 
     * @param konfiguran soubor
     */
    public Config(String file) throws TimetableException {
        FileInputStream fis = null;
        this.file=file;
        try {
            fis = new FileInputStream(file);
            BufferedReader br = new BufferedReader( new InputStreamReader(fis));
            int line_no=0;
            String line = null;
            while ((line = br.readLine())!=null) 
                if (line.indexOf("#")!=0 && line.length()>0) {
                    line_no++;
                    if (line.indexOf("=")<0) throw new TimetableException("Error in configuration file \""+file+"\" on line "+line_no+"."); 
                    else{
                        configuration.put(line.substring(0,line.indexOf("=")),line.substring(line.indexOf("=")+1));
                    };
                };
            fis.close();
          if (existKey("DEBUG_LOG")) {
            fos = new java.io.FileOutputStream(get("DEBUG_LOG"));
            osw = new java.io.OutputStreamWriter(fos);
          }
          globalPref=new int[getInt(NR_SLOTS)];
          for (int i=0;i<globalPref.length;i++) globalPref[i]=0;
        } catch (Exception e) {
            throw new TimetableException(e.getMessage());
        };
        Loc.addLocalization(this.get("LOC_SOLVER"));
        DAY_OF_WEEK[0]=Loc.get("timetable.config.dayOfWeek.mon");
        DAY_OF_WEEK[1]=Loc.get("timetable.config.dayOfWeek.tue");
        DAY_OF_WEEK[2]=Loc.get("timetable.config.dayOfWeek.wed");
        DAY_OF_WEEK[3]=Loc.get("timetable.config.dayOfWeek.thu");
        DAY_OF_WEEK[4]=Loc.get("timetable.config.dayOfWeek.fri");
        DAY_OF_WEEK[5]=Loc.get("timetable.config.dayOfWeek.sat");
        DAY_OF_WEEK[6]=Loc.get("timetable.config.dayOfWeek.san");
    }
    
    /** Uloen konfiguranho souboru */
    public void save() throws TimetableException {
        FileOutputStream sfos = null;
        try {
            sfos = new FileOutputStream(file);
            OutputStreamWriter sosw = new OutputStreamWriter(sfos);
            for (java.util.Enumeration e=configuration.keys();e.hasMoreElements();) {
                String key = (String)e.nextElement();
                sosw.write(key+"="+get(key)+"\n");
            }
            sosw.flush();sosw.close();
            sfos.close();
        } catch (Exception e) {
            throw new TimetableException(e.getMessage());
        }
    }
      
    /** Zskn zapisovae do debug souboru
     */
    public java.io.OutputStreamWriter getLogWriter() {
        return osw;
    }
    
    /** Zskn globlnch preferenc
     */
    public int [] getGlobalPref() {
        return globalPref;
    }
    
    /** Zpis logovac hlky do debug souboru. Zpis se provede pouze pokud je logovn povoleno (v konfiguraci je DEBUG=1).
     * @param s hlka
     */
    public void log(String s) throws TimetableException {
        try {
            if (existKey("DEBUG_LOG")) osw.write(s+"\n");
            if (getInt("DEBUG")>0) System.out.println(s);
        } catch (Exception e) {
            throw new TimetableException(e.getMessage());
        }
    }
    
    /** Zave debug vstup
     */
    public void closeLog() throws TimetableException {
        try {
            if (existKey("DEBUG_LOG")) {osw.flush(); osw.close(); fos.close();};
        } catch (Exception e) {
            throw new TimetableException(e.getMessage());
        }
    }
    
    /** Vrt hodnotu danho kle (pokud dan kl v konfiguraci neexistuje, nastane vyjmka TimetableException)
     * @param key kl
     * @return hodnota jako etzec
     */
    public String get(String key) throws TimetableException {
        String val=(String)configuration.get(key);
        if (val==null) throw new TimetableException("Key \""+key+"\" not found.");
        return val;
    }
    
    /** Existuje v konfiguraci kl ?
     * @return true, pokud ano
     */
    public boolean existKey(String key) throws TimetableException {
        return (configuration.get(key)!=null);
    }
    
    /** Vrt hodnotu danho kle (pokud dan kl v konfiguraci neexistuje, nastane vyjmka TimetableException)
     * @param key kl
     * @return hodnota jako int
     */
    public int getInt(String key) throws TimetableException {
        if (!existKey(key)) throw new TimetableException("Key \""+key+"\" not found.");
        return Integer.parseInt(get(key));
    }

    /** Nastav dan kl na zvolenou hodnotu
     * @param key kl
     * @param val hodnota
     */
    public void set(String key, int val) throws TimetableException {
        set(key,String.valueOf(val));
    }
    
    /** Nastav dan kl na zvolenou hodnotu
     * @param key kl
     * @param val hodnota
     */
    public void set(String key, String val) throws TimetableException {
        configuration.put(key,val);
    }

    /** Vrt konfiguraci jako etzec - kad dek je kl=hodnota.
     * @return etzec
     */
    public String toString() {
        StringBuffer s = new StringBuffer();
        boolean first=true;
        for (java.util.Enumeration e=configuration.keys();e.hasMoreElements();) {
            String key = (String)e.nextElement();
            if (!first) s.append('\n');
            s.append(key+"="+configuration.get(key));
            first=false;
        };
        return s.toString();
    }
    
    /** Vrt den v tdnu pro dan slot
     * @return zkratka dnu
     */
    public String dayOfWeek(int slot) throws TimetableException {
        return DAY_OF_WEEK[slot/(getInt(NR_SLOTS)/getInt(NR_DAYS))];
    }

    /** Zpis konfigurace do streamu */
   private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
       out.writeObject(configuration);
       out.writeObject(globalPref);
   }

   /** Naten konfigurace ze streamu */
   private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException, TimetableException {
       configuration = (Hashtable) in.readObject();
       globalPref = (int[]) in.readObject();
          if (existKey("DEBUG_LOG")) {
            fos = new java.io.FileOutputStream(get("DEBUG_LOG"));
            osw = new java.io.OutputStreamWriter(fos);
          }
   }

}
