/*
 * Test.java
 *
 * Created on 12. jen 2000, 14:44
 */

package timetable.test;


import timetable.data.*;
import timetable.util.*;
import timetable.solver.*;
/**
 *
 * @author  Administrator
 * @version 
 */
public class Test extends java.lang.Object {

    /** CreateSos new Test */
    public Test() {
    }
    
    public static void main(String[] args) {
      try {
        Config k = new Config();
        long dP=0, dG=0, dVH=0, dVP=0, dT=0;

        SmartGenerator g = new SmartGenerator(k);
        Problem pc = g.generujCele();
      
        k.set("POCET_ITERACI",2000);
        Solver s = new Solver(k,pc);
        s.setValueSelection(new timetable.solver.strategy.value.MinValueSelection(k,new timetable.solver.strategy.Tabu(k),
                            new timetable.solver.strategy.price.SingleActivityEvaluation(k)));
        s.setVariableSelection(new timetable.solver.strategy.variable.WorstFirstVariableSelection(k));
        s.solve();
        System.out.println("Podarilo se naplanovat "+s.maxScheduledActivities+" aktivit z "+pc.activities.size()+".");
        System.out.println("Pouzito "+s.nrIters+" iteraci.");
        int maxc=0;
        Activity ac = null;
        for (int i=0;i<pc.activities.size();i++) 
           if (pc.activities.get(i).nrRemoves>maxc || ac==null) {
               maxc = pc.activities.get(i).nrRemoves;
               ac = pc.activities.get(i);
            }
        System.out.println("Nejvice vadi aktivita "+ac.name+" , vyhozena byla "+ac.nrRemoves+"x");
        System.out.println("Doba planovani "+s.solveTime+" ms.");
        System.out.println("Doba generovani "+s.generateTime+" ms.");
        System.out.println("Doba vyberu promenne "+s.selectVariableTime+" ms.");
        System.out.println("Doba vyberu hodnoty "+s.selectValueTime+" ms.");
//        System.out.println("  z toho tabu "+pc.tabu.dobaTabu+" ms.");
        pc.print("rozvrhCU.txt",g.ucebny,0,3);
        pc.print("rozvrhCV.txt",g.vyucujici,1,3);
        pc.print("rozvrhCT.txt",g.tridy,2,3);
        k.set("POCET_ITERACI",1000);
        pc.reset();
        Problem p = g.generuj();
        s = new Solver(k,p);
        s.setValueSelection(new timetable.solver.strategy.value.MinValueSelection(k,new timetable.solver.strategy.Tabu(k),
                            new timetable.solver.strategy.price.SingleActivityEvaluation(k)));
        s.setVariableSelection(new timetable.solver.strategy.variable.WorstFirstVariableSelection(k));
        System.out.println("");
        System.out.println("123456789*123456789*123456789*123456789*123456789*");
        for (int akt=1;akt<=k.getInt("POCET_ITERACI");akt++) {
            if (akt%10==1) System.out.print(".");
            s.solve();
            dP+=s.solveTime;
            dG+=s.generateTime;
            dVP+=s.selectVariableTime;
            dVH+=s.selectValueTime;
//          dT+=p.tabu.dobaTabu;
//          if (p.pokus!=1 || akt==k.pocetPokusu()) System.out.println("***************** "+akt+". pridani ****************");
            if (s.nrIters==k.getInt("POCET_ITERACI")) { 
                System.out.println(" "+akt+". pridani se nezdarilo !");
                int max=0;
                Activity a = null;
                for (int i=0;i<p.activities.size();i++) 
                    if (p.activities.get(i).nrRemoves>max || a==null) {
                        max = p.activities.get(i).nrRemoves;
                        a = p.activities.get(i);
                    }
                System.out.println("Nejvice vadi aktivita "+a.name+" , vyhozena byla "+a.nrRemoves+"x");
                p.print("rozvrhU.txt",g.ucebny,0,3);
                p.print("rozvrhV.txt",g.vyucujici,1,3);
                p.print("rozvrhT.txt",g.tridy,2,3);
                g.odeber(a);
//                p.obnovPredchozi();
//                p.restoreLastState();
            } else p.saveState();
            int n=0;
            for (int i=0;i<p.activities.size();i++) 
                if(p.activities.get(i).isScheduled()) n++;
            if (s.nrIters==k.getInt("POCET_ITERACI")) 
                System.out.println("Podarilo se naplanovat "+s.maxScheduledActivities+" aktivit z "+p.activities.size()+".");
            if (s.nrIters==0 || akt==k.getInt("POCET_ITERACI")) {
            System.out.println("");
            System.out.println("");
            System.out.println("Naplanovano "+n+" aktivit ("+akt+" pridani) .");
            System.out.println("Nezdarilo se naplanovat "+(akt-n-1)+"x.");
            System.out.println("Doba planovani "+dP+" ms.");
            System.out.println("Doba generovani "+dG+" ms.");
            System.out.println("Doba vyberu promenne "+dVP+" ms.");
            System.out.println("Doba vyberu hodnoty "+dVH+" ms.");
//            System.out.println("  z toho tabu "+dT+" ms.");
            };
            if (s.nrIters==0) akt=k.getInt("POCET_ITERACI");
            if (akt==k.getInt("POCET_ITERACI")) {
                p.print("rozvrhU.txt",g.ucebny,0,3);
                p.print("rozvrhV.txt",g.vyucujici,1,3);
                p.print("rozvrhT.txt",g.tridy,2,3);
            };
            p  = g.generuj();
        }
        k.closeLog();
      } catch (Exception e) {
          System.err.println("Error: "+e);
          e.printStackTrace();
      }
  } 

}
