/*
 * Test.java
 *
 * Created on 12. jen 2000, 14:44
 */

package timetable.test;


import timetable.solver.*;
import timetable.data.*;
import timetable.util.*;
/**
 *
 * @author  Administrator
 * @version 
 */
public class SimpleTest extends java.lang.Object {

    /** Creates new Test */
    public SimpleTest() {
    }
    
    public static void main(String[] args) {
      try{
        Config k = new Config();
        k.set("POCET_SLOTU",5);
        long dP=0, dG=0, dVH=0, dVP=0, dT=0, dZA=0;
        Problem p = new Problem(k);
        Resource[] tridy = { new Resource(k,"S1"), new Resource(k,"S2"), new Resource(k,"S3"),
                          new Resource(k,"K1"), new Resource(k,"K2"), new Resource(k,"K3")};
        ResourceGroup tridyS = new ResourceGroup( new Resource[] {tridy[0],tridy[1],tridy[2]});
        ResourceGroup tridyK = new ResourceGroup( new Resource[] {tridy[3],tridy[4],tridy[5]});
        Resource[] ucitele = { new Resource(k,"A"), new Resource(k,"B"), new Resource(k,"C")};
        Resource[] kategorie = { new Resource(k,"1.A"), new Resource(k,"2.A"), new Resource(k,"3.A")};
        p.activities.add(new Activity(k,"pA",2));
        p.activities.add(new Activity(k,"pB",3));
        p.activities.add(new Activity(k,"pC",2));
        p.activities.add(new Activity(k,"pE",2));
        p.activities.add(new Activity(k,"pF",4));
        p.activities.add(new Activity(k,"pG",1));
        p.activities.get(0).resources.add(ucitele[0]);
        p.activities.get(1).resources.add(ucitele[0]);
        p.activities.get(2).resources.add(ucitele[1]);
        p.activities.get(3).resources.add(ucitele[1]);
        p.activities.get(4).resources.add(ucitele[2]);
        p.activities.get(5).resources.add(ucitele[2]);
        p.activities.get(0).resources.add(tridyS);
        p.activities.get(1).resources.add(tridyS);
        p.activities.get(2).resources.add(tridyS);
        p.activities.get(3).resources.add(tridyS);
        p.activities.get(4).resources.add(tridyS);
        p.activities.get(5).resources.add(tridyS);
        p.activities.get(0).resources.add(kategorie[0]);
        p.activities.get(1).resources.add(kategorie[1]);
        p.activities.get(2).resources.add(kategorie[1]);
        p.activities.get(3).resources.add(kategorie[0]);
        p.activities.get(4).resources.add(kategorie[2]);
        p.activities.get(5).resources.add(kategorie[0]);
        
        ucitele[1].getPreference().set(4,2);
        tridy[1].getPreference().set(4,2);
        tridy[0].getPreference().set(4,1);
        p.activities.get(4).getPreference().set(4,1);
        kategorie[2].getPreference().set(0,2);
        p.dependences.add(new TimeActivityDependence(p.activities.get(1),TimeActivityDependence.CLOSELY_AFTER,p.activities.get(0)));
        p.dependences.add(new TimeActivityDependence(p.activities.get(5),TimeActivityDependence.CLOSELY_AFTER,p.activities.get(4)));
        
        ResourceGroup [] sz = {new ResourceGroup(ucitele),new ResourceGroup(tridy),new ResourceGroup(kategorie)};
        p.resources = sz;
        Solver s = new Solver(k,p);
        s.setValueSelection(new timetable.solver.strategy.value.MinValueSelection(k,new timetable.solver.strategy.Tabu(k),
                            new timetable.solver.strategy.price.SingleActivityEvaluation(k)));
        s.setVariableSelection(new timetable.solver.strategy.variable.WorstFirstVariableSelection(k));
        s.solve();
        dP=s.solveTime;
        dG=s.generateTime;
        dVP=s.selectVariableTime;
        dVH=s.selectValueTime;
        dT=0;//s.tabu.tabuTime;
        int n=0;
        for (int i=0;i<p.activities.size();i++) {
              System.out.print("Activity: \""+p.activities.get(i).name+"\", zacatek v "+p.activities.get(i).start+", delka "+p.activities.get(i).length+", vyhozeno "+p.activities.get(i).nrRemoves+"x \n  resources:");
              if (p.activities.get(i).isScheduled()) {
                  for (int j=0;j<p.activities.get(i).selectedResources.size();j++) 
                     System.out.print(p.activities.get(i).selectedResources.getResource(j).name+", ");
                  n++;
              };
              System.out.println("");
        }
        System.out.println("Podarilo se naplanovat "+n+" aktivit z "+p.activities.size()+".");
        System.out.println("Doba planovani "+dP+" ms.");
        System.out.println("Doba generovani "+dG+" ms.");
        System.out.println("Doba vyberu promenne "+dVP+" ms.");
        System.out.println("Doba vyberu hodnoty "+dVH+" ms.");
        System.out.println("  z toho tabu "+dT+" ms.");
        p.print("SrozvrhV.txt",p.resources[0],0,3);
        p.print("SrozvrhU.txt",p.resources[1],1,3);
        p.print("SrozvrhT.txt",p.resources[2],2,3);
        p.save("SimpleProblem.shd");
        p = Problem.load("SimpleProblem.shd");
        k.closeLog();
      } catch( Exception e) {
          System.err.println("Nastala chyba: "+e.getMessage());
          e.printStackTrace();
      }
    }

}
