/*
 * StrategieVyberu.java
 *
 * Created on 12. jen 2000, 14:01
 * Documented 18. 7. 2001
 */

package timetable.solver.strategy.variable;

import timetable.data.*;
import timetable.util.*;
/** Implicitn heuristika vbru nenaplnovan aktivity. Snaha je vybrat nejhe naplnovatelnou aktivitu.
 *
 * @author  Tom Mller
 * @version 1.0
 */
public class WorstFirstVariableSelection implements VariableSelectionInterface {
    /** konfigurace */
    Config config = null;

    /** Konstruktor.
     * @param config konfigurace
     */
    public WorstFirstVariableSelection(Config config) {
        this.config=config;
    }
    
    /** Ohodnocen nenaplnovan aktivity - hled se aktivita s minimln hodnotou.
     * @param a nenaplnovan aktivita
     * @param dependences mnoina zvislost mezi aktivitami
     * @return ohodnocen aktivity
     */
    private int value( Activity a, ActivityDependenceGroup dependences ) throws TimetableException {
        int sum = 0;
        sum += config.getInt("VYBER_PROM_VAHA_MISTA_BEZ_KONFLIKTU") * a.countScheduleWithoutCollision(dependences);
        sum += config.getInt("VYBER_PROM_VAHA_MISTA") * a.countSchedule(dependences);
        sum -= config.getInt("VYBER_PROM_VAHA_VYHOZENI") * a.nrRemoves;
        sum -= config.getInt("VYBER_PROM_VAHA_ZAVISLOSTI") * dependences.countDependences(a);
        return sum;
    }

    /** Vbr nenaplnovan aktivity.
     * @param notScheduledActivities mnoina nenaplnovanch aktivit
     * @param dependences mnoina zvislost mezi aktivitami
     * @return vybran aktivita
     */
    public Activity select(ActivityGroup notScheduledActivities,ActivityDependenceGroup dependences) throws TimetableException {
        if (config.getInt("VYBER_PROM_NAHODNE")==1) return notScheduledActivities.get(timetable.util.Math.random(notScheduledActivities.size()));
        boolean all = (config.getInt("VYBER_PROM_VSECHNY")==1);
        if (notScheduledActivities==null || notScheduledActivities.size()==0) return null;
        if (notScheduledActivities.size()==1) return notScheduledActivities.get(0);
        Activity selected=notScheduledActivities.get(timetable.util.Math.random(notScheduledActivities.size()));
        int min=value(selected,dependences);
        for (int i=0;i<notScheduledActivities.size();i++) {
            if (all || timetable.util.Math.random(5)==0) {
                int adept=value(notScheduledActivities.get(i),dependences);
                if (min>adept || (min==adept && timetable.util.Math.random(3)==0)) {
                    min=adept;
                    selected=notScheduledActivities.get(i);
                }
            }
        }
        return selected;
    }

}
