/*
 * ValueSelectionInterface.java
 *
 * Created on 17. prosinec 2000, 15:30
 * Documented 18. 7. 2001
 */

package timetable.solver.strategy.value;

import timetable.data.*;
import timetable.util.*;
/** Rozhran pro heuristiku vbru umstn.
 * Rozvrhovac program dr v pamti jednu instanci tto tdy, v kad iteraci nejdve provede reset heuristiky s vybranou aktivitou. Dle pro kad mon umstn zavol metodu addValue. Nsledn zavol metodu select a pomoc metod selectedXXX si pete vybran umstn.
 *
 * @author Tom Mller
 * @version 1.0
 */
public interface ValueSelectionInterface {
  
    /** Nastaven aktivity, pro kterou se bude umstn hledat. Reset heuristiky.
     * @param activity vybran aktivita
     */
    public void reset(Activity activity);
    
    /** Pidn monho umstn do vbru. 
     * @param slot poten slot 
     * @param selectedResources vybran zdroje
     * @param dependences mnoina vech zvislost
     * @param conflictActivities mnoina aktivit, kter jsou s danm umstnm v konfliktu - budou se muset z rozvrhu odebrat v ppad zvolen tohoto umstn
     */
    public void addValue(int slot, ActivityResources selectedResources, ActivityDependenceGroup dependences, ActivityGroup conflictActivities) throws TimetableException ;
    
    /** Metoda provede vbr umstn. */
    public void select() throws TimetableException ;
    
    /** Vrac vybran umstn.
     * @return poten slot (null, pokud nen vybrno umstn)
     */
    public int selectedSlot();
    
    /** Vrac vybran umstn.
     * @return vybran zdroje (null, pokud nen vybrno umstn)
     */
    public ActivityResources selectedResources();

    /** Vrac vybran umstn.
     * @return konfliktn aktivity (null, pokud nen vybrno umstn)
     */
    public ActivityGroup selectedConflictActivities();
}

