/*
 * HumanValueSelection.java
 *
 * Created on 25. nor 2001, 19:03
 * Documented 18. 7. 2001
 */

package timetable.solver.strategy.value;

import timetable.data.*;
import timetable.solver.strategy.price.*;
import timetable.solver.strategy.*;
import timetable.util.*;
/** Heuristika vbru umstn - vbr provede uivatel pomoc dialogu HumanValueSelectionDlg.
 * Vbr je veden ohodnocenm SingleActivityEvaluation - umstn jsou seazena dle tto heuristiky, je jich maximln N.
 *
 * @author Tom Mller
 * @version 1.0
 */
public class HumanValueSelection extends AbstractValueSelection {
    /** Vbr N=50 nejlepch umstn, kter se budou prezentovat uivateli. poet*/
    protected int TOP10MAX=50;
    /** Vbr N=50 nejlepch umstn, kter se budou prezentovat uivateli. tda zajitujc vbr*/
    Top10Value top10 = null;
    /** Vybran umstn */
    int selected=0;
    
    /** Konstruktor.
     * @param config konfigurace
     * @param evaluation ohodnocovac funkce
     */
    public HumanValueSelection(Config config,SingleActivityEvaluationInterface evaluation) throws TimetableException {
        super(config,evaluation);
        top10 = new Top10Value(TOP10MAX);        
    }
    
    /** Nastaven aktivity, pro kterou se bude umstn hledat. Reset heuristiky.
     * @param activity vybran aktivita
     */
    public void reset(Activity activity) {
        top10.reset();
        this.activity = activity;
    }
    
        
    /** Pidn monho umstn do vbru. 
     * @param slot poten slot 
     * @param selectedResources vybran zdroje
     * @param dependences mnoina vech zvislost
     * @param conflictActivities mnoina aktivit, kter jsou s danm umstnm v konfliktu - budou se muset z rozvrhu odebrat v ppad zvolen tohoto umstn
     */
    public void addValue(int slot,ActivityResources selectedResources,ActivityDependenceGroup dependences,ActivityGroup conflictActivities) throws TimetableException {
        int adept = evaluation.value(activity,slot,selectedResources,dependences,conflictActivities);
        config.log("      VALUE="+adept);
        if (top10.willBeAdded(adept)) {
            top10.add(adept,slot,(ActivityResources)selectedResources.clone(),conflictActivities);
            config.log("        ADDED");
        }
    }
    
   /** Metoda provede vbr umstn. */
     public void select() throws TimetableException {
        if (top10.size()==0) { selected=-1;return;}
        HumanValueSelectionDlg dlg = new HumanValueSelectionDlg(null,config);
        for (int i=0;i<top10.size();i++) 
            dlg.addAdept(top10.slot(i),top10.resources(i).toString(),top10.activities(i).toString());
        dlg.show();
        selected = dlg.getSelected();
    }
    
    /** Vrac vybran umstn.
     * @return poten slot
     */
    public int selectedSlot() {
        return (selected<0?-1:top10.slot(selected));
    }

    /** Vrac vybran umstn.
     * @return vybran zdroje
     */
    public ActivityResources selectedResources() {
        return (selected<0?null:top10.resources(selected));
    }
    
    /** Vrac vybran umstn.
     * @return konfliktn aktivity
     */
    public ActivityGroup selectedConflictActivities() {
        return (selected<0?null:top10.activities(selected));
    }
    
}