/*
 * SingleActivityEvaluation.java
 *
 * Created on 12. jen 2000, 12:13
 * Documented 18. 7. 2001
*/

package timetable.solver.strategy.price;

import timetable.data.*;
import timetable.util.*;

/** Implementace implicitn ohodnocovac funkce.
 *
 * @author Tom Mller
 * @version 1.0
 */
public class SingleActivityEvaluation implements SingleActivityEvaluationInterface {
    /** globln konfigurace */
    protected Config config = null;
    
    /** Konstruktor.
     * @param config konfigurace - parametry ohodnocen
     */
    public SingleActivityEvaluation(Config config) throws TimetableException {
        this.config = config;
    }
    
    /** Ohodnocovac funkce.
     * @param activity aktivita, kter se umstuje
     * @param slot umstn - poten slot
     * @param selectedResources umstn - vybran zdroje
     * @param dependences mnoina vech zvislost
     * @param conflictActivities mnoina aktivit, kter jsou s danm umstnm v konfliktu - budou se muset z rozvrhu odebrat v ppad zvolen tohoto umstn
     * @return ohodnocen danho umstn (men hodnota pedstavuje lep umstn, hledme umstn s minimln hodnotou)
     */
    public int value(Activity activity,int slot,ActivityResources selectedResources,ActivityDependenceGroup dependences,ActivityGroup conflictActivities) throws TimetableException {
        int sum=0;
        for (int i=0;i<activity.length;i++) 
          if (activity.getPreference().isSOFT(slot+i)) sum += config.getInt("OHODNOCENI_VAHA_SOFT_AKTIVITY");
        for (int i=0;i<selectedResources.size();i++) {
            if (selectedResources.isGroup(i))
                for (int k=0;k<selectedResources.getResources(i).size();k++)
                    for (int j=0;j<activity.length;j++) {
                      if (selectedResources.getResources(i).get(k).getPreference().isSOFT(j+slot)) sum += config.getInt("OHODNOCENI_VAHA_SOFT_ZDROJE");
                    }
            else 
                for (int j=0;j<activity.length;j++) {
                    if (selectedResources.getResource(i).getPreference().isSOFT(j+slot)) sum += config.getInt("OHODNOCENI_VAHA_SOFT_ZDROJE");
                }
        }
        int sum_remove = 0;        
        for (int i=0;i<conflictActivities.size();i++) {
            if (conflictActivities.get(i).lastRemovedBy==activity) sum += config.getInt("OHODNOCENI_VAHA_CYKLUS");            
            if (config.getInt("OHODNOCENI_VAHA_VYHOZENA_VYHODI_JINOU")!=0)
                if (conflictActivities.get(i).countScheduleWithoutCollision(dependences)<=1) sum += config.getInt("OHODNOCENI_VAHA_VYHOZENA_VYHODI_JINOU");
            sum_remove += conflictActivities.get(i).nrRemoves;
        }
        sum += (int)(sum_remove*config.getInt("OHODNOCENI_VAHA_POCTU_VYHOZENI"));
        sum += conflictActivities.size()*config.getInt("OHODNOCENI_VAHA_JINA_AKTIVITA");
        if (activity.lastStart>=0) {
            if (slot!=activity.lastStart) sum += config.getInt("OHODNOCENI_VAHA_JINAM");
            for (int i=0;i<selectedResources.size();i++)
                if (selectedResources.isGroup(i))
                    for (int k=0;k<selectedResources.getResources(i).size();k++) {
                        if (selectedResources.getResources(i).get(k)!=activity.lastSelectedResources.getResources(i).get(k)) sum += config.getInt("OHODNOCENI_VAHA_JINAM");
                    }
                else
                    if (selectedResources.getResource(i)!=activity.lastSelectedResources.getResource(i)) sum += config.getInt("OHODNOCENI_VAHA_JINAM");
        }        
        return sum;
    }
    
}