/*
 * Top10.java
 *
 * Created on 22. jen 2000, 16:01
 * Documented 9. 7. 2001
 */

package timetable.solver.strategy;

/** Tda zpravujc skupinu n nejlepch prvk (prvk s nejmen hodnotou). 
 *
 * @author Tom Mller
 * @version 1.0
 */
public class Top10 extends java.lang.Object {
    /** Poet nejlepch hodnot */
    protected int maximum = 10;
    /** Pole nejlepch prvk */
    protected int top[] = null;
    /** Poet prvk v poli*/
    protected int count=0;
    /** Pole pslunch hodnot prvk*/
    protected Object value[] = null;

    /** Konstruktor
     * @param maximum poet prvk v poli
     */
    public Top10(int maximum) {
        this.maximum=maximum;
        top = new int [ maximum ];
        value = new Object [ maximum ];
        reset();
    }
        
    /** Konstruktor. Poet prvk ve skupin bude 10.
     */
    public Top10() {
        this(10);
    }
    
    /** Vrt poet prvk ve skupin */
    public int size() { return count; }

    /** Vymae vechny prvky z pole. */
    public void reset() {
        for (int i=0;i<maximum;i++) {
            top[i]=-1;
            value[i]=null;
        };
        count=0;
    }
    
    /** Bude prvek s danou hodnotou pidn do skupiny.
     * @param top hodnota
     * @return true, pokud bude (t.j. poet prvk ve skupin je men ne je kapacita pole nebo hodnota poslednho prvku v pole je vy ne vstupn hodnota
     */
    public boolean willBeAdded(int top) {
        return (this.top[maximum-1]==-1 || this.top[maximum-1]>top);
    }
    
    /** Pidn prvku do skupiny. Prvek bude pidn pouze tehdy, pokud spluje podmnky:
     * <ul><li>poet prvk ve skupin je men, ne je kapacita skupiny</li>
     * <li>posledn prvek m vy hodnotu</li></ul>
     *  Prvek bude zaazen na pslunou pozici dle hodnoty ( prvn s nejmen hodnotou, dle vzestupn)
     * @param top hodnota prvku
     * @param value prvek
     */
    public void add(int top, Object value) {
        if (this.top[maximum-1]!=-1 && this.top[maximum-1]<=top) return;
        int pos = 0;
        while (pos<maximum && this.top[pos]!=-1 && this.top[pos]<top) pos++;
        for (int i=maximum-2;i>=pos;i--) {
            this.top[i+1]=this.top[i];
            this.value[i+1]=this.value[i];
        };
        this.top[pos]=top;
        this.value[pos]=value;
        if (count<maximum) count++;
    }

    /** Pidn prvku do skupiny. Prvek bude pidn pouze tehdy, pokud spluje podmnky:
     * <ul><li>poet prvk ve skupin je men, ne je kapacita skupiny</li>
     * <li>posledn prvek m ni hodnotu</li></ul>
     *  Prvek bude zaazen na pslunou pozici dle hodnoty ( prvn s nejvt hodnotou, dle vzestupn)
     * <i>Poznmka: funkce add a addMax nelze kombinovat !!!</i>
     * @param top hodnota prvku
     * @param value prvek
     */
    public void addMax(int top, Object value) {
        if (this.top[maximum-1]!=-1 && this.top[maximum-1]>top) return;
        int pos = 0;
        while (pos<maximum && this.top[pos]!=-1 && this.top[pos]>top) pos++;
        for (int i=maximum-2;i>=pos;i--) {
            this.top[i+1]=this.top[i];
            this.value[i+1]=this.value[i];
        };
        this.top[pos]=top;
        this.value[pos]=value;
        if (count<maximum) count++;
    }
    
    /** Vrt dan prvek ze skupiny.
     * @param i pozice prvku ve skupin
     * @return poadovan prvek
     */
    public Object get(int i) {
        return value[i];
    }
    
    /** Vrt hodnotu danho prvku.
     * @param i pozive prvku ve skupin
     * @return hodnota prvku
     */
    public int top(int i) {
        return this.top[i];
    }
    
    /** Vygeneruje nhodn slo 0<= x < limit.
     * @param limit limit
     * @return nhodn slo
     */
    public static int random(int limit) {
        return (int)(java.lang.Math.random()*limit);
    }
    
    /** Poet zajmavch hodnot v seznamu. Tj. poet takovch prvk, kde hodnota nejhorho prvku nen vt ne dvojnsobek hodnoty nejlepho prvku.
     * @return poet zajmavch hodnot
     */
    public int countInteresting() {
        for (int i=1;i<count;i++) {
            if (top(i)>2*top(0)) return i-1;
        }
        return count;
    }
    
}
