/*
 * Tabu.java
 *
 * Created on 12. jen 2000, 16:33
 * Documented 18. 7. 2001
 */

package timetable.solver.strategy;

import timetable.data.*;
import timetable.util.*;
/** Tda implementujc tabu-list. Jde o mnoinu poslednch N piazen (aktivita, umstn).
 *
 * @author Tom Mller
 * @version 1.0
 */
public class Tabu extends java.lang.Object {
    /** poslednch N aktivit */
    protected Activity[] activities;
    /** poslednch N umstn - vybranch zdroj*/
    protected ActivityResources[] resources;
    /** poslednch N umstn - potench slot*/
    protected int[] slots;
    /** pozice poslednho piazen v cyklickm poli */
    protected int pos = 0;
    /** men doby strven na tabu-listu (v ms)*/
    public long tabuTime =0;
    
    /** Konstruktor.
     * @param config globln konfigurace - obsahuje dlku tabu
     */
    public Tabu(Config config) throws TimetableException {
        int tabuLength = config.getInt("DELKA_TABU");
        activities = new Activity [ tabuLength];
        slots = new int [tabuLength];
        resources = new ActivityResources [ tabuLength];
        for (int i=0;i<tabuLength;i++) {
            activities[i]=null;
            resources[i]=null;
        }
        tabuTime =0;
        pos =0;
    }
    
    /** Pidn novho ohodnocenn do tabu-listu
     * @param a zvolen aktivita
     * @param slot umstn - poten asov slot
     * @param g umstn - vybran zdroje
     */
    public void add(Activity a, int slot, ActivityResources g) {
        long start=System.currentTimeMillis();
        pos = (pos +1) % slots.length;
        activities[pos]=a;
        slots[pos]=slot;
        resources[pos]=(ActivityResources)g.clone();
        tabuTime+=(System.currentTimeMillis()-start);
    }

    /** Je dan umstn tabu?
     * @param a zvolen aktivita
     * @param slot umstn - poten asov slot
     * @param g umstn - vybran zdroje
     * @return true, pokud je dan umstn pro danou aktivitu tabu (ji je v tabu-listu)
     */
    public boolean isTabuMove(Activity a, int slot, ActivityResources g) {
        long start=System.currentTimeMillis();
        for (int i=0;i<slots.length;i++) 
            if (activities[i]==a && slots[i]==slot && resources[i].equals(g)) {
                tabuTime+=(System.currentTimeMillis()-start);
                return true;
            };
        tabuTime+=(System.currentTimeMillis()-start);
        return false;
    }

    /** Je dan umstn v tabu-listu dvakrt (i vcekrt)?
     * @param a zvolen aktivita
     * @param slot umstn - poten asov slot
     * @param g umstn - vybran zdroje
     * @return true, pokud je dan umstn pro danou aktivitu tabu-listu vce ne jednou
     */
    public boolean isTabuMoveTwiceMore(Activity a, int slot, ActivityResources g) {
        boolean onesTabuMove = false;
        long start=System.currentTimeMillis();
        for (int i=0;i<slots.length;i++) 
            if (activities[i]==a && slots[i]==slot && resources[i].equals(g)) 
                if (onesTabuMove) {
                    tabuTime+=(System.currentTimeMillis()-start);
                    return true;
                } else onesTabuMove=true;
        tabuTime+=(System.currentTimeMillis()-start);
        return false;
    }

}
