/*
 * PreferencePanel.java
 *
 * Created on 6. prosinec 2000, 9:21
 */

package timetable.gui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import timetable.data.*;
import timetable.util.*;
/**
 *
 * @author  Administrator
 * @version 
 */
public class TimePreferencePanel extends javax.swing.JPanel implements ActionListener {

//    private int NrColumns =0;
//    private int NrRows=0;
    
    public static Color BG_NORMAL = new Color(255,255,255);
    public static Color BG_HARD = new Color(210,150,150);
    public static Color BG_SOFT = new Color(200,200,150);
    public static javax.swing.border.LineBorder BORDER_DEFAULT = new javax.swing.border.LineBorder(java.awt.Color.darkGray,1);
    public static Color COLOR_HEAD = new Color(120,120,255);
    
    private JPopupMenu menu;
    private JMenuItem mNormal,mSoft,mHard;
    
    
    /** Creates new form PreferencePanel */
    public TimePreferencePanel(Config config,TimePreference preference) throws TimetableException {
//        this.config=config;
//        this.preference=preference;
        int NrRows = config.getInt(Config.NR_DAYS);
        if (NrRows==0) NrRows=5;
        int slots = config.getInt(Config.NR_SLOTS);
        int NrColumns = slots/NrRows;
        menu = new JPopupMenu();
        mNormal = new JMenuItem(Loc.get("timetable.gui.preferrence.normal"));
        mSoft = new JMenuItem(Loc.get("timetable.gui.preferrence.soft"));
        mHard = new JMenuItem(Loc.get("timetable.gui.preferrence.hard"));
        menu.add(mNormal);
        menu.add(mSoft);
        menu.add(mHard);
        mNormal.addActionListener(this);
        mSoft.addActionListener(this);
        mHard.addActionListener(this);

        setLayout(new java.awt.GridLayout(NrRows+1,NrColumns+1,0,0));
        this.add(new OnePrefPanel(""));
        for (int i=0;i<NrColumns;i++) 
            this.add(new OnePrefPanel(""+(i+1)));
        for (int i=0;i<slots;i++) {
            if (i%NrColumns==0) this.add(new OnePrefPanel(config.dayOfWeek(i)));
            this.add(new OnePrefPanel(preference,i));
        };
//        initComponents ();
        this.setPreferredSize(new java.awt.Dimension((1+NrColumns)*20,(1+NrRows)*20));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        setLayout(new java.awt.GridLayout(5, 10));
    }//GEN-END:initComponents

    public void actionPerformed(final java.awt.event.ActionEvent e) {
        if (e.getSource()==mNormal) ((OnePrefPanel)(menu.getInvoker())).setFree();
        if (e.getSource()==mSoft) ((OnePrefPanel)(menu.getInvoker())).setSoft();
        if (e.getSource()==mHard) ((OnePrefPanel)(menu.getInvoker())).setHard();
    }    

    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables

    public class OnePrefPanel extends JPanel {
        private TimePreference preference;
        private int slot;
        private boolean selected=false;
        

        public OnePrefPanel(String text) {
            this.setPreferredSize(new java.awt.Dimension(20,20));
            this.setBorder(BORDER_DEFAULT);
            this.setBackground(COLOR_HEAD);
            this.add(new javax.swing.JLabel(text));
        }
            
        public OnePrefPanel(TimePreference preference,int slot) {
            this.preference=preference;
            this.slot=slot;
            
            if (preference.isHARD(slot)) this.setBackground(BG_HARD); else
                if (preference.isSOFT(slot)) this.setBackground(BG_SOFT); else
                    this.setBackground(BG_NORMAL);
            this.setPreferredSize(new java.awt.Dimension(20,20));
            this.setBorder(BORDER_DEFAULT);
            this.addMouseListener(new java.awt.event.MouseAdapter() {
                public void mouseClicked(MouseEvent e) {
                    if ((e.getModifiers()&e.BUTTON3_MASK)>0) {
                        menu.show(OnePrefPanel.this,e.getX(),e.getY());
                    };
                    if ((e.getModifiers()&e.BUTTON1_MASK)>0) {
                        if (e.isControlDown()) setHard(); else 
                            if  (e.isAltDown()) setSoft(); else
                                setFree();
                    };
                }
                
            });
        }
        
        public void setFree() {
          preference.setFREE(slot);
          this.setBackground(BG_NORMAL);
        }
        public void setSoft() {
          preference.setSOFT(slot);
          this.setBackground(BG_SOFT);
        }
        public void setHard() {
          preference.setHARD(slot);
          this.setBackground(BG_HARD);
        }
    }
}
