/*
 * DNDTable.java
 *
 * Created on 24. nor 2001, 11:01
 */

package timetable.gui;

/**
 *
 * @author  Administrator
 * @version 
 */
import java.awt.*;
import java.awt.dnd.*;
import java.awt.datatransfer.*;
import java.io.*;
import javax.swing.table.*;

public class DNDTable extends javax.swing.JTable 
    implements DropTargetListener,DragSourceListener, DragGestureListener    {
        
  protected DNDTableEngine dndEngine = null;
  protected Cursor cursor;
  /**
   * enables this component to be a dropTarget
   */
  DropTarget dropTarget = null;

  /**
   * enables this component to be a Drag Source
   */
  DragSource dragSource = null;


  public void setDNDTableEngine(DNDTableEngine dndEngine) {
      this.dndEngine=dndEngine;
  }
  
  /**
   * constructor - initializes the DropTarget and DragSource.
   */

  public DNDTable() {
    super();
    init();
  }
  
  public DNDTable(TableModel model) {
      super(model);
      init();
  }
  
  public void init() {
    dndEngine = new DefaultDNDTableEngine();
    cursor=this.getCursor();
    dropTarget = new DropTarget (this, this);
    dragSource = new DragSource();
    dragSource.createDefaultDragGestureRecognizer( this, DnDConstants.ACTION_MOVE, this);
  }

  /**
   * is invoked when you are dragging over the DropSite
   * 
   */

  public void dragEnter (DropTargetDragEvent event) {
      //System.out.println("dragEnter (DropTargetDragEvent event)");
  }

  /**
   * is invoked when you are exit the DropSite without dropping
   *
   */

  public void dragExit (DropTargetEvent event) {
      //System.out.println("dragExit (DropTargetEvent event)");
      this.setCursor(cursor);
  }

  /**
   * is invoked when a drag operation is going on
   * 
   */
  public void dragOver (DropTargetDragEvent event) {
    //System.out.println("dragOver (DropTargetDragEvent event)");
    if (dndEngine.canDrop(this.rowAtPoint(event.getLocation()),this.columnAtPoint(event.getLocation()),this)) {
        event.acceptDrag(DnDConstants.ACTION_MOVE);
        this.setCursor(DragSource.DefaultMoveDrop);
    } else {
        event.rejectDrag(); 
        this.setCursor(DragSource.DefaultMoveNoDrop);
    };
  }

  /**
   * a drop has occurred
   * 
   */
  public void drop (DropTargetDropEvent event) {
     int row=this.rowAtPoint(event.getLocation());
     int column=this.columnAtPoint(event.getLocation());
     if (row>=0 && column>=0 && dndEngine.canDrop(row,column,this)) {
         dndEngine.drop(row,column,this);
         updateUI();
     } else {
         event.rejectDrop();
     }
  }

  /**
   * is invoked if the use modifies the current drop gesture
   * 
   */
  public void dropActionChanged ( DropTargetDragEvent event ) {
      //System.out.println("dropActionChanged ( DropTargetDragEvent event )");
  }

  /**
   * a drag gesture has been initiated
   * 
   */
  public void dragGestureRecognized( DragGestureEvent event) {
    if (dndEngine.canDrag(getSelectedRow(),getSelectedColumn(),this)) {
      StringSelection text = new StringSelection("DNDTable Drag & Drop Feature"); 
      // as the name suggests, starts the dragging
      cursor = this.getCursor();
      dragSource.startDrag (event, null, text, this);
      dndEngine.drag(getSelectedRow(),getSelectedColumn(),this);
    };
  }

  /**
   * this message goes to DragSourceListener, informing it that the dragging 
   * has ended
   * 
   */
  public void dragDropEnd (DragSourceDropEvent event) {   
      //System.out.println("dragDropEnd (DragSourceDropEvent event)");
    this.setCursor(cursor);
    dndEngine.done();
  }

  /**
   * this message goes to DragSourceListener, informing it that the dragging 
   * has entered the DropSite
   * 
   */
  public void dragEnter (DragSourceDragEvent event) {
      //System.out.println("dragEnter (DragSourceDragEvent event)");
  }

  /**
   * this message goes to DragSourceListener, informing it that the dragging 
   * has exited the DropSite
   * 
   */

  public void dragExit (DragSourceEvent event) {
      //System.out.println("dragExit (DragSourceEvent event)");
      this.setCursor(cursor);
  }
  /**
   * this message goes to DragSourceListener, informing it that the dragging is currently 
   * ocurring over the DropSite
   * 
   */

  public void dragOver (DragSourceDragEvent event) {
      //System.out.println("dragOver (DragSourceDragEvent event)");
  }
  
  /**
   * is invoked when the user changes the dropAction
   * 
   */
  public void dropActionChanged ( DragSourceDragEvent event) {
      //System.out.println("dropActionChanged ( DragSourceDragEvent event)");
  }
    
}
