package timetable.data;
/*
 * TimePreference.java
 *
 * Created on 15. prosinec 2000, 14:38
 * Documented 8.7.2001
 */

import timetable.util.*;
/** asov preference zdroj a aktivit.
 *
 * @author  Tom Mller
 * @version 1.0
 */
public class TimePreference implements java.io.Serializable {
    /** Pole slot. */
    protected int [] slots = null;
    /** Globln konfigurace */
    Config config=null;
    /** Voln slot - default*/
    public static int FREE=0;
    /** HARD podmnka - slot neme bt pouit */
    public static int HARD=1;
    /** SOFT podmnka - slot by neml bt pouit */
    public static int SOFT=2;
    
    /**Konstruktor.
     * @param config konfigurace
     */
    public TimePreference(Config config) throws TimetableException {
        this.config=config;
        slots = new int [config.getInt(Config.NR_SLOTS)];
        for (int i=0; i<slots.length; i++ ) slots[i]=FREE;
    }
        
    /** Nastaven preference slotu
     * @param slot slo slotu
     * @param type podmnka {FREE, SOFT, HARD}
     */
    public void set(int slot, int type) {
        slots[slot]=type;
    }

    /** Zjitn podmnky slotu
     * @param slot slo slotu
     * @return podmnka {FREE, SOFT, HARD}
     */
    public int get(int slot) {
        return slots[slot];
    }
     
    /** Nastaven podmnky FREE (bez preference) na dan slot
     * @param slot slo slotu
     */
    public void setFREE(int slot) {
        set(slot,FREE);
    }

    /** Nastaven podmnky SOFT (slot nen preferovn) na dan slot
     * @param slot slo slotu
     */
    public void setSOFT(int slot) {
        set(slot,SOFT);
    }

    /** Nastaven podmnky HARD (slot neme bt pouit) na dan slot
     * @param slot slo slotu
     */
    public void setHARD(int slot) {
        set(slot,HARD);
    }
    
    /** Nastaven podmnky pro vce slot najednou
     * @param startSlot slo prvnho slotu
     * @param endSlot slo poslednho slotu
     * @param type podmnka {FREE, SOFT, HARD}
     */
   
    public void set(int startSlot, int endSlot, int type) {
        for (int i=startSlot;i<=endSlot;i++)
            set(i,type);
    }
    
    /** Je na danm slotu HARD podmnka (slot neme bt pouit) ?
     * @param slot slo slotu
     * @return true, pokud ano
     */
    public boolean isHARD(int slot) {
        return (get(slot)==HARD);
    }

    /** Je na danm slotu FREE podmnka (slot bez preference) ?
     * @param slot slo slotu
     * @return true, pokud ano
     */
    public boolean isFREE(int slot) {
        return (get(slot)==FREE);
    }

    /** Je na danm slotu SOFT podmnka (slot by neml bt pouit) ?
     * @param slot slo slotu
     * @return true, pokud ano
     */
    public boolean isSOFT(int slot) {
        return (get(slot)==SOFT);
    }    
          
    /** Textov vyjden pole podmnek. Napklad: Po3, Po5, t4-8
     * @param type podmnka {FREE, SOFT, HARD}
     * @return repreyentace podmnky
     */
   public String toString(int type) throws TimetableException {
       int slot=0;
       int nrDays = config.getInt(Config.NR_DAYS);
       int nrSlots= config.getInt(Config.NR_SLOTS);
       int nrSlotsPerDay = nrSlots/nrDays;
       java.lang.StringBuffer r = new java.lang.StringBuffer();
       do {
           if (get(slot)==type) {
               int j=slot;
               int day=slot/nrSlotsPerDay;
               while (j<nrSlots && get(j)==type && (j/nrSlotsPerDay)==day) j++;
               j--;
               if (slot==j) r.append(""+config.dayOfWeek(j)+" "+(j%nrSlotsPerDay+1)+","); else {
                   r.append(""+config.dayOfWeek(slot)+" "+(slot%nrSlotsPerDay+1)+"-"+(j%nrSlotsPerDay+1)+",");
               };
               slot=j+1;
           } else slot++;
       } while (slot<nrSlots);
       if (r.toString().length()>0) r.deleteCharAt(r.toString().length()-1);
       return r.toString();
   }

   /**Vytvo jinou instanci stejnho pole asovch preferenc
    * @return jin instance stejnho pole preferenc
    */
    public Object clone() {
        try {
            TimePreference p = new TimePreference(config);
            for (int i=0;i<p.slots.length;i++) p.slots[i]=slots[i];
            return p;
        } catch (TimetableException e) {};
        return null;
    }

    /** Zpis objektu do streamu
     * @param out stream
     */
    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
       out.writeObject(slots);
   }

   /** Naten objektu ze streamu
    * @param in stream
    */
   private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
       slots = (int[]) in.readObject();
   }

}
