/*
 * ActivityResources.java
 *
 * Created on 12. jen 2000, 13:09
 * Documented 7.7.2001
 */

package timetable.data;

import java.util.Vector;
/** Reprezentace mnoiny skupin zdroj. Tda umouje i ukldn jednotlivch zdroj - co je ekvivalentn skupinm zdroj o jednom prvku.
 * <BR> Jde tedy o jaksi pole promnn dlky, kde prvkem me bt budto samotn zdroj nebo skupina zdroj.
 *
 * @author Tom Mller
 * @version 1.0
 */
public class ActivityResources extends java.lang.Object implements java.io.Serializable{
    /** reprezentace skupin zdroj tdou java.util.Vector */
    private Vector resources = new Vector();

    /** Konstruktor. */
    public ActivityResources() {
    }
    
    /** Konstruktor.
     * @param resource zdroj, kter bude do mnoiny pidn.
     */
    public void add(Resource resource) {
        resources.add(resource);
    }

    /** Konstruktor.
     * @param resources skupina zdroj, kter bude do mnoiny pidna.
     */
    public void add(ResourceGroup resources) {
        this.resources.add(resources);
    }
    
    /** Nastav zdroj i skupinu zdroj na danm mst.
     * @param pos index pozice
     * @param o zdroj nebo skupina zdroj, kter bude uloena na dan pozici
     */
    public void setAt(int pos,Object o) {
        this.resources.setElementAt(o,pos);
    }
    
    /** Odstrann zdroje i skupiny zdroj.
     * @param i index zdroje i skupiny zdroj, kter() m bt odstrann(a)
     */
    public void remove(int i) {
        resources.remove(i);
    }

    /** Odstrann zdroje i skupiny zdroj
     * @param o zdoj i skupina zdroj, kter() m bt odstrann(a)
     */
    public void remove(Object o) {
        resources.remove(o);
    }
    
    /** Odstrann vech prvk mnoiny.*/
    public void removeAll() {
        resources.removeAllElements();
    }
    
    /** Vrt poet prvk v mnoin. Tedy poet zdroj i skupin zdroj ve skupin.
     * @return poet prvk
     */
    public int size() {
        return resources.size();
    }
    
    /** Zjist, zda-li je i-t prvek skupina nebo samostatn zdroj
     * @return true, pokud jde o skupinu
     */
    public boolean isGroup(int i) {
        return (resources.get(i) instanceof ResourceGroup);
    }
    
    /** Zjist umstn zdroje i skupiny zdroj v mnoin
     * @param o hledan zdroj i skupina zdroj
     * @return pslun index, -1 pokud takov prvek ve mnoin nen
     */
    public int indexOf(Object o) {
        return resources.indexOf(o);
    }
    
    /** Vrt index prvku (zdroje i skupiny zdroj) kter obsahuje dan zdroj.
     * @param resource hledan zdroj
     * @return index zdroje i skupiny zdroj, kter je (nebo kter obsahuje) pslun zdroj
     */
    public int contains(Resource resource) {
        for (int i=0;i<size();i++)
            if (isGroup(i)) {
                if (getResources(i).indexOf(resource)>=0) return i;
            } else {
                if (getResource(i)==resource) return i;
            };
        return -1;
    }
    
    /** Vrt zdroj na dan pozici. 
     * @param i index ve mnoin
     * @return pslun zdroj (Pokud je na dan pozici skupina zdroj, nvratov hodnota bude null)
     */
    public Resource getResource(int i) {
        try {
            return (Resource) (resources.get(i));
        } catch (Exception e) {
            return null;
        }
    }

    /** Vrt skupinu zdroj na dan pozici
     * @param i index ve mnoin
     * @return pslun skupina zdroj (Pokud je na dan pozici samostan zdroj, nvratov hodnota bude null)
     */
    public ResourceGroup getResources(int i) {
        try {
            return (ResourceGroup) (resources.get(i));
        } catch (Exception e) {
            return null;
        }
    }
    
    /** Zjist, zda-li me bt dan mnoina poadovanch zdroj pouita pro plnovn v dan as. To znamen, e musej bt pouiteln vechny zdroje v mnoin, pokud jde o skupinu zle navc na tom, zda-li je konjunktivn. Pokud je skupina konjunktivn, musej bt pouiteln vechny zdroje, pokud je disjunktivn, mus jt pout alespo jeden zdroj.
     * <BR>Pouitelnost znamen, e dan zdroj me bt uvolnn pro plnovn a dn HARD podmnka nebude poruena.
     * @param slot prvn slot asovho seku
     * @length poet slot asovho seku (sloty <code>slot .. slot+length-1</code> jsou kontrolovny)
     * @return true, pokud ano (aktivita lze tedy naplnovat na dan msto)
     */
    public boolean canAllBeFreeAt(int slot, int length) {
        for (int i=0;i<size();i++) {
            if (isGroup(i)) {
                if (getResources(i).conjunctive) {
                    if (!getResources(i).canAllBeFreeAt(slot,length)) return false;
                } else {
                    if (!getResources(i).canOneBeFreeAt(slot,length)) return false;
                }
            } else {
                if (!getResource(i).canBeFreeAt(slot,length)) return false;
            }
        }
        return true;
    }

    /** Zjist, zda-li je dan mnoina poadovanch zdroj voln v dan as. (v ppad disjunktivnch skupin sta aby byl voln pouze jeden zdroj skupiny)
     * @param slot prvn slot asovho seku
     * @length poet slot asovho seku (sloty <code>slot .. slot+length-1</code> jsou kontrolovny)
     * @return true, pokud ano (aktivita lze tedy naplnovat na dan msto bez konfliktu)
     */
    public boolean isAllFreeAt(int slot, int length) {
        for (int i=0;i<size();i++) {
            if (isGroup(i)) {
                if (getResources(i).conjunctive) {
                    if (!getResources(i).isAllFreeAt(slot,length)) return false;
                } else {
                    if (!getResources(i).isOneFreeAt(slot,length)) return false;
                }
            } else {
                if (!getResource(i).isFreeAt(slot,length)) return false;
            }
        }
        return true;
    }

    /** Spote poet monch umstn aktivity v dan as bez konfliktu. 
     * @param slot prvn slot asovho seku
     * @length poet slot asovho seku (sloty <code>slot .. slot+length-1</code> jsou kontrolovny)
     * @return 0, pokud aktivita neme bt naplnovna. Jinak jde o souin volnch zdroj disjunktnch skupin v dan as)
     */
    public int countAllFreeAt(int slot, int length) {
        int sum =1;
        for (int i=0;i<size();i++) {
            if (isGroup(i)) {
                if (getResources(i).conjunctive) {
                    if (!getResources(i).isAllFreeAt(slot,length)) return 0;
                } else {
                    sum*=getResources(i).countFreeAt(slot,length);
                    if (sum==0) return 0;
                }
            } else {
                if (!getResource(i).isFreeAt(slot,length)) return 0;
            }
        }
        return sum;
    }

    /** Zpis mnoiny na stream 
     * @param out stream
     */
   private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
       out.writeObject(resources);
   }

    /** Naten mnoiny ze streamu
     * @param in stream
     */
   private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
       resources = (Vector) in.readObject();
   }
   
    /** Zpis mnoiny na stream 
     * @param out stream
     * @param allResources mnoina vech zdroj
     */
   public void write(java.io.ObjectOutputStream out, ResourceGroup allResources) throws java.io.IOException {
       out.writeInt(size());
       for (int i=0;i<size();i++) {
           out.writeBoolean(isGroup(i));
           if (isGroup(i)) {
               getResources(i).write(out, allResources);
           } else {
               getResource(i).write(out, allResources);
           };
       };
   }
   
    /** Naten mnoiny ze streamu 
     * @param in stream
     * @param allResources mnoina vech zdroj
     * @return naten mnoina 
     */
   public static ActivityResources read(java.io.ObjectInputStream in, ResourceGroup allResources)  throws java.io.IOException, java.lang.ClassNotFoundException {
       int size = in.readInt();
       ActivityResources ar = new ActivityResources();
       for (int i=0;i<size;i++) {
           if (in.readBoolean()) {
               ar.add(ResourceGroup.read(in,allResources));
           } else {
               ar.add(Resource.read(in,allResources));
           };
       };
       return ar;
   }
   
   /** Vytvo jinou instanci tto mnoiny
    * @return jin instance stejn mnoiny
    */
    public Object clone() {
        ActivityResources g = new ActivityResources();
        for (int i=0;i<size();i++) 
            if (isGroup(i))
                g.add(getResources(i));
            else 
                g.add(getResource(i));
        return g;
    }       
    
    /* Vrt etzec zkratek jmen jednotlivch zdroj. Pklad: "Z1, {Z2}, {Z3, Z4}" (Z1 je samostatn zdroj, ostatn jsou skupiny)
     * @return etzec pedstavujc zkratky jmen jednotlivch zdroj
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i=0;i<size();i++) {
            if (i!=0) sb.append(", ");
            if (isGroup(i))
              sb.append(getResources(i).toString());
            else
              sb.append(getResource(i).toString());
        };
        return sb.toString();
    }

}
