import timetable.data.*;
import timetable.util.*;
import timetable.solver.*;
import timetable.solver.strategy.*;
import timetable.solver.strategy.price.*;
import timetable.solver.strategy.value.*;
import timetable.solver.strategy.variable.*;

public class Example {
    
    public static void main(String args[]) {
        try {
            Config konf = new Config("konfig.cfg"); //konfigurace
            Problem problem = new Problem(konf); //rozvrhovaci problem
        
            //vstup  definice jednoducheho problemu
            Resource[] ucebny = { // Ucebny
                new Resource(konf,"uc 1"), new Resource(konf,"uc 2"),
                new Resource(konf,"uc 3")
            };
            Resource[] vyucujici = { //Vyucujici
                new Resource(konf,"Novak"), new Resource(konf,"Maznak")
            };
            Resource[] tridy = { //Tridy
                new Resource(konf,"1.A"), new Resource(konf,"1.B")
            };
        
            //Predmety
            problem.activities.add(new Activity(konf,"Matematika",2));
            problem.activities.add(new Activity(konf,"Cesky jazyk",1));
            problem.activities.add(new Activity(konf,"Anglictina",1));
            problem.activities.add(new Activity(konf,"Kresleni",3));
        
            //pozadovane zdroje
            //Matematiku a Anglictinu bude ucit Novak, zbytek Maznak
            problem.activities.get(0).resources.add(vyucujici[0]);
            problem.activities.get(1).resources.add(vyucujici[1]);
            problem.activities.get(2).resources.add(vyucujici[0]);
            problem.activities.get(3).resources.add(vyucujici[1]);
        
            //1.A. bude mit Matematiku a Kresleni
            //1.B. bude mit Anglictinu, Cesky jazyk a take Kresleni
            ResourceGroup obeTridy = new ResourceGroup( tridy );
            obeTridy.conjunctive = true; //jde o konjunktivni skupinu
            problem.activities.get(0).resources.add(tridy[0]);
            problem.activities.get(1).resources.add(tridy[1]);
            problem.activities.get(2).resources.add(tridy[1]);
            problem.activities.get(3).resources.add(obeTridy);
        
            //Vsechny predmety mohou byt vyucovany v libovolnych ucebnach
            //krome anglictiny, ktere musi byt vyucovano v ucebne2
            ResourceGroup vsechnyUcebny = new ResourceGroup( ucebny );
            problem.activities.get(0).resources.add(vsechnyUcebny);
            problem.activities.get(1).resources.add(vsechnyUcebny);
            problem.activities.get(2).resources.add(new ResourceGroup(ucebny[1]));
            problem.activities.get(3).resources.add(vsechnyUcebny);
        
            //zavislost: Matematika se musi ucit pred Anglictinou
            problem.dependences.add(new TimeActivityDependence(
            problem.activities.get(0), TimeActivityDependence.BEFORE,
            problem.activities.get(2)));
            
            Solver sol = new Solver(konf,problem); //rozvrhovac
            sol.setValueSelection( //nastaven heuristiky vyberu umisteni
            new MinValueSelection(konf,new Tabu(konf),
            new SingleActivityEvaluation(konf)));
            sol.setVariableSelection(//nastaven heuristiky vyberu aktivity
            new WorstFirstVariableSelection(konf));
                    
            sol.solve(); //reseni problemu
        
            //vystup
            System.out.println("Podarilo se naplanovat "+
            sol.maxScheduledActivities+" predmetu z "+
            problem.activities.size()+".");
            System.out.println("Pouzito "+sol.nrIters+" iteraci.");

            //pro ulozeni
            timetable.school.data.SchoolProblem sp = new timetable.school.data.SchoolProblem(problem);
            sp.resources = new ResourceGroup[] { //pro ulozeni
                new ResourceGroup(tridy), // tridy
                new ResourceGroup(vyucujici), // vyucujici
                new ResourceGroup(ucebny), // ucebny
                new ResourceGroup() //spec. zdroje (meotar, ...)
            };
            sp.groupedClasses.add(obeTridy);obeTridy.shortCut="1R";obeTridy.name="1. rocnik";
            sp.save("example.shd");
        } catch (Exception e) {
            System.err.println("Chyba: "+e);
            e.printStackTrace();
        }
    }
} 