/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Vector;

public class ChunkedInputStream
extends InputStream {
    private byte[] buf;
    private byte[][] bufs;
    private int bufIndex = 0;
    private int count;
    private int pos;
    private InputStream in;
    private char[] lineBuffer;

    public void print() {
        System.out.println("pos is " + this.pos);
        System.out.println("count is " + this.count);
        System.out.println("bufIndex is " + this.bufIndex);
        System.out.println("bufs.length is " + this.bufs.length);
        int n = 0;
        while (n < this.bufs.length) {
            System.out.println("bufs " + n + " is len " + this.bufs[n].length);
            ++n;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    public ChunkedInputStream(InputStream inputStream) throws IOException {
        this.in = inputStream;
        this.prefill();
    }

    private void readFully(byte[] byArray, int n, int n2) throws IOException {
        InputStream inputStream = this.in;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = inputStream.read(byArray, n + n3, n2 - n3);
            if (n4 < 0) {
                throw new EOFException();
            }
            n3 += n4;
        }
    }

    private String readLine() throws IOException {
        int n;
        InputStream inputStream = this.in;
        char[] cArray = this.lineBuffer;
        if (cArray == null) {
            cArray = this.lineBuffer = new char[128];
        }
        int n2 = cArray.length;
        int n3 = 0;
        block4: while (true) {
            n = inputStream.read();
            switch (n) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int n4 = inputStream.read();
                    if (n4 == 10 || n4 == -1) break block4;
                    if (!(inputStream instanceof PushbackInputStream)) {
                        inputStream = this.in = new PushbackInputStream(inputStream);
                    }
                    ((PushbackInputStream)inputStream).unread(n4);
                    break block4;
                }
                default: {
                    if (--n2 < 0) {
                        cArray = new char[n3 + 128];
                        n2 = cArray.length - n3 - 1;
                        System.arraycopy(this.lineBuffer, 0, cArray, 0, n3);
                        this.lineBuffer = cArray;
                    }
                    cArray[n3++] = (char)n;
                    continue block4;
                }
            }
            break;
        }
        if (n == -1 && n3 == 0) {
            return null;
        }
        return String.copyValueOf(cArray, 0, n3);
    }

    private int readChunkSize() throws IOException {
        int n = -1;
        try {
            String string = this.readLine();
            int n2 = 0;
            while (n2 < string.length()) {
                char c = string.charAt(n2);
                if (Character.digit(c, 16) == -1) break;
                ++n2;
            }
            n = Integer.parseInt(string.substring(0, n2), 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Bogus chunk size");
        }
        return n;
    }

    private void prefill() throws IOException {
        int n;
        Vector vector = new Vector();
        while ((n = this.readChunkSize()) != 0) {
            byte[] byArray = new byte[n];
            this.readFully(byArray, 0, n);
            this.readCRLF();
            vector.addElement(byArray);
        }
        this.bufs = new byte[vector.size()][];
        vector.copyInto((Object[])this.bufs);
    }

    private void readCRLF() throws IOException {
        int n = this.in.read();
        if (n != 13) {
            throw new IOException("missing CRLF");
        }
        n = this.in.read();
        if (n != 10) {
            throw new IOException("missing CRLF");
        }
    }

    private void fill() throws IOException {
        if (this.bufs.length == 0 || this.bufIndex >= this.bufs.length) {
            return;
        }
        this.pos = 0;
        this.buf = this.bufs[this.bufIndex];
        this.bufs[this.bufIndex] = null;
        ++this.bufIndex;
        this.count = this.buf.length;
    }

    public synchronized int read() throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    private int read1(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.count - this.pos;
        if (n3 <= 0) {
            this.fill();
            n3 = this.count - this.pos;
            if (n3 <= 0) {
                return -1;
            }
        }
        int n4 = n3 < n2 ? n3 : n2;
        System.arraycopy(this.buf, this.pos, byArray, n, n4);
        this.pos += n4;
        return n4;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        return this.read1(byArray, n, n2);
    }

    public synchronized int available() throws IOException {
        int n = 0;
        this.ensureOpen();
        n = this.count - this.pos;
        int n2 = this.bufIndex;
        while (n2 < this.bufs.length) {
            n += this.bufs[n2].length;
            ++n2;
        }
        return n;
    }

    public synchronized void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.close();
        this.in = null;
        this.buf = null;
        this.bufs = null;
    }
}

