/*
 * Decompiled with CFR 0.152.
 */
package timetable.test;

import timetable.data.Activity;
import timetable.data.Problem;
import timetable.solver.Solver;
import timetable.solver.strategy.Tabu;
import timetable.solver.strategy.price.SingleActivityEvaluation;
import timetable.solver.strategy.value.MinValueSelection;
import timetable.solver.strategy.variable.WorstFirstVariableSelection;
import timetable.test.SmartGenerator;
import timetable.util.Config;

public class Test {
    public static void main(String[] args) {
        try {
            Config k = new Config();
            long dP = 0L;
            long dG = 0L;
            long dVH = 0L;
            long dVP = 0L;
            long dT = 0L;
            SmartGenerator g = new SmartGenerator(k);
            Problem pc = g.generujCele();
            k.set("POCET_ITERACI", 2000);
            Solver s = new Solver(k, pc);
            s.setValueSelection(new MinValueSelection(k, new Tabu(k), new SingleActivityEvaluation(k)));
            s.setVariableSelection(new WorstFirstVariableSelection(k));
            s.solve();
            System.out.println("Podarilo se naplanovat " + s.maxScheduledActivities + " aktivit z " + pc.activities.size() + ".");
            System.out.println("Pouzito " + s.nrIters + " iteraci.");
            int maxc = 0;
            Activity ac = null;
            int i = 0;
            while (i < pc.activities.size()) {
                if (pc.activities.get((int)i).nrRemoves > maxc || ac == null) {
                    maxc = pc.activities.get((int)i).nrRemoves;
                    ac = pc.activities.get(i);
                }
                ++i;
            }
            System.out.println("Nejvice vadi aktivita " + ac.name + " , vyhozena byla " + ac.nrRemoves + "x");
            System.out.println("Doba planovani " + s.solveTime + " ms.");
            System.out.println("Doba generovani " + s.generateTime + " ms.");
            System.out.println("Doba vyberu promenne " + s.selectVariableTime + " ms.");
            System.out.println("Doba vyberu hodnoty " + s.selectValueTime + " ms.");
            pc.print("rozvrhCU.txt", g.ucebny, 0, 3);
            pc.print("rozvrhCV.txt", g.vyucujici, 1, 3);
            pc.print("rozvrhCT.txt", g.tridy, 2, 3);
            k.set("POCET_ITERACI", 1000);
            pc.reset();
            Problem p = g.generuj();
            s = new Solver(k, p);
            s.setValueSelection(new MinValueSelection(k, new Tabu(k), new SingleActivityEvaluation(k)));
            s.setVariableSelection(new WorstFirstVariableSelection(k));
            System.out.println("");
            System.out.println("123456789*123456789*123456789*123456789*123456789*");
            int akt = 1;
            while (akt <= k.getInt("POCET_ITERACI")) {
                if (akt % 10 == 1) {
                    System.out.print(".");
                }
                s.solve();
                dP += s.solveTime;
                dG += s.generateTime;
                dVP += s.selectVariableTime;
                dVH += s.selectValueTime;
                if (s.nrIters == k.getInt("POCET_ITERACI")) {
                    System.out.println(" " + akt + ". pridani se nezdarilo !");
                    int max = 0;
                    Activity a = null;
                    int i2 = 0;
                    while (i2 < p.activities.size()) {
                        if (p.activities.get((int)i2).nrRemoves > max || a == null) {
                            max = p.activities.get((int)i2).nrRemoves;
                            a = p.activities.get(i2);
                        }
                        ++i2;
                    }
                    System.out.println("Nejvice vadi aktivita " + a.name + " , vyhozena byla " + a.nrRemoves + "x");
                    p.print("rozvrhU.txt", g.ucebny, 0, 3);
                    p.print("rozvrhV.txt", g.vyucujici, 1, 3);
                    p.print("rozvrhT.txt", g.tridy, 2, 3);
                    g.odeber(a);
                } else {
                    p.saveState();
                }
                int n = 0;
                int i3 = 0;
                while (i3 < p.activities.size()) {
                    if (p.activities.get(i3).isScheduled()) {
                        ++n;
                    }
                    ++i3;
                }
                if (s.nrIters == k.getInt("POCET_ITERACI")) {
                    System.out.println("Podarilo se naplanovat " + s.maxScheduledActivities + " aktivit z " + p.activities.size() + ".");
                }
                if (s.nrIters == 0 || akt == k.getInt("POCET_ITERACI")) {
                    System.out.println("");
                    System.out.println("");
                    System.out.println("Naplanovano " + n + " aktivit (" + akt + " pridani) .");
                    System.out.println("Nezdarilo se naplanovat " + (akt - n - 1) + "x.");
                    System.out.println("Doba planovani " + dP + " ms.");
                    System.out.println("Doba generovani " + dG + " ms.");
                    System.out.println("Doba vyberu promenne " + dVP + " ms.");
                    System.out.println("Doba vyberu hodnoty " + dVH + " ms.");
                }
                if (s.nrIters == 0) {
                    akt = k.getInt("POCET_ITERACI");
                }
                if (akt == k.getInt("POCET_ITERACI")) {
                    p.print("rozvrhU.txt", g.ucebny, 0, 3);
                    p.print("rozvrhV.txt", g.vyucujici, 1, 3);
                    p.print("rozvrhT.txt", g.tridy, 2, 3);
                }
                p = g.generuj();
                ++akt;
            }
            k.closeLog();
        }
        catch (Exception e) {
            System.err.println("Error: " + e);
            e.printStackTrace();
        }
    }
}

