/*
 * Decompiled with CFR 0.152.
 */
package timetable.test;

import timetable.data.Activity;
import timetable.data.Problem;
import timetable.data.Resource;
import timetable.data.ResourceGroup;
import timetable.data.TimeActivityDependence;
import timetable.solver.Solver;
import timetable.solver.strategy.Tabu;
import timetable.solver.strategy.price.SingleActivityEvaluation;
import timetable.solver.strategy.value.MinValueSelection;
import timetable.solver.strategy.variable.WorstFirstVariableSelection;
import timetable.util.Config;

public class SimpleTest {
    public static void main(String[] args) {
        try {
            Config k = new Config();
            k.set("POCET_SLOTU", 5);
            long dP = 0L;
            long dG = 0L;
            long dVH = 0L;
            long dVP = 0L;
            long dT = 0L;
            long dZA = 0L;
            Problem p = new Problem(k);
            Resource[] tridy = new Resource[]{new Resource(k, "S1"), new Resource(k, "S2"), new Resource(k, "S3"), new Resource(k, "K1"), new Resource(k, "K2"), new Resource(k, "K3")};
            ResourceGroup tridyS = new ResourceGroup(new Resource[]{tridy[0], tridy[1], tridy[2]});
            ResourceGroup tridyK = new ResourceGroup(new Resource[]{tridy[3], tridy[4], tridy[5]});
            Resource[] ucitele = new Resource[]{new Resource(k, "A"), new Resource(k, "B"), new Resource(k, "C")};
            Resource[] kategorie = new Resource[]{new Resource(k, "1.A"), new Resource(k, "2.A"), new Resource(k, "3.A")};
            p.activities.add(new Activity(k, "pA", 2));
            p.activities.add(new Activity(k, "pB", 3));
            p.activities.add(new Activity(k, "pC", 2));
            p.activities.add(new Activity(k, "pE", 2));
            p.activities.add(new Activity(k, "pF", 4));
            p.activities.add(new Activity(k, "pG", 1));
            p.activities.get((int)0).resources.add(ucitele[0]);
            p.activities.get((int)1).resources.add(ucitele[0]);
            p.activities.get((int)2).resources.add(ucitele[1]);
            p.activities.get((int)3).resources.add(ucitele[1]);
            p.activities.get((int)4).resources.add(ucitele[2]);
            p.activities.get((int)5).resources.add(ucitele[2]);
            p.activities.get((int)0).resources.add(tridyS);
            p.activities.get((int)1).resources.add(tridyS);
            p.activities.get((int)2).resources.add(tridyS);
            p.activities.get((int)3).resources.add(tridyS);
            p.activities.get((int)4).resources.add(tridyS);
            p.activities.get((int)5).resources.add(tridyS);
            p.activities.get((int)0).resources.add(kategorie[0]);
            p.activities.get((int)1).resources.add(kategorie[1]);
            p.activities.get((int)2).resources.add(kategorie[1]);
            p.activities.get((int)3).resources.add(kategorie[0]);
            p.activities.get((int)4).resources.add(kategorie[2]);
            p.activities.get((int)5).resources.add(kategorie[0]);
            ucitele[1].getPreference().set(4, 2);
            tridy[1].getPreference().set(4, 2);
            tridy[0].getPreference().set(4, 1);
            p.activities.get(4).getPreference().set(4, 1);
            kategorie[2].getPreference().set(0, 2);
            p.dependences.add(new TimeActivityDependence(p.activities.get(1), TimeActivityDependence.CLOSELY_AFTER, p.activities.get(0)));
            p.dependences.add(new TimeActivityDependence(p.activities.get(5), TimeActivityDependence.CLOSELY_AFTER, p.activities.get(4)));
            ResourceGroup[] sz = new ResourceGroup[]{new ResourceGroup(ucitele), new ResourceGroup(tridy), new ResourceGroup(kategorie)};
            p.resources = sz;
            Solver s = new Solver(k, p);
            s.setValueSelection(new MinValueSelection(k, new Tabu(k), new SingleActivityEvaluation(k)));
            s.setVariableSelection(new WorstFirstVariableSelection(k));
            s.solve();
            dP = s.solveTime;
            dG = s.generateTime;
            dVP = s.selectVariableTime;
            dVH = s.selectValueTime;
            dT = 0L;
            int n = 0;
            int i = 0;
            while (i < p.activities.size()) {
                System.out.print("Activity: \"" + p.activities.get((int)i).name + "\", zacatek v " + p.activities.get((int)i).start + ", delka " + p.activities.get((int)i).length + ", vyhozeno " + p.activities.get((int)i).nrRemoves + "x \n  resources:");
                if (p.activities.get(i).isScheduled()) {
                    int j = 0;
                    while (j < p.activities.get((int)i).selectedResources.size()) {
                        System.out.print(String.valueOf(p.activities.get((int)i).selectedResources.getResource((int)j).name) + ", ");
                        ++j;
                    }
                    ++n;
                }
                System.out.println("");
                ++i;
            }
            System.out.println("Podarilo se naplanovat " + n + " aktivit z " + p.activities.size() + ".");
            System.out.println("Doba planovani " + dP + " ms.");
            System.out.println("Doba generovani " + dG + " ms.");
            System.out.println("Doba vyberu promenne " + dVP + " ms.");
            System.out.println("Doba vyberu hodnoty " + dVH + " ms.");
            System.out.println("  z toho tabu " + dT + " ms.");
            p.print("SrozvrhV.txt", p.resources[0], 0, 3);
            p.print("SrozvrhU.txt", p.resources[1], 1, 3);
            p.print("SrozvrhT.txt", p.resources[2], 2, 3);
            p.save("SimpleProblem.shd");
            p = Problem.load("SimpleProblem.shd");
            k.closeLog();
        }
        catch (Exception e) {
            System.err.println("Nastala chyba: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

