/*
 * Decompiled with CFR 0.152.
 */
package timetable.solver.strategy;

import timetable.data.Activity;
import timetable.data.ActivityResources;
import timetable.util.Config;
import timetable.util.TimetableException;

public class Tabu {
    protected Activity[] activities;
    protected ActivityResources[] resources;
    protected int[] slots;
    protected int pos = 0;
    public long tabuTime = 0L;

    public Tabu(Config config) throws TimetableException {
        int tabuLength = config.getInt("DELKA_TABU");
        this.activities = new Activity[tabuLength];
        this.slots = new int[tabuLength];
        this.resources = new ActivityResources[tabuLength];
        int i = 0;
        while (i < tabuLength) {
            this.activities[i] = null;
            this.resources[i] = null;
            ++i;
        }
        this.tabuTime = 0L;
        this.pos = 0;
    }

    public void add(Activity a, int slot, ActivityResources g) {
        long start = System.currentTimeMillis();
        this.pos = (this.pos + 1) % this.slots.length;
        this.activities[this.pos] = a;
        this.slots[this.pos] = slot;
        this.resources[this.pos] = (ActivityResources)g.clone();
        this.tabuTime += System.currentTimeMillis() - start;
    }

    public boolean isTabuMove(Activity a, int slot, ActivityResources g) {
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < this.slots.length) {
            if (this.activities[i] == a && this.slots[i] == slot && this.resources[i].equals(g)) {
                this.tabuTime += System.currentTimeMillis() - start;
                return true;
            }
            ++i;
        }
        this.tabuTime += System.currentTimeMillis() - start;
        return false;
    }

    public boolean isTabuMoveTwiceMore(Activity a, int slot, ActivityResources g) {
        boolean onesTabuMove = false;
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < this.slots.length) {
            if (this.activities[i] == a && this.slots[i] == slot && this.resources[i].equals(g)) {
                if (onesTabuMove) {
                    this.tabuTime += System.currentTimeMillis() - start;
                    return true;
                }
                onesTabuMove = true;
            }
            ++i;
        }
        this.tabuTime += System.currentTimeMillis() - start;
        return false;
    }
}

