/*
 * Decompiled with CFR 0.152.
 */
package timetable.school.gui;

import java.util.EventListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import timetable.data.ActivityDependenceGroup;
import timetable.util.ExtendTableModel;
import timetable.util.Loc;

public class DependenceTableModel
implements ExtendTableModel {
    protected EventListenerList listenerList = new EventListenerList();
    protected ActivityDependenceGroup dependences;

    public DependenceTableModel(ActivityDependenceGroup dependences) {
        this.dependences = dependences;
    }

    public Class getColumnClass(int column) {
        Class<?> clazz;
        try {
            clazz = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return clazz;
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return Loc.get("timetable.school.model.deptype");
            }
            case 1: {
                return Loc.get("timetable.school.model.firstact");
            }
            case 2: {
                return Loc.get("timetable.school.model.secondact");
            }
            case 3: {
                return Loc.get("timetable.school.model.param");
            }
        }
        return null;
    }

    public int getRowCount() {
        return this.dependences.size();
    }

    public Object getValueAt(int row, int column) {
        try {
            switch (column) {
                case 0: {
                    return this.dependences.get(row).getDependenceName();
                }
                case 1: {
                    return this.dependences.get((int)row).getFirstActivity().name;
                }
                case 2: {
                    return this.dependences.get((int)row).getSecondActivity().name;
                }
                case 3: {
                    return this.dependences.get(row).getTypes()[this.dependences.get(row).getType()];
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e);
            e.printStackTrace();
        }
        return null;
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void setValueAt(Object value, int row, int column) {
    }

    public int getColumnWidth(int column) {
        switch (column) {
            case 0: {
                return 100;
            }
            case 1: {
                return 100;
            }
            case 2: {
                return 100;
            }
            case 3: {
                return 100;
            }
        }
        return 0;
    }

    public void addTableModelListener(TableModelListener l) {
        Class<?> clazz;
        try {
            clazz = Class.forName("javax.swing.event.TableModelListener");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.listenerList.add(clazz, l);
    }

    public void removeTableModelListener(TableModelListener l) {
        Class<?> clazz;
        try {
            clazz = Class.forName("javax.swing.event.TableModelListener");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.listenerList.remove(clazz, l);
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
    }

    public void fireTableCellUpdated(int row, int column) {
        this.fireTableChanged(new TableModelEvent(this, row, row, column));
    }

    public void fireTableChanged(TableModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Class<?> clazz;
            try {
                clazz = Class.forName("javax.swing.event.TableModelListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            if (listeners[i] == clazz) {
                ((TableModelListener)listeners[i + 1]).tableChanged(e);
            }
            i -= 2;
        }
    }
}

