/*
 * Decompiled with CFR 0.152.
 */
package timetable.school.gui;

import java.util.EventListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import timetable.data.ActivityGroup;
import timetable.data.Resource;
import timetable.data.ResourceGroup;
import timetable.data.TimePreference;
import timetable.util.ExtendTableModel;
import timetable.util.Loc;

public class ActivityTableModel
implements ExtendTableModel {
    protected EventListenerList listenerList = new EventListenerList();
    ActivityGroup activities = null;

    public ActivityTableModel(ActivityGroup activities) {
        this.activities = activities;
    }

    public ActivityTableModel() {
        this(null);
    }

    public void setResources(ActivityGroup activities) {
        this.activities = activities;
    }

    public Class getColumnClass(int column) {
        Class<?> clazz;
        if (column == 2) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz2;
        }
        try {
            clazz = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return clazz;
    }

    public int getColumnCount() {
        return 10;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return Loc.get("timetable.school.model.shortcut");
            }
            case 1: {
                return Loc.get("timetable.school.model.name");
            }
            case 2: {
                return Loc.get("timetable.school.model.length");
            }
            case 3: {
                return Loc.get("timetable.school.model.teacher");
            }
            case 4: {
                return Loc.get("timetable.school.model.classes");
            }
            case 5: {
                return Loc.get("timetable.school.model.rooms");
            }
            case 6: {
                return Loc.get("timetable.school.model.otherres");
            }
            case 7: {
                return Loc.get("timetable.school.model.preferred");
            }
            case 8: {
                return Loc.get("timetable.school.model.forbiden");
            }
            case 9: {
                return Loc.get("timetable.school.model.note");
            }
        }
        return null;
    }

    public int getRowCount() {
        return this.activities.size();
    }

    public Object getValueAt(int row, int column) {
        try {
            switch (column) {
                case 0: {
                    return this.activities.get((int)row).shortCut;
                }
                case 1: {
                    return this.activities.get((int)row).name;
                }
                case 2: {
                    return new Integer(this.activities.get((int)row).length);
                }
                case 3: {
                    if (this.activities.get((int)row).resources.isGroup(1)) {
                        ResourceGroup r = this.activities.get((int)row).resources.getResources(1);
                        return r == null ? "" : (r.shortCut == null ? r.toString() : r.shortCut);
                    }
                    Resource r = this.activities.get((int)row).resources.getResource(1);
                    return r == null ? "" : r.shortCut;
                }
                case 4: {
                    if (this.activities.get((int)row).resources.isGroup(0)) {
                        ResourceGroup r = this.activities.get((int)row).resources.getResources(0);
                        return r == null ? "" : (r.shortCut == null ? r.toString() : r.shortCut);
                    }
                    Resource r = this.activities.get((int)row).resources.getResource(0);
                    return r == null ? "" : r.shortCut;
                }
                case 5: {
                    return this.activities.get((int)row).resources.getResources(2).toString();
                }
                case 6: {
                    ResourceGroup o = this.activities.get((int)row).resources.getResources(3);
                    return o != null ? ((Object)o).toString() : "";
                }
                case 7: {
                    return this.activities.get(row).getPreference().toString(TimePreference.FREE);
                }
                case 8: {
                    return this.activities.get(row).getPreference().toString(TimePreference.HARD);
                }
                case 9: {
                    return this.activities.get((int)row).note;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e);
            e.printStackTrace();
        }
        return null;
    }

    public boolean isCellEditable(int row, int column) {
        switch (column) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
            case 4: {
                return false;
            }
            case 5: {
                return false;
            }
            case 6: {
                return false;
            }
            case 7: {
                return false;
            }
            case 8: {
                return false;
            }
            case 9: {
                return true;
            }
        }
        return false;
    }

    public void setValueAt(Object value, int row, int column) {
        switch (column) {
            case 0: {
                this.activities.get((int)row).shortCut = (String)value;
                this.activities.changed = true;
                return;
            }
            case 1: {
                this.activities.get((int)row).name = (String)value;
                this.activities.changed = true;
                return;
            }
            case 2: {
                this.activities.get((int)row).length = (Integer)value;
                this.activities.changed = true;
                return;
            }
            case 9: {
                this.activities.get((int)row).note = (String)value;
                this.activities.changed = true;
                return;
            }
        }
    }

    public int getColumnWidth(int column) {
        switch (column) {
            case 0: {
                return 50;
            }
            case 1: {
                return 100;
            }
            case 2: {
                return 50;
            }
            case 3: {
                return 50;
            }
            case 4: {
                return 50;
            }
            case 5: {
                return 150;
            }
            case 6: {
                return 150;
            }
            case 7: {
                return 200;
            }
            case 8: {
                return 200;
            }
            case 9: {
                return 200;
            }
        }
        return 0;
    }

    public void addTableModelListener(TableModelListener l) {
        Class<?> clazz;
        try {
            clazz = Class.forName("javax.swing.event.TableModelListener");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.listenerList.add(clazz, l);
    }

    public void removeTableModelListener(TableModelListener l) {
        Class<?> clazz;
        try {
            clazz = Class.forName("javax.swing.event.TableModelListener");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.listenerList.remove(clazz, l);
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
    }

    public void fireTableCellUpdated(int row, int column) {
        this.fireTableChanged(new TableModelEvent(this, row, row, column));
    }

    public void fireTableChanged(TableModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Class<?> clazz;
            try {
                clazz = Class.forName("javax.swing.event.TableModelListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            if (listeners[i] == clazz) {
                ((TableModelListener)listeners[i + 1]).tableChanged(e);
            }
            i -= 2;
        }
    }
}

