/*
 * Decompiled with CFR 0.152.
 */
package timetable.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.MatteBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import timetable.data.Activity;
import timetable.data.Resource;
import timetable.data.ResourceGroup;
import timetable.gui.TimeTableTable;
import timetable.util.Config;
import timetable.util.Loc;
import timetable.util.Math;
import timetable.util.TimetableException;

public class TimeTableModel
extends AbstractTableModel
implements TableCellEditor,
TableCellRenderer,
ActionListener {
    JTextArea textArea;
    JPopupMenu menu;
    JCheckBoxMenuItem menuPin;
    public int menuRow;
    public int menuColumn;
    public static MatteBorder BORDER_PIN = new MatteBorder(2, 2, 2, 2, Color.red);
    public static MatteBorder BORDER_PIN_NL = new MatteBorder(2, 0, 2, 2, Color.red);
    public static MatteBorder BORDER_PIN_NR = new MatteBorder(2, 2, 2, 0, Color.red);
    public static MatteBorder BORDER_PIN_NLR = new MatteBorder(2, 0, 2, 0, Color.red);
    public static Color COLOR_DEFAULT = new Color(255, 255, 255);
    public static Color COLOR_SELECTED = new Color(130, 130, 255);
    public static Color COLOR_NULL = new Color(200, 200, 200);
    public static Color TEXT_NORMAL = new Color(0, 0, 0);
    public static Color TEXT_PIN = new Color(100, 0, 50);
    public static Color BG_HARD = new Color(210, 150, 150);
    public static Color BG_SOFT = new Color(200, 200, 150);
    public static Color BG_SCH_SOFT = new Color(255, 255, 200);
    public static Color BORDER_COLOR = new Color(0, 0, 0);
    public static MatteBorder BORDER_NONE = new MatteBorder(0, 0, 1, 0, BORDER_COLOR);
    public static MatteBorder BORDER_RIGHT = new MatteBorder(0, 0, 1, 1, BORDER_COLOR);
    public ResourceGroup resources = null;
    private Config config = null;
    private int columns = 0;
    private int rows = 0;
    private int slotsPerDay = 0;
    private TimeTableTable table = null;

    public TimeTableModel(Config config, ResourceGroup resources) throws TimetableException {
        this.config = config;
        this.resources = resources;
        this.rows = resources.size();
        config.getInt(Config.NR_DAYS);
        this.columns = config.getInt(Config.NR_SLOTS);
        this.slotsPerDay = config.getInt(Config.NR_SLOTS) / config.getInt(Config.NR_DAYS);
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setBackground(COLOR_DEFAULT);
        this.textArea.setAlignmentX(0.5f);
        this.textArea.setAlignmentY(0.5f);
        this.menu = new JPopupMenu();
        this.menuPin = new JCheckBoxMenuItem(Loc.get("timetable.gui.pin"));
        this.menuPin.addActionListener(this);
        this.menu.add(this.menuPin);
    }

    public void setConfig(Config config) throws TimetableException {
        this.config = config;
        this.rows = this.resources.size();
        config.getInt(Config.NR_DAYS);
        this.columns = config.getInt(Config.NR_SLOTS);
        this.slotsPerDay = config.getInt(Config.NR_SLOTS) / config.getInt(Config.NR_DAYS);
    }

    public void addMenuItem(JMenuItem item) {
        this.menu.add(item);
    }

    public void addMenuSeparator() {
        this.menu.add(new JPopupMenu.Separator());
    }

    public void setTable(TimeTableTable _table) {
        this.table = _table;
        this.table.addMouseListener(new 1());
    }

    public Activity getSelectedActivity() {
        int r = this.table.getSelectedRow();
        int c = this.table.getSelectedColumn();
        if (r < 0 || c <= 0) {
            return null;
        }
        return this.resources.get(r).getActivityAt(c - 1);
    }

    public void setResources(ResourceGroup resources) {
        this.resources = resources;
        this.rows = resources.size();
    }

    public String getColumnName(int column) {
        try {
            if (column == 0) {
                return Loc.get("timetable.resource");
            }
            return String.valueOf(this.config.dayOfWeek(column - 1)) + " " + ((column - 1) % this.slotsPerDay + 1);
        }
        catch (TimetableException e) {
            System.err.println("Error: " + e);
            e.printStackTrace();
            return "Unknown";
        }
    }

    public int getRowCount() {
        return this.rows;
    }

    public int getColumnCount() {
        return this.columns + 1;
    }

    public Activity getActivityAt(int row, int column) {
        if (this.resources == null) {
            return null;
        }
        if (column == 0) {
            return null;
        }
        return this.resources.get(row).getActivityAt(column - 1);
    }

    public Object getValueAt(int row, int column) {
        if (this.resources == null) {
            return null;
        }
        if (column == 0) {
            return this.resources.get((int)row).shortCut;
        }
        if (this.resources.get(row).getActivityAt(column - 1) != null) {
            Resource res = this.resources.get(row);
            Activity a = res.getActivityAt(column - 1);
            if (a.start != column - 1) {
                return "";
            }
            StringBuffer r = new StringBuffer();
            r.append(a.shortCut);
            int i = 0;
            while (i < a.selectedResources.size()) {
                if (a.selectedResources.isGroup(i)) {
                    boolean isIn = false;
                    int k = 0;
                    while (k < a.selectedResources.getResources(i).size() && !isIn) {
                        if (a.selectedResources.getResources(i).get(k) == res) {
                            isIn = true;
                        }
                        ++k;
                    }
                    if (!isIn) {
                        r.append("\n").append(a.selectedResources.getResources(i).toString());
                    }
                } else if (a.selectedResources.getResource(i) != res) {
                    r.append("\n").append(a.selectedResources.getResource((int)i).shortCut);
                }
                ++i;
            }
            return r.toString();
        }
        return null;
    }

    public boolean getPinAt(int row, int column) {
        if (this.resources == null || column == 0) {
            return false;
        }
        if (this.resources.get(row).getActivityAt(column - 1) != null) {
            return !this.resources.get((int)row).getActivityAt((int)(column - 1)).canReschedule;
        }
        return false;
    }

    public void setPinAt(int row, int column, boolean pin) {
        if (this.resources == null || column == 0) {
            return;
        }
        if (this.resources.get(row).getActivityAt(column - 1) == null) {
            return;
        }
        this.resources.get((int)row).getActivityAt((int)(column - 1)).canReschedule = !pin;
    }

    public boolean isCellEditable(int row, int column) {
        if (this.resources == null || column == 0) {
            return false;
        }
        return this.resources.get(row).getActivityAt(column - 1) != null;
    }

    public Class getColumnClass(int c) {
        Class<?> clazz;
        try {
            clazz = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return clazz;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return null;
    }

    public void cancelCellEditing() {
    }

    public boolean stopCellEditing() {
        return true;
    }

    public Object getCellEditorValue() {
        return this.textArea.getText();
    }

    public boolean shouldSelectCell(EventObject p1) {
        return true;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return false;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.textArea.setText(value == null ? "" : value.toString());
        this.textArea.setBorder(BORDER_RIGHT);
        if (column == 0) {
            this.textArea.setBackground(COLOR_SELECTED);
            return this.textArea;
        }
        if (this.resources == null) {
            return null;
        }
        Resource r = this.resources.get(row);
        Activity a = r.getActivityAt(column - 1);
        int soft = 0;
        this.textArea.setToolTipText(null);
        if (a != null) {
            int i = 0;
            while (i < a.length) {
                int s = a.start + i;
                if (a.getPreference().isSOFT(s)) {
                    ++soft;
                }
                int j = 0;
                while (j < a.selectedResources.size()) {
                    if (a.selectedResources.isGroup(j)) {
                        int k = 0;
                        while (k < a.selectedResources.getResources(j).size()) {
                            if (a.selectedResources.getResources(j).get(k) != null && a.selectedResources.getResources(j).get(k).getPreference().isSOFT(s)) {
                                ++soft;
                            }
                            ++k;
                        }
                    } else if (a.selectedResources.getResource(j) != null && a.selectedResources.getResource(j).getPreference().isSOFT(s)) {
                        ++soft;
                    }
                    ++j;
                }
                ++i;
            }
            this.textArea.setToolTipText(a.name);
        }
        if (value == null) {
            if (r.getPreference().isHARD(column - 1)) {
                this.textArea.setBackground(BG_HARD);
            } else if (r.getPreference().isSOFT(column - 1)) {
                this.textArea.setBackground(BG_SOFT);
            } else {
                this.textArea.setBackground(COLOR_NULL);
            }
        } else {
            if (hasFocus || a == this.getSelectedActivity()) {
                this.textArea.setBackground(COLOR_SELECTED);
            } else if (soft > 0) {
                this.textArea.setBackground(new Color(255, 255, Math.max2(0, 255 - 30 * soft)));
            } else {
                this.textArea.setBackground(COLOR_DEFAULT);
            }
            if (a != null) {
                if (a.start + a.length == column) {
                    this.textArea.setBorder(BORDER_RIGHT);
                } else {
                    this.textArea.setBorder(BORDER_NONE);
                }
            }
        }
        if (this.getPinAt(row, column) && a != null) {
            if (a.length == 1) {
                this.textArea.setBorder(BORDER_PIN);
            } else if (a.start + 1 != column && a.start + a.length == column) {
                this.textArea.setBorder(BORDER_PIN_NL);
            } else if (a.start + 1 == column && a.start + a.length != column) {
                this.textArea.setBorder(BORDER_PIN_NR);
            } else {
                this.textArea.setBorder(BORDER_PIN_NLR);
            }
        }
        if (hasFocus) {
            this.menuPin.setSelected(this.getPinAt(row, column));
        }
        return this.textArea;
    }

    public void addCellEditorListener(CellEditorListener p1) {
    }

    public void removeCellEditorListener(CellEditorListener p1) {
    }

    public void actionPerformed(ActionEvent p1) {
        if (p1.getSource() == this.menuPin) {
            Activity a = this.resources.get(this.menuRow).getActivityAt(this.menuColumn - 1);
            a.canReschedule = !a.canReschedule;
            this.table.updateUI();
        }
    }

    static /* synthetic */ void access$1(TimeTableModel accsParam$0, TimeTableTable accParam$1) {
        accsParam$0.table = accParam$1;
    }

    private final class 1
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            TimeTableModel.this.table.updateUI();
            Point p = new Point(e.getX(), e.getY());
            if ((e.getModifiers() & 4) > 0 && TimeTableModel.this.isCellEditable(TimeTableModel.this.table.rowAtPoint(p), TimeTableModel.this.table.columnAtPoint(p))) {
                TimeTableModel.this.menuRow = TimeTableModel.this.table.rowAtPoint(p);
                TimeTableModel.this.menuColumn = TimeTableModel.this.table.columnAtPoint(p);
                TimeTableModel.this.menuPin.setSelected(TimeTableModel.this.getPinAt(TimeTableModel.this.menuRow, TimeTableModel.this.menuColumn));
                TimeTableModel.this.menu.show(TimeTableModel.this.table, e.getX(), e.getY());
            }
        }

        /* synthetic */ 1() {
        }
    }
}

