/*
 * Decompiled with CFR 0.152.
 */
package timetable.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.LineBorder;
import timetable.data.TimePreference;
import timetable.util.Config;
import timetable.util.Loc;
import timetable.util.TimetableException;

public class TimePreferencePanel
extends JPanel
implements ActionListener {
    public static Color BG_NORMAL = new Color(255, 255, 255);
    public static Color BG_HARD = new Color(210, 150, 150);
    public static Color BG_SOFT = new Color(200, 200, 150);
    public static LineBorder BORDER_DEFAULT = new LineBorder(Color.darkGray, 1);
    public static Color COLOR_HEAD = new Color(120, 120, 255);
    private JPopupMenu menu;
    private JMenuItem mNormal;
    private JMenuItem mSoft;
    private JMenuItem mHard;

    public TimePreferencePanel(Config config, TimePreference preference) throws TimetableException {
        int NrRows = config.getInt(Config.NR_DAYS);
        if (NrRows == 0) {
            NrRows = 5;
        }
        int slots = config.getInt(Config.NR_SLOTS);
        int NrColumns = slots / NrRows;
        this.menu = new JPopupMenu();
        this.mNormal = new JMenuItem(Loc.get("timetable.gui.preferrence.normal"));
        this.mSoft = new JMenuItem(Loc.get("timetable.gui.preferrence.soft"));
        this.mHard = new JMenuItem(Loc.get("timetable.gui.preferrence.hard"));
        this.menu.add(this.mNormal);
        this.menu.add(this.mSoft);
        this.menu.add(this.mHard);
        this.mNormal.addActionListener(this);
        this.mSoft.addActionListener(this);
        this.mHard.addActionListener(this);
        this.setLayout(new GridLayout(NrRows + 1, NrColumns + 1, 0, 0));
        this.add(new OnePrefPanel(""));
        int i = 0;
        while (i < NrColumns) {
            this.add(new OnePrefPanel("" + (i + 1)));
            ++i;
        }
        i = 0;
        while (i < slots) {
            if (i % NrColumns == 0) {
                this.add(new OnePrefPanel(config.dayOfWeek(i)));
            }
            this.add(new OnePrefPanel(preference, i));
            ++i;
        }
        this.setPreferredSize(new Dimension((1 + NrColumns) * 20, (1 + NrRows) * 20));
    }

    private void initComponents() {
        this.setLayout(new GridLayout(5, 10));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mNormal) {
            ((OnePrefPanel)this.menu.getInvoker()).setFree();
        }
        if (e.getSource() == this.mSoft) {
            ((OnePrefPanel)this.menu.getInvoker()).setSoft();
        }
        if (e.getSource() == this.mHard) {
            ((OnePrefPanel)this.menu.getInvoker()).setHard();
        }
    }

    static /* synthetic */ void access$1(TimePreferencePanel accsParam$0, JPopupMenu accParam$1) {
        accsParam$0.menu = accParam$1;
    }

    public class OnePrefPanel
    extends JPanel {
        private TimePreference preference;
        private int slot;
        private boolean selected = false;

        public OnePrefPanel(String text) {
            this.setPreferredSize(new Dimension(20, 20));
            this.setBorder(BORDER_DEFAULT);
            this.setBackground(COLOR_HEAD);
            this.add(new JLabel(text));
        }

        public OnePrefPanel(TimePreference preference, int slot) {
            this.preference = preference;
            this.slot = slot;
            if (preference.isHARD(slot)) {
                this.setBackground(BG_HARD);
            } else if (preference.isSOFT(slot)) {
                this.setBackground(BG_SOFT);
            } else {
                this.setBackground(BG_NORMAL);
            }
            this.setPreferredSize(new Dimension(20, 20));
            this.setBorder(BORDER_DEFAULT);
            this.addMouseListener(new 1());
        }

        public void setFree() {
            this.preference.setFREE(this.slot);
            this.setBackground(BG_NORMAL);
        }

        public void setSoft() {
            this.preference.setSOFT(this.slot);
            this.setBackground(BG_SOFT);
        }

        public void setHard() {
            this.preference.setHARD(this.slot);
            this.setBackground(BG_HARD);
        }

        private final class 1
        extends MouseAdapter {
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 4) > 0) {
                    TimePreferencePanel.this.menu.show(OnePrefPanel.this, e.getX(), e.getY());
                }
                if ((e.getModifiers() & 0x10) > 0) {
                    if (e.isControlDown()) {
                        OnePrefPanel.this.setHard();
                    } else if (e.isAltDown()) {
                        OnePrefPanel.this.setSoft();
                    } else {
                        OnePrefPanel.this.setFree();
                    }
                }
            }

            /* synthetic */ 1() {
            }
        }
    }
}

