/*
 * Decompiled with CFR 0.152.
 */
package timetable.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import timetable.data.ActivityGroup;
import timetable.data.Resource;
import timetable.util.Config;
import timetable.util.TimetableException;

public class ResourceGroup {
    protected Vector resources = new Vector();
    public String shortCut = null;
    public String note = null;
    public String name = null;
    public boolean changed = false;
    public boolean conjunctive = false;

    public ResourceGroup() {
    }

    public ResourceGroup(String name) {
        this.name = name;
    }

    public ResourceGroup(Resource resource) {
        this.resources.add(resource);
    }

    public ResourceGroup(Resource[] resource) {
        int i = 0;
        while (i < resource.length) {
            this.resources.add(resource[i]);
            ++i;
        }
    }

    public void setName(String name) {
        this.name = name;
        this.changed = true;
    }

    public String getName() {
        return this.name;
    }

    public void add(Resource resource) {
        this.resources.add(resource);
        this.changed = true;
    }

    public void remove(Resource resource) {
        this.resources.remove(resource);
        this.changed = true;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean isInGroup(Resource resource) {
        int i = 0;
        while (i < this.size()) {
            if (this.get(i) == resource) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void removeAll() {
        this.resources.clear();
    }

    public int size() {
        return this.resources.size();
    }

    public Resource get(int i) {
        try {
            return (Resource)this.resources.get(i);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public void set(int i, Resource resource) {
        this.resources.set(i, resource);
    }

    public int indexOf(Resource resource) {
        return this.resources.indexOf(resource);
    }

    public boolean isOneFreeAt(int slot, int length) {
        int i = 0;
        while (i < this.size()) {
            if (this.get(i).isFreeAt(slot, length)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isAllFreeAt(int slot, int length) {
        int i = 0;
        while (i < this.size()) {
            if (!this.get(i).isFreeAt(slot, length)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean canOneBeFreeAt(int slot, int length) {
        int i = 0;
        while (i < this.size()) {
            if (this.get(i).canBeFreeAt(slot, length)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean canAllBeFreeAt(int slot, int length) {
        int i = 0;
        while (i < this.size()) {
            if (!this.get(i).canBeFreeAt(slot, length)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int countFreeAt(int slot, int length) {
        int sum = 0;
        int i = 0;
        while (i < this.size()) {
            if (this.get(i).isFreeAt(slot, length)) {
                ++sum;
            }
            ++i;
        }
        return sum;
    }

    public ResourceGroup getFreeAt(int slot, int length) {
        ResourceGroup g = new ResourceGroup();
        boolean free = true;
        int i = 0;
        while (i < this.size()) {
            if (this.get(i).isFreeAt(slot, length)) {
                g.add(this.get(i));
            }
            ++i;
        }
        return g;
    }

    public Object clone() {
        ResourceGroup g = new ResourceGroup();
        g.setName(this.getName());
        g.note = this.note;
        g.shortCut = this.shortCut;
        g.conjunctive = this.conjunctive;
        int i = 0;
        while (i < this.size()) {
            g.add(this.get(i));
            ++i;
        }
        return g;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof ResourceGroup) {
            ResourceGroup g = (ResourceGroup)o;
            if (this.shortCut == null && this.shortCut != g.shortCut) {
                return false;
            }
            if (this.shortCut != null && !this.shortCut.equals(g.shortCut)) {
                return false;
            }
            if (this.name == null && this.name != g.name) {
                return false;
            }
            if (this.name != null && !this.name.equals(g.name)) {
                return false;
            }
            if (this.conjunctive != g.conjunctive) {
                return false;
            }
            if (this.size() != g.size()) {
                return false;
            }
            int i = 0;
            while (i < this.size()) {
                if (g.get(i) != this.get(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean haveSameContent(ResourceGroup r) {
        if (r == null) {
            return false;
        }
        if (r.size() != this.size()) {
            return false;
        }
        int i = 0;
        while (i < this.size()) {
            if (r.indexOf(this.get(i)) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void write(ObjectOutputStream out, ActivityGroup allActivities) throws IOException {
        out.writeInt(this.size());
        int i = 0;
        while (i < this.size()) {
            this.get(i).write(out, allActivities);
            ++i;
        }
    }

    protected static ResourceGroup read(ObjectInputStream in, Config config) throws IOException, ClassNotFoundException, TimetableException {
        int nrResources = in.readInt();
        ResourceGroup g = new ResourceGroup();
        int i = 0;
        while (i < nrResources) {
            g.add(Resource.read(in, config));
            ++i;
        }
        return g;
    }

    protected void init(ActivityGroup allActivities) {
        int i = 0;
        while (i < this.size()) {
            this.get(i).init(allActivities);
            ++i;
        }
    }

    protected void write(ObjectOutputStream out, ResourceGroup allResources) throws IOException {
        out.writeObject(this.name);
        out.writeObject(this.shortCut);
        out.writeObject(this.note);
        out.writeBoolean(this.conjunctive);
        out.writeInt(this.size());
        int i = 0;
        while (i < this.size()) {
            this.get(i).write(out, allResources);
            ++i;
        }
        this.changed = false;
    }

    protected static ResourceGroup read(ObjectInputStream in, ResourceGroup allResources) throws IOException, ClassNotFoundException {
        String name = (String)in.readObject();
        String shortCut = (String)in.readObject();
        String note = (String)in.readObject();
        boolean conjunctive = in.readBoolean();
        int nrResources = in.readInt();
        ResourceGroup g = new ResourceGroup();
        g.name = name;
        g.shortCut = shortCut;
        g.note = note;
        g.conjunctive = conjunctive;
        int i = 0;
        while (i < nrResources) {
            g.add(Resource.read(in, allResources));
            ++i;
        }
        return g;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("{");
        int i = 0;
        while (i < this.size()) {
            if (i != 0) {
                b.append(", ");
            }
            b.append(this.get((int)i).shortCut);
            ++i;
        }
        b.append("}");
        return b.toString();
    }
}

