/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.classfile;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Hashtable;
import sunw.demo.classfile.ClassFile;
import sunw.demo.classfile.Code;
import sunw.demo.classfile.FieldConstant;
import sunw.demo.classfile.FieldDesc;
import sunw.demo.classfile.MethodConstant;
import sunw.demo.classfile.MethodDesc;

public final class DelegatorClassFile {
    private Class[] targets;
    private FieldConstant[] fields;
    private static String superclassName;
    private String className;
    private ClassFile classFile;
    private Hashtable generatedMethods = new Hashtable();
    private char[] buff = new char[200];
    private int ix;

    public DelegatorClassFile(String string, Class[] classArray) throws IOException, ClassNotFoundException {
        this.className = string;
        this.targets = classArray;
        superclassName = this.targets[0].getName();
        this.classFile = new ClassFile(string, this.targets[0].getName());
        this.allocateFields();
        this.recordInheritedMethods();
        this.generateDelegatedMethods();
        this.generateConstructor();
    }

    private void allocateFields() {
        this.fields = new FieldConstant[this.targets.length];
        int n = 1;
        while (n < this.targets.length) {
            FieldConstant fieldConstant;
            String string = "t" + n;
            String string2 = this.getInternalTypeString(this.targets[n]);
            this.classFile.addFieldDesc(new FieldDesc(string, string2, 2, this.classFile, null));
            this.fields[n] = fieldConstant = this.classFile.addFieldConstant(this.className, string, string2);
            ++n;
        }
    }

    private void recordInheritedMethods() {
        Method[] methodArray = this.targets[0].getMethods();
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            String string = this.getMethodTypeString(method);
            String string2 = method.getName() + string;
            this.generatedMethods.put(string2, string2);
            ++n;
        }
    }

    private void generateDelegatedMethods() {
        int n = 0;
        while (n < this.targets.length) {
            BeanInfo beanInfo;
            Class clazz = this.targets[n];
            try {
                beanInfo = Introspector.getBeanInfo(clazz);
            }
            catch (IntrospectionException introspectionException) {
                System.err.println("Introspection failed on " + clazz);
                return;
            }
            MethodDescriptor[] methodDescriptorArray = beanInfo.getMethodDescriptors();
            int n2 = 0;
            while (n2 < methodDescriptorArray.length) {
                MethodDescriptor methodDescriptor = methodDescriptorArray[n2];
                Method method = methodDescriptor.getMethod();
                this.generateDelegateMethod(this.fields[n], method);
                ++n2;
            }
            ++n;
        }
    }

    private void generateConstructor() {
        Code code = new Code(this.classFile, (short)(this.targets.length + 2), (short)(this.targets.length + 4));
        String string = "(";
        int n = 1;
        while (n < this.targets.length) {
            string = string + this.getInternalTypeString(this.targets[n]);
            ++n;
        }
        string = string + ")V";
        code.addOp((byte)42);
        MethodConstant methodConstant = this.classFile.addMethodConstant(ClassFile.fullyQualifiedForm(superclassName), "<init>", "()V");
        code.addOpShort((byte)-73, methodConstant.getConstantPoolIndex());
        int n2 = 1;
        while (n2 < this.fields.length) {
            code.addOp((byte)42);
            this.pushArg(code, this.targets[n2], n2);
            code.addOpShort((byte)-75, this.fields[n2].getConstantPoolIndex());
            ++n2;
        }
        code.addOp((byte)-79);
        this.classFile.addMethodDesc(new MethodDesc("<init>", string, 1, this.classFile, code));
    }

    private void generateDelegateMethod(FieldConstant fieldConstant, Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        String string = this.getMethodTypeString(method);
        String string2 = method.getName() + string;
        if (this.generatedMethods.get(string2) != null) {
            return;
        }
        this.generatedMethods.put(string2, string2);
        Code code = new Code(this.classFile, (short)(classArray.length + 2), (short)(2 + 2 * classArray.length));
        code.addOp((byte)42);
        code.addOpShort((byte)-76, fieldConstant.getConstantPoolIndex());
        int n = 0;
        while (n < classArray.length) {
            this.pushArg(code, classArray[n], n + 1);
            ++n;
        }
        MethodConstant methodConstant = this.classFile.addMethodConstant(method.getDeclaringClass().getName().replace('.', '/'), method.getName(), string);
        code.addOpShort((byte)-74, methodConstant.getConstantPoolIndex());
        this.generateReturn(code, method.getReturnType());
        MethodDesc methodDesc = new MethodDesc(method.getName(), string, 1, this.classFile, code);
        this.classFile.addMethodDesc(methodDesc);
    }

    void pushArg(Code code, Class clazz, int n) {
        int n2;
        byte by;
        if (clazz.isPrimitive()) {
            if (clazz == Long.TYPE) {
                by = 22;
                n2 = 30;
            } else if (clazz == Float.TYPE) {
                by = 23;
                n2 = 34;
            } else if (clazz == Double.TYPE) {
                by = 24;
                n2 = 38;
            } else {
                by = 21;
                n2 = 26;
            }
        } else {
            by = 25;
            n2 = 42;
        }
        if (n < 4) {
            code.addOp((byte)(n2 + n));
        } else {
            code.addOp1(by, (byte)n);
        }
    }

    void generateReturn(Code code, Class clazz) {
        int n = clazz.isPrimitive() ? (clazz == Void.TYPE ? -79 : (clazz == Long.TYPE ? -83 : (clazz == Float.TYPE ? -82 : (clazz == Double.TYPE ? -81 : -84)))) : -80;
        code.addOp((byte)n);
    }

    public void write(OutputStream outputStream) throws IOException {
        this.classFile.write(outputStream);
    }

    private String getInternalTypeString(Class clazz) {
        this.ix = 0;
        this.push(clazz);
        return new String(this.buff, 0, this.ix);
    }

    private String getMethodTypeString(Method method) {
        this.ix = 0;
        try {
            this.buff[this.ix++] = 40;
            Class<?>[] classArray = method.getParameterTypes();
            int n = 0;
            while (n < classArray.length) {
                this.push(classArray[n]);
                ++n;
            }
            this.buff[this.ix++] = 41;
            this.push(method.getReturnType());
            return new String(this.buff, 0, this.ix);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (this.ix >= this.buff.length) {
                this.buff = new char[2 * this.buff.length];
                return this.getMethodTypeString(method);
            }
            throw arrayIndexOutOfBoundsException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void push(Class clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            this.buff[this.ix++] = 91;
        }
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                this.buff[this.ix++] = 86;
                return;
            } else if (clazz == Integer.TYPE) {
                this.buff[this.ix++] = 73;
                return;
            } else if (clazz == Boolean.TYPE) {
                this.buff[this.ix++] = 90;
                return;
            } else if (clazz == Long.TYPE) {
                this.buff[this.ix++] = 74;
                return;
            } else if (clazz == Float.TYPE) {
                this.buff[this.ix++] = 70;
                return;
            } else if (clazz == Double.TYPE) {
                this.buff[this.ix++] = 68;
                return;
            } else if (clazz == Character.TYPE) {
                this.buff[this.ix++] = 67;
                return;
            } else if (clazz == Byte.TYPE) {
                this.buff[this.ix++] = 66;
                return;
            } else {
                if (clazz != Short.TYPE) throw new Error("Unexpected primitive type " + clazz.getName());
                this.buff[this.ix++] = 83;
            }
            return;
        } else {
            this.buff[this.ix++] = 76;
            String string = clazz.getName();
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                int n3 = string.charAt(n2);
                if (n3 == 46) {
                    n3 = 47;
                }
                this.buff[this.ix++] = n3;
                ++n2;
            }
            this.buff[this.ix++] = 59;
        }
    }
}

